/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa;

import ec.satoolkit.GenericSaResults;
import ec.tss.sa.ISaReport;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.modelling.arima.ModelDescription;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.tramo.TramoProcessor;
import ec.tstoolkit.sarima.SarimaComponent;
import ec.tstoolkit.sarima.SarimaSpecification;
import ec.tstoolkit.stats.LjungBoxTest;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.regression.ILengthOfPeriodVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.utilities.DoubleList;
import java.util.HashMap;
import java.util.Map;

public class RegArimaReport
implements ISaReport {
    private final int freq_;
    private final DoubleList lb_ = new DoubleList();
    private final Map<SarimaSpecification, Integer> arima_ = new HashMap<SarimaSpecification, Integer>();
    public int Total;
    public int NUndecompsable;
    public int TdCount;
    public int LogCount;
    public int LpCount;
    public int EasterCount;
    public int AoCount;
    public int LsCount;
    public int TcCount;
    public int SoCount;
    public int MeanCount;
    public long T0;
    public long T1;

    public RegArimaReport(int freq) {
        this.freq_ = freq;
    }

    public int getFrequency() {
        return this.freq_;
    }

    public SarimaSpecification[] getModels() {
        SarimaSpecification[] m = (SarimaSpecification[])this.arima_.keySet().stream().toArray(SarimaSpecification[]::new);
        return m;
    }

    public int getModelCount(SarimaSpecification spec) {
        int n = 0;
        try {
            n = this.arima_.get(spec);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    @Override
    public void start() {
        this.clear();
        this.T0 = System.currentTimeMillis();
    }

    protected void clear() {
        this.lb_.clear();
        this.Total = 0;
        this.TdCount = 0;
        this.LpCount = 0;
        this.EasterCount = 0;
        this.LogCount = 0;
        this.AoCount = 0;
        this.LsCount = 0;
        this.TcCount = 0;
        this.SoCount = 0;
        this.MeanCount = 0;
    }

    @Override
    public void end() {
        this.T1 = System.currentTimeMillis();
    }

    @Override
    public boolean add(CompositeResults rslts) {
        if (rslts == null) {
            return false;
        }
        PreprocessingModel mdl = GenericSaResults.getPreprocessingModel((CompositeResults)rslts);
        if (mdl != null) {
            ++this.Total;
            try {
                this.addArima(mdl.description.getArimaComponent());
                this.addTransform(mdl.isMultiplicative());
                this.addCalendar(mdl.description);
                this.addOutliers(mdl.description);
                this.addStats(mdl.description.getArimaComponent().getFreeParametersCount(), mdl.getFullResiduals());
                return true;
            }
            catch (Exception err) {
                return false;
            }
        }
        return false;
    }

    private void addArima(SarimaComponent arima) {
        SarimaSpecification spec = arima.getSpecification();
        Integer count = this.arima_.get(spec);
        if (count == null) {
            this.arima_.put(spec, 1);
        } else {
            this.arima_.put(spec, count + 1);
        }
        if (arima.isMean()) {
            ++this.MeanCount;
        }
    }

    private void addStats(int np, TsData residuals) {
        if (residuals == null) {
            return;
        }
        try {
            LjungBoxTest lb = new LjungBoxTest();
            lb.setHyperParametersCount(np);
            lb.setK(TramoProcessor.calcLBLength((int)this.freq_));
            lb.test((IReadDataBlock)residuals);
            if (lb.isValid()) {
                this.lb_.add(lb.getValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addCalendar(ModelDescription desc) {
        int ntd = desc.countRegressors(var -> var.isCalendar() && var.status.isSelected());
        int nftd = desc.countFixedRegressors(var -> var.isCalendar());
        int nlp = desc.countRegressors(var -> var.getVariable() instanceof ILengthOfPeriodVariable && var.status.isSelected());
        int nflp = desc.countFixedRegressors(var -> var.getVariable() instanceof ILengthOfPeriodVariable);
        ntd -= nftd;
        int nee = desc.countRegressors(var -> var.isMovingHoliday() && var.status.isSelected());
        int nfee = desc.countFixedRegressors(var -> var.isMovingHoliday());
        if (ntd > 0 || (nftd -= nflp) > 0) {
            ++this.TdCount;
        }
        if (desc.getLengthOfPeriodType() != LengthOfPeriodType.None || nlp > 0 || nflp > 0) {
            ++this.LpCount;
        }
        if (nee > 0 || nfee > 0) {
            ++this.EasterCount;
        }
    }

    private void addOutliers(ModelDescription desc) {
        this.AoCount += this.countOutlier(desc, OutlierType.AO.name());
        this.LsCount += this.countOutlier(desc, OutlierType.LS.name());
        this.TcCount += this.countOutlier(desc, OutlierType.TC.name());
        this.SoCount += this.countOutlier(desc, OutlierType.SO.name());
    }

    private int countOutlier(ModelDescription desc, String code) {
        int n = desc.countRegressors(var -> var.isOutlier() && ((IOutlierVariable)var.getVariable()).getCode().equals(code));
        int nf = desc.countFixedRegressors(var -> var.isOutlier() && ((IOutlierVariable)var.getVariable()).getCode().equals(code));
        return n + nf;
    }

    private void addTransform(boolean multiplicative) {
        if (multiplicative) {
            ++this.LogCount;
        }
    }
}

