/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa;

import com.google.common.base.Strings;
import ec.satoolkit.ISaSpecification;
import ec.tss.Ts;
import ec.tss.TsFactory;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tss.TsStatus;
import ec.tss.sa.EstimationPolicyType;
import ec.tss.sa.ISaProcessingFactory;
import ec.tss.sa.SaManager;
import ec.tss.sa.documents.SaDocument;
import ec.tstoolkit.MetaData;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.ProcDiagnostic;
import ec.tstoolkit.algorithm.ProcQuality;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetHelper;
import ec.tstoolkit.information.ProxyResults;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.utilities.Arrays2;
import ec.tstoolkit.utilities.NameManager;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class SaItem {
    public static final String DOMAIN_SPEC = "domainspec";
    public static final String ESTIMATION_SPEC = "estimationspec";
    public static final String POINT_SPEC = "pointspec";
    public static final String TS = "ts";
    public static final String QUALITY = "quality";
    public static final String PRIORITY = "priority";
    public static final String POLICY = "policy";
    public static final String METADATA = "metadata";
    public static final String NAME = "name";
    public static final String COMMENT = "comment";
    public static final String DIAGNOSTICS = "diagnostics";
    private static final String DIAGNOSTICS_INTERNAL = "__diagnostics";
    private final AtomicInteger id_ = new AtomicInteger(-1);
    private boolean dirty_ = true;
    private Ts ts_;
    private ISaSpecification pspec_;
    private ISaSpecification espec_;
    private ISaSpecification dspec_;
    private boolean cacheResults_ = true;
    private volatile CompositeResults rslts_;
    private EstimationPolicyType estimation_ = EstimationPolicyType.None;
    private Status status_ = Status.Unprocessed;
    private int priority_ = -1;
    private ProcQuality quality_ = ProcQuality.Undefined;
    private String[] warnings_;
    private InformationSet qsummary_;
    private MetaData metaData_;
    private String name = "";
    private boolean locked_;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SaItem makeCopy() {
        AtomicInteger atomicInteger = this.id_;
        synchronized (atomicInteger) {
            SaItem n = new SaItem();
            n.dspec_ = this.dspec_;
            n.espec_ = this.espec_;
            n.pspec_ = this.pspec_;
            n.estimation_ = this.estimation_;
            n.locked_ = this.locked_;
            n.qsummary_ = this.qsummary_;
            n.priority_ = this.priority_;
            n.quality_ = this.quality_;
            n.rslts_ = this.rslts_;
            n.status_ = this.status_;
            n.ts_ = this.ts_;
            n.warnings_ = this.warnings_;
            n.cacheResults_ = this.cacheResults_;
            n.metaData_ = this.metaData_ == null ? null : this.metaData_.clone();
            n.name = this.name;
            return n;
        }
    }

    SaItem() {
    }

    void setKey(int key) {
        this.id_.set(key);
    }

    public SaItem(ISaSpecification dspec, EstimationPolicyType policy, ISaSpecification espec, Ts s) {
        this.dspec_ = dspec;
        this.estimation_ = policy;
        this.espec_ = espec;
        this.ts_ = s.freeze();
    }

    public SaItem(ISaSpecification dspec, Ts s) {
        this.dspec_ = dspec;
        this.estimation_ = EstimationPolicyType.Complete;
        this.ts_ = s.freeze();
    }

    public SaItem newSpecification(Ts s, ISaSpecification espec, EstimationPolicyType policy) {
        SaItem nitem = new SaItem();
        nitem.name = this.name;
        nitem.dspec_ = this.dspec_;
        nitem.ts_ = s.freeze();
        if (espec != null) {
            nitem.espec_ = espec;
            nitem.estimation_ = policy;
        } else {
            nitem.estimation_ = EstimationPolicyType.Complete;
        }
        nitem.priority_ = this.priority_;
        nitem.metaData_ = this.metaData_;
        return nitem;
    }

    public SaItem newSpecification(ISaSpecification espec, EstimationPolicyType policy) {
        return this.newSpecification(this.ts_, espec, policy);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getEstimationSpecification());
        String item = this.getName();
        if (!item.isEmpty()) {
            builder.append(" - ").append(item);
        }
        return builder.toString();
    }

    public MetaData getMetaData() {
        return this.metaData_;
    }

    public void setMetaData(MetaData md) {
        this.metaData_ = md;
        this.dirty_ = true;
    }

    public String getComment() {
        if (this.metaData_ != null && this.metaData_.containsKey((Object)COMMENT)) {
            return this.metaData_.get((Object)COMMENT);
        }
        return null;
    }

    public void setComment(String comment) {
        if (this.metaData_ == null) {
            this.metaData_ = new MetaData();
        }
        if (Strings.isNullOrEmpty((String)comment)) {
            this.metaData_.remove((Object)COMMENT);
        } else {
            this.metaData_.put(COMMENT, comment);
        }
        this.dirty_ = true;
    }

    public String getName() {
        return !this.name.isEmpty() ? (this.ts_ != null && this.ts_.isFrozen() ? this.name + " [frozen]" : this.name) : (this.ts_ != null ? this.ts_.getName() : "");
    }

    public String getRawName() {
        return this.name;
    }

    public void setName(String name) {
        String oldName = this.name;
        String newName = Strings.nullToEmpty((String)name);
        if (!oldName.equals(newName)) {
            this.name = newName;
            this.dirty_ = true;
        }
    }

    public int getPriority() {
        return this.priority_;
    }

    public void setPriority(int value) {
        if (value != this.priority_) {
            this.priority_ = value < 0 ? 0 : (value > 10 ? 10 : value);
            this.dirty_ = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcQuality getQuality() {
        AtomicInteger atomicInteger = this.id_;
        synchronized (atomicInteger) {
            return this.quality_;
        }
    }

    public void setQuality(ProcQuality value) {
        if (this.quality_ != value) {
            boolean recalc = this.quality_ == ProcQuality.Accepted && value == ProcQuality.Undefined;
            this.quality_ = value;
            if (recalc) {
                this.quality_ = ProcDiagnostic.summary((InformationSet)this.getDiagnostics());
            }
            this.dirty_ = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InformationSet getDiagnostics() {
        AtomicInteger atomicInteger = this.id_;
        synchronized (atomicInteger) {
            if (this.qsummary_ == null) {
                this.process();
            }
            return this.qsummary_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getWarnings() {
        AtomicInteger atomicInteger = this.id_;
        synchronized (atomicInteger) {
            if (this.qsummary_ == null) {
                this.process();
            }
            return this.warnings_ == null ? Arrays2.EMPTY_STRING_ARRAY : this.warnings_;
        }
    }

    public Ts getTs() {
        return this.ts_;
    }

    public TsMoniker getMoniker() {
        return this.ts_.getMoniker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status getStatus() {
        AtomicInteger atomicInteger = this.id_;
        synchronized (atomicInteger) {
            return this.status_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(Status value) {
        AtomicInteger atomicInteger = this.id_;
        synchronized (atomicInteger) {
            this.status_ = value;
        }
    }

    public AlgorithmDescriptor getEstimationMethod() {
        ISaSpecification spec = this.getEstimationSpecification();
        if (spec == null) {
            return null;
        }
        return SaManager.instance.find((IProcSpecification)spec).getInformation();
    }

    public ISaSpecification getEstimationSpecification() {
        return this.espec_ != null ? this.espec_ : this.dspec_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public ISaSpecification getActiveSpecification() {
        AtomicInteger atomicInteger = this.id_;
        synchronized (atomicInteger) {
            if (this.pspec_ == null) {
                return this.getEstimationSpecification();
            }
            return this.pspec_;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISaSpecification getPointSpecification() {
        AtomicInteger atomicInteger = this.id_;
        synchronized (atomicInteger) {
            return this.pspec_;
        }
    }

    public void setPointSpecification(ISaSpecification pspec) {
        this.pspec_ = pspec;
    }

    public EstimationPolicyType getEstimationPolicy() {
        return this.estimation_;
    }

    public ISaSpecification getDomainSpecification() {
        return this.dspec_;
    }

    public TsData getTsData() {
        return this.ts_.getTsData();
    }

    public void compress() {
        this.rslts_ = null;
    }

    private void update() {
        if (this.rslts_ != null && this.rslts_.get("decomposition") != null) {
            this.status_ = Status.Valid;
            if (this.pspec_ == null) {
                SaManager.instance.updatePointSpecification(this);
            }
            this.qsummary_ = SaManager.createDiagnostics(this.rslts_);
            if (this.quality_ != ProcQuality.Accepted) {
                this.quality_ = ProcDiagnostic.summary((InformationSet)this.qsummary_);
            }
            this.warnings_ = (String[])this.qsummary_.warnings().stream().toArray(String[]::new);
            this.rslts_.put(DIAGNOSTICS_INTERNAL, (IProcResults)new ProxyResults(this.qsummary_, null), DIAGNOSTICS);
        } else {
            this.status_ = Status.Invalid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompositeResults process() {
        AtomicInteger atomicInteger = this.id_;
        synchronized (atomicInteger) {
            if (this.rslts_ != null || this.status_.isError()) {
                return this.rslts_;
            }
            if (this.status_ == Status.Pending) {
                return null;
            }
            if (this.quality_ == ProcQuality.Undefined) {
                this.dirty_ = true;
            }
            if (this.espec_ == null && this.dspec_ == null) {
                this.status_ = Status.NoSpec;
                return null;
            }
            this.status_ = Status.Pending;
        }
        if (this.ts_.hasData() == TsStatus.Undefined) {
            this.ts_.load(TsInformationType.Data);
        }
        if (this.ts_.getTsData() == null) {
            this.status_ = Status.NoData;
            return null;
        }
        CompositeResults rslts = SaManager.instance.process(this.getEstimationSpecification(), this.ts_.getTsData());
        AtomicInteger atomicInteger2 = this.id_;
        synchronized (atomicInteger2) {
            this.rslts_ = rslts;
            this.update();
            if (!this.cacheResults_) {
                this.rslts_ = null;
            }
            return rslts;
        }
    }

    public boolean isProcessed() {
        return this.status_.isProcessed();
    }

    public boolean isDirty() {
        return this.dirty_;
    }

    public boolean isLocked() {
        return this.locked_;
    }

    public void setLocked(boolean value) {
        if (value != this.locked_) {
            this.locked_ = value;
            this.dirty_ = true;
        }
    }

    public void resetDirty() {
        this.dirty_ = false;
    }

    public int getKey() {
        return this.id_.get();
    }

    public boolean fillDocument(SaDocument<?> doc) {
        if (!MetaData.isNullOrEmpty((MetaData)this.metaData_)) {
            doc.getMetaData().copy(this.metaData_);
        } else {
            doc.getMetaData().clear();
        }
        return doc.unsafeFill(this.getTs(), this.getEstimationSpecification(), this.process());
    }

    public SaDocument<ISaSpecification> toDocument() {
        ISaSpecification xspec = this.getEstimationSpecification();
        ISaProcessingFactory processor = (ISaProcessingFactory)SaManager.instance.find((IProcSpecification)xspec);
        SaDocument<ISaSpecification> doc = processor.createDocument();
        if (doc.unsafeFill(this.getTs(), xspec, this.process())) {
            if (!MetaData.isNullOrEmpty((MetaData)this.metaData_)) {
                doc.getMetaData().copy(this.metaData_);
            } else {
                doc.getMetaData().clear();
            }
            return doc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsafeFill(CompositeResults rslts) {
        AtomicInteger atomicInteger = this.id_;
        synchronized (atomicInteger) {
            this.rslts_ = rslts;
            this.update();
            if (!this.cacheResults_) {
                this.rslts_ = null;
            }
        }
    }

    boolean read(InformationSet info, NameManager<ISaSpecification> defaults, HashMap<String, String> equivalence) {
        InformationSet md;
        String e;
        String q;
        Integer p;
        InformationSet espec;
        InformationSet pspec;
        TsInformation tsinfo = (TsInformation)info.get(TS, TsInformation.class);
        if (tsinfo == null) {
            return false;
        }
        this.ts_ = TsFactory.instance.createTs(tsinfo.name, tsinfo.moniker, tsinfo.metaData, tsinfo.data);
        String dname = (String)info.get(DOMAIN_SPEC, String.class);
        if (dname == null) {
            return false;
        }
        this.dspec_ = (ISaSpecification)defaults.get(dname);
        if (this.dspec_ == null) {
            String ename = equivalence.get(dname);
            if (ename != null) {
                this.dspec_ = (ISaSpecification)defaults.get(ename);
            }
            if (this.dspec_ == null) {
                return false;
            }
        }
        if ((pspec = info.getSubSet(POINT_SPEC)) != null) {
            this.pspec_ = SaManager.instance.createSpecification(pspec);
        }
        if ((espec = info.getSubSet(ESTIMATION_SPEC)) != null) {
            this.espec_ = SaManager.instance.createSpecification(espec);
        }
        if ((p = (Integer)info.get(PRIORITY, Integer.class)) != null) {
            this.priority_ = p;
        }
        if ((q = (String)info.get(QUALITY, String.class)) != null) {
            this.quality_ = ProcQuality.valueOf((String)q);
        }
        if ((e = (String)info.get(POLICY, String.class)) != null) {
            this.estimation_ = EstimationPolicyType.valueOf(e);
        }
        if ((md = info.getSubSet(METADATA)) != null) {
            this.metaData_ = new MetaData();
            InformationSetHelper.fillMetaData((InformationSet)md, (MetaData)this.metaData_);
        }
        this.setName((String)info.get(NAME, String.class));
        return true;
    }

    boolean write(InformationSet info, NameManager<ISaSpecification> defaults, boolean verbose) {
        if (!this.name.isEmpty()) {
            info.set(NAME, (Object)this.name);
        }
        TsInformation tsinfo = this.ts_.getMoniker().isAnonymous() ? this.ts_.toInfo(TsInformationType.All) : (this.status_ == Status.Unprocessed ? this.ts_.toInfo(TsInformationType.Definition) : this.ts_.freeze().toInfo(TsInformationType.All));
        info.set(TS, (Object)tsinfo);
        String dname = defaults.get((Object)this.dspec_);
        if (dname == null) {
            dname = defaults.nextName();
            defaults.set(dname, (Object)this.dspec_);
        }
        info.set(DOMAIN_SPEC, (Object)dname);
        if (this.pspec_ != null) {
            info.set(POINT_SPEC, (Object)this.pspec_.write(verbose));
        }
        if (this.espec_ != null) {
            info.set(ESTIMATION_SPEC, (Object)this.espec_.write(verbose));
        }
        if (this.priority_ >= 0 || verbose) {
            info.set(PRIORITY, (Object)this.priority_);
        }
        if (this.quality_ != ProcQuality.Undefined || verbose) {
            info.set(QUALITY, (Object)this.quality_.name());
        }
        if (this.estimation_ != EstimationPolicyType.None) {
            info.set(POLICY, (Object)this.estimation_.name());
        }
        if (!MetaData.isNullOrEmpty((MetaData)this.metaData_)) {
            info.set(METADATA, (Object)InformationSetHelper.fromMetaData((MetaData)this.metaData_));
        }
        return true;
    }

    public static enum Status {
        Unprocessed,
        NoSpec,
        NoData,
        Pending,
        Valid,
        Invalid;


        public boolean isError() {
            return this.isProcessed() && this != Valid;
        }

        public boolean isProcessed() {
            return this != Unprocessed && this != Pending;
        }
    }
}

