/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa;

import ec.satoolkit.ISaSpecification;
import ec.tss.Ts;
import ec.tss.documents.TsDocument;
import ec.tss.sa.EstimationPolicyType;
import ec.tss.sa.ISaDiagnosticsFactory;
import ec.tss.sa.ISaOutputFactory;
import ec.tss.sa.ISaProcessingFactory;
import ec.tss.sa.SaItem;
import ec.tss.sa.documents.SaDocument;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.AlgorithmManager;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IDiagnostics;
import ec.tstoolkit.algorithm.IDiagnosticsFactory;
import ec.tstoolkit.algorithm.IOutputFactory;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.ProcDiagnostic;
import ec.tstoolkit.design.Singleton;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.utilities.Jdk6;
import java.util.Collection;
import java.util.List;

@Singleton
public final class SaManager
extends AlgorithmManager<ISaSpecification, TsData, CompositeResults, SaDocument<ISaSpecification>, ISaProcessingFactory<?>, ISaOutputFactory, ISaDiagnosticsFactory> {
    public static final SaManager instance = new SaManager();

    private SaManager() {
    }

    public <S extends ISaSpecification> void add(ISaProcessingFactory<S> fac) {
        super.addProcessor(fac);
    }

    public void add(ISaDiagnosticsFactory diag) {
        super.addDiagnostics((IDiagnosticsFactory)diag);
        this.sortDiagnostics(new ISaDiagnosticsFactory.DiagnosticOrdering());
    }

    public void add(ISaOutputFactory fac) {
        super.addOutput((IOutputFactory)fac);
    }

    public CompositeResults process(ISaSpecification spec, TsData s) {
        return (CompositeResults)super.process((IProcSpecification)spec, (Object)s);
    }

    public ISaProcessingFactory getProcessor(AlgorithmDescriptor desc) {
        return (ISaProcessingFactory)super.getProcessor(desc);
    }

    public ISaSpecification createSpecification(SaItem doc, TsDomain frozenPeriod, EstimationPolicyType policy, boolean nospan) {
        ISaProcessingFactory proc = this.getProcessor(doc.getEstimationMethod());
        if (proc == null) {
            return null;
        }
        return proc.createSpecification(doc, frozenPeriod, policy, nospan);
    }

    public ISaSpecification createSpecification(InformationSet info) {
        AlgorithmDescriptor desc = (AlgorithmDescriptor)info.get("algorithm", AlgorithmDescriptor.class);
        ISaProcessingFactory proc = this.getProcessor(desc);
        if (proc == null) {
            return null;
        }
        return proc.createSpecification(info);
    }

    public <S extends ISaSpecification> SaDocument<S> refreshDocument(SaDocument<S> doc, TsDomain frozenPeriod, EstimationPolicyType policy, boolean nospan) {
        SaItem tmp = new SaItem((ISaSpecification)doc.getSpecification(), (Ts)doc.getInput());
        tmp.unsafeFill((CompositeResults)doc.getResults());
        if (!this.updatePointSpecification(tmp)) {
            return null;
        }
        ISaSpecification nspec = this.createSpecification(tmp, frozenPeriod, policy, nospan);
        if (nspec == null || !doc.getProcessor().canHandle((IProcSpecification)nspec)) {
            return null;
        }
        TsDocument ndoc = doc.clone();
        ndoc.setSpecification(nspec);
        ndoc.setInput((Ts)doc.getInput());
        return ndoc;
    }

    public boolean updatePointSpecification(SaItem item) {
        ISaProcessingFactory proc = this.getProcessor(item.getEstimationMethod());
        if (proc == null) {
            return false;
        }
        return proc.updatePointSpecification(item);
    }

    private static Information<InformationSet> create(ISaDiagnosticsFactory dfac, CompositeResults sa) {
        if (sa == null) {
            return null;
        }
        IDiagnostics diags = dfac.create((IProcResults)sa);
        if (diags == null) {
            return null;
        }
        InformationSet set = new InformationSet();
        for (String test : diags.getTests()) {
            double val = diags.getValue(test);
            ProcDiagnostic item = new ProcDiagnostic(val, diags.getDiagnostic(test));
            set.set(test.toLowerCase(), (Object)item);
        }
        List warnings = diags.getWarnings();
        if (warnings != null && !warnings.isEmpty()) {
            set.set("warnings", (Object)((String[])Jdk6.Collections.toArray((Collection)warnings, String.class)));
        }
        return new Information(diags.getName().toLowerCase(), (Object)set);
    }

    public static InformationSet createDiagnostics(CompositeResults sa) {
        InformationSet summary = new InformationSet();
        TsData y = (TsData)sa.getData("y", TsData.class);
        boolean isHalfYearly = y != null && y.getFrequency().intValue() == 2;
        for (IDiagnosticsFactory diag : instance.getDiagnostics()) {
            if (!diag.isEnabled() || diag.getName().equals("M-Statistics") && isHalfYearly || diag.getName().equals("Regarima residuals") && isHalfYearly) continue;
            summary.add(SaManager.create((ISaDiagnosticsFactory)diag, sa));
        }
        return summary;
    }

    public String getFamily() {
        return "Seasonal adjustment";
    }
}

