/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa;

import com.google.common.collect.ForwardingList;
import ec.satoolkit.ISaSpecification;
import ec.tss.Ts;
import ec.tss.TsInformationType;
import ec.tss.TsStatus;
import ec.tss.sa.EstimationPolicyType;
import ec.tss.sa.RegArimaReport;
import ec.tss.sa.SaItem;
import ec.tss.sa.SaManager;
import ec.tstoolkit.IDocumented;
import ec.tstoolkit.MetaData;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.InformationSetHelper;
import ec.tstoolkit.information.InformationSetSerializable;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.utilities.NameManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class SaProcessing
extends ForwardingList<SaItem>
implements IDocumented,
InformationSetSerializable {
    public static final String METADATA = "metadata";
    public static final String DOMAIN_SPECS = "domainspecs";
    public static final String TIMESTAMP = "TimeStamp";
    public static final String OWNER = "Owner";
    private static final AtomicInteger g_id = new AtomicInteger(0);
    private final int m_id;
    private final AtomicInteger m_key = new AtomicInteger(0);
    private final List<SaItem> items_;
    private final MetaData metadata_;
    private boolean dirty_ = false;

    public static void updateSpecification(SaProcessing curprocessing) {
        for (SaItem item : curprocessing.items_) {
            SaManager.instance.updatePointSpecification(item);
        }
        curprocessing.dirty_ = true;
    }

    public SaProcessing() {
        this.m_id = g_id.incrementAndGet();
        this.items_ = new ArrayList<SaItem>();
        this.metadata_ = new MetaData();
    }

    protected List<SaItem> delegate() {
        return this.items_;
    }

    public boolean add(SaItem item) {
        item.setKey(this.nextKey());
        this.dirty_ = this.items_.add(item);
        return this.dirty_;
    }

    public boolean addAll(Collection<? extends SaItem> c) {
        for (SaItem saItem : c) {
            saItem.setKey(this.nextKey());
        }
        this.dirty_ = this.items_.addAll(c);
        return this.dirty_;
    }

    public void clear() {
        if (!this.items_.isEmpty()) {
            this.dirty_ = true;
        }
        this.items_.clear();
    }

    public SaItem remove(int idx) {
        SaItem result = this.items_.remove(idx);
        this.dirty_ = result != null;
        return result;
    }

    public boolean remove(Object item) {
        this.dirty_ = this.items_.remove(item);
        return this.dirty_;
    }

    public boolean removeAll(Collection<?> collection) {
        this.dirty_ = this.items_.removeAll(collection);
        return this.dirty_;
    }

    public SaItem set(int idx, SaItem value) {
        SaItem old = this.items_.get(idx);
        if (old == value) {
            return old;
        }
        if (!old.isLocked()) {
            this.dirty_ = true;
            value.setKey(old.getKey());
            return this.items_.set(idx, value);
        }
        return null;
    }

    public SaItem[] toArray() {
        return (SaItem[])this.items_.stream().toArray(SaItem[]::new);
    }

    int nextKey() {
        return this.m_key.getAndIncrement();
    }

    public String getDocumentId() {
        StringBuilder builder = new StringBuilder();
        builder.append("SaProcessing-").append(this.m_id);
        return builder.toString();
    }

    public List<SaItem> refresh(List<SaItem> items, EstimationPolicyType policy, boolean nospan) {
        if (policy == EstimationPolicyType.LastOutliers) {
            TsPeriodSelector sel = new TsPeriodSelector();
            sel.excluding(0, -1);
            return this.refresh(items, sel, nospan);
        }
        ArrayList<SaItem> nitems = new ArrayList<SaItem>();
        for (SaItem item : items) {
            if (item.isLocked()) continue;
            int pos = this.indexOf(item);
            if (pos < 0) {
                nitems.add(null);
                continue;
            }
            TsDomain newDomain = null;
            Ts s = item.getTs().unfreeze();
            if (policy == EstimationPolicyType.Current) {
                if (s.hasData() == TsStatus.Undefined) {
                    s.load(TsInformationType.Data);
                }
                if (s.hasData() == TsStatus.Valid) {
                    newDomain = s.getTsData().getDomain();
                }
            }
            ISaSpecification nspec = SaManager.instance.createSpecification(item, newDomain, policy, nospan);
            SaItem citem = item.newSpecification(s, nspec, policy);
            citem.setKey(item.getKey());
            nitems.add(citem);
            this.items_.set(pos, citem);
            this.dirty_ = true;
        }
        return nitems;
    }

    public List<SaItem> refresh(List<SaItem> items, TsPeriodSelector outliersCutoff, boolean nospan) {
        ArrayList<SaItem> nitems = new ArrayList<SaItem>();
        for (SaItem item : items) {
            if (item.isLocked()) continue;
            int pos = this.indexOf(item);
            if (pos < 0) {
                nitems.add(null);
                continue;
            }
            TsDomain prevDomain = item.getTsData().getDomain();
            prevDomain = outliersCutoff != null ? prevDomain.select(outliersCutoff) : prevDomain.drop(0, prevDomain.getFrequency().intValue());
            Ts s = item.getTs().unfreeze();
            ISaSpecification nspec = SaManager.instance.createSpecification(item, prevDomain, EstimationPolicyType.LastOutliers, nospan);
            SaItem citem = item.newSpecification(s, nspec, EstimationPolicyType.LastOutliers);
            nitems.add(citem);
            citem.setKey(item.getKey());
            this.items_.set(pos, citem);
            this.dirty_ = true;
        }
        return nitems;
    }

    public void refresh(EstimationPolicyType policy, boolean nospan) {
        if (policy == EstimationPolicyType.LastOutliers) {
            TsPeriodSelector sel = new TsPeriodSelector();
            sel.excluding(0, -1);
            this.refresh(sel, nospan);
            return;
        }
        int n = this.items_.size();
        for (int i = 0; i < n; ++i) {
            SaItem item = this.items_.get(i);
            if (item.isLocked()) continue;
            TsDomain newDomain = null;
            Ts s = item.getTs().unfreeze();
            if (policy == EstimationPolicyType.Current) {
                if (s.hasData() == TsStatus.Undefined) {
                    s.load(TsInformationType.Data);
                }
                if (s.hasData() == TsStatus.Valid) {
                    newDomain = s.getTsData().getDomain();
                }
            }
            ISaSpecification nspec = SaManager.instance.createSpecification(item, newDomain, policy, nospan);
            SaItem citem = item.newSpecification(s, nspec, policy);
            citem.setKey(item.getKey());
            this.items_.set(i, citem);
            this.dirty_ = true;
        }
    }

    public void refresh(TsPeriodSelector outliersCutoff, boolean nospan) {
        int n = this.items_.size();
        for (int i = 0; i < n; ++i) {
            SaItem item = this.items_.get(i);
            if (item.isLocked() || item.getTsData() == null) continue;
            TsDomain prevDomain = item.getTsData().getDomain();
            prevDomain = outliersCutoff != null ? prevDomain.select(outliersCutoff) : prevDomain.drop(0, prevDomain.getFrequency().intValue());
            Ts s = item.getTs().unfreeze();
            ISaSpecification nspec = SaManager.instance.createSpecification(item, prevDomain, EstimationPolicyType.LastOutliers, nospan);
            SaItem citem = item.newSpecification(s, nspec, EstimationPolicyType.LastOutliers);
            citem.setKey(item.getKey());
            this.items_.set(i, citem);
            this.dirty_ = true;
        }
    }

    @Deprecated
    public int search(SaItem item) {
        return this.indexOf(item);
    }

    @Deprecated
    public void addRange(Collection<SaItem> items) {
        this.addAll(items);
    }

    @Deprecated
    public int getCount() {
        return this.size();
    }

    @Deprecated
    public SaItem[] currentItems() {
        return this.toArray();
    }

    @Deprecated
    public List<SaItem> items() {
        return this;
    }

    public void addRange(ISaSpecification defspec, Iterable<Ts> ts) {
        for (Ts s : ts) {
            SaItem item = new SaItem(defspec, s);
            item.setKey(this.nextKey());
            this.items_.add(item);
        }
        this.dirty_ = true;
    }

    public void removeRange(int start, int count) {
        int imax;
        for (int i = imax = Math.min(start + count, this.items_.size()) - 1; i >= start; --i) {
            this.items_.remove(i);
        }
        this.dirty_ = true;
    }

    public boolean replace(SaItem olditem, SaItem newitem) {
        if (olditem.isLocked()) {
            return false;
        }
        for (int i = 0; i < this.items_.size(); ++i) {
            if (this.items_.get(i) != olditem) continue;
            newitem.setKey(olditem.getKey());
            newitem.setPriority(olditem.getPriority());
            this.items_.set(i, newitem);
            this.dirty_ = true;
            return true;
        }
        return false;
    }

    public int getProcessedCount() {
        int n = 0;
        for (SaItem item : this.items_) {
            if (item.getStatus() == SaItem.Status.Unprocessed) continue;
            ++n;
        }
        return n;
    }

    public boolean isInitialized() {
        for (SaItem item : this.items_) {
            if (item.getEstimationSpecification() != null && item.getTs() != null) continue;
            return false;
        }
        return true;
    }

    public boolean isProcessed() {
        for (SaItem item : this.items_) {
            if (item.isProcessed()) continue;
            return false;
        }
        return true;
    }

    public boolean isNew() {
        String ts = this.metadata_.get((Object)TIMESTAMP);
        return ts == null;
    }

    public boolean isDirty() {
        if (this.dirty_) {
            return true;
        }
        for (SaItem item : this.items_) {
            if (!item.isDirty()) continue;
            return true;
        }
        return false;
    }

    public void resetDirty() {
        this.dirty_ = false;
        for (SaItem item : this.items_) {
            item.resetDirty();
        }
    }

    public MetaData getMetaData() {
        return this.metadata_;
    }

    public SaProcessing makeCopy() {
        SaProcessing p = new SaProcessing();
        for (SaItem item : this.items_) {
            SaItem cpy = item.makeCopy();
            cpy.setKey(p.nextKey());
            p.items_.add(cpy);
        }
        p.dirty_ = !p.items_.isEmpty();
        return p;
    }

    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        InformationSet mset = InformationSetHelper.fromMetaData((MetaData)this.metadata_);
        if (mset != null) {
            info.set(METADATA, (Object)mset);
        }
        NameManager dic = new NameManager(ISaSpecification.class, "spec", null);
        int idx = 1;
        for (SaItem item : this.items_) {
            item.write(info.subSet("sa" + idx++), (NameManager<ISaSpecification>)dic, verbose);
        }
        InformationSet defspec = info.subSet(DOMAIN_SPECS);
        for (String key : dic.getNames()) {
            defspec.set(key, (Object)((ISaSpecification)dic.get(key)).write(verbose));
        }
        return info;
    }

    public boolean read(InformationSet info) {
        InformationSet defspec;
        InformationSet mset = info.getSubSet(METADATA);
        if (mset != null) {
            InformationSetHelper.fillMetaData((InformationSet)mset, (MetaData)this.metadata_);
        }
        if ((defspec = info.getSubSet(DOMAIN_SPECS)) == null) {
            return false;
        }
        NameManager dic = new NameManager(ISaSpecification.class, "spec", null);
        List dspecs = defspec.select(InformationSet.class);
        HashMap<String, String> equivalence = new HashMap<String, String>();
        for (Information dspec : dspecs) {
            ISaSpecification cur = SaManager.instance.createSpecification((InformationSet)dspec.value);
            if (cur == null) continue;
            String cname = dic.get((Object)cur);
            if (cname != null) {
                equivalence.put(dspec.name, cname);
                continue;
            }
            dic.set(dspec.name, (Object)cur);
        }
        List sas = info.select("sa*", InformationSet.class);
        for (Information sa : sas) {
            SaItem cur = new SaItem();
            if (sa.value != null && cur.read((InformationSet)sa.value, (NameManager<ISaSpecification>)dic, equivalence)) {
                cur.setKey(this.nextKey());
                this.items_.add(cur);
                continue;
            }
            String string = sa.name;
        }
        return true;
    }

    public Map<Integer, List<AlgorithmDescriptor>> methods() {
        HashMap<Integer, List<AlgorithmDescriptor>> rslt = new HashMap<Integer, List<AlgorithmDescriptor>>();
        for (SaItem item : this.items_) {
            AlgorithmDescriptor alg;
            if (item.getTs().hasData() != TsStatus.Valid) continue;
            int freq = item.getTsData().getFrequency().intValue();
            ArrayList<AlgorithmDescriptor> desc = (ArrayList<AlgorithmDescriptor>)rslt.get(freq);
            if (desc == null) {
                desc = new ArrayList<AlgorithmDescriptor>();
                rslt.put(freq, desc);
            }
            if (desc.contains(alg = item.getEstimationMethod())) continue;
            desc.add(alg);
        }
        return rslt;
    }

    public Map<Integer, Map<AlgorithmDescriptor, RegArimaReport>> createRegArimaReports() {
        HashMap<Integer, Map<AlgorithmDescriptor, RegArimaReport>> reports = new HashMap<Integer, Map<AlgorithmDescriptor, RegArimaReport>>();
        for (SaItem item : this.items_) {
            RegArimaReport report;
            CompositeResults rslt;
            if (!item.isProcessed() || (rslt = item.process()) == null) continue;
            int freq = item.getTs().getTsData().getFrequency().intValue();
            LinkedHashMap<AlgorithmDescriptor, RegArimaReport> cur = (LinkedHashMap<AlgorithmDescriptor, RegArimaReport>)reports.get(freq);
            if (cur == null) {
                cur = new LinkedHashMap<AlgorithmDescriptor, RegArimaReport>();
                reports.put(freq, cur);
            }
            if ((report = (RegArimaReport)cur.get(item.getEstimationMethod())) == null) {
                report = new RegArimaReport(freq);
                cur.put(item.getEstimationMethod(), report);
            }
            report.add(rslt);
        }
        return reports;
    }
}

