/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.composite;

import ec.benchmarking.simplets.TsCholette;
import ec.benchmarking.simplets.TsMultiBenchmarking;
import ec.satoolkit.DecompositionMode;
import ec.satoolkit.ISaSpecification;
import ec.satoolkit.benchmarking.MultiSaBenchmarkingSpec;
import ec.tss.Ts;
import ec.tss.TsCollection;
import ec.tss.TsInformationType;
import ec.tss.TsStatus;
import ec.tss.sa.SaManager;
import ec.tss.sa.composite.MultiSaSpecification;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.IProcessingNode;
import ec.tstoolkit.algorithm.ParallelProcessingNode;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.algorithm.SequentialProcessing;
import ec.tstoolkit.algorithm.SingleTsData;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.ProxyResults;
import ec.tstoolkit.timeseries.TsAggregationType;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiSaProcessingFactory
implements IProcessingFactory<MultiSaSpecification, TsCollection, CompositeResults> {
    public static final String COMPONENTS = "components";
    public static final String DIFFERENCES = "differences";
    public static final String BENCHMARKING = "benchmarking";
    public static final AlgorithmDescriptor DESCRIPTOR = new AlgorithmDescriptor("Seasonal adjustment", "Composite", "1.0");
    private static final String TOTAL = "__total__";
    private static final String ANNUALSERIES = "__y__";
    public static final MultiSaProcessingFactory instance = new MultiSaProcessingFactory();

    protected MultiSaProcessingFactory() {
    }

    public void dispose() {
    }

    public AlgorithmDescriptor getInformation() {
        return DESCRIPTOR;
    }

    public boolean canHandle(IProcSpecification spec) {
        return spec instanceof MultiSaSpecification;
    }

    public IProcessing<TsCollection, CompositeResults> generateProcessing(MultiSaSpecification specification, ProcessingContext context) {
        SequentialProcessing all = new SequentialProcessing();
        all.add(MultiSaProcessingFactory.createComponentsNode(specification));
        all.add(this.createDirectNode(specification));
        all.add(this.createIndirectNode());
        all.add(this.createDifferenceNode());
        if (specification.getBenchmarkingSpecification().isEnabled()) {
            all.add(this.createBenchmarkingStep(specification.getBenchmarkingSpecification()));
        }
        return all;
    }

    public IProcessing<TsCollection, CompositeResults> generateProcessing(MultiSaSpecification specification) {
        return this.generateProcessing(specification);
    }

    private static IProcessingNode<TsCollection> createComponentsNode(final MultiSaSpecification specs) {
        return new IProcessingNode<TsCollection>(){

            public String getName() {
                return MultiSaProcessingFactory.COMPONENTS;
            }

            public String getPrefix() {
                return null;
            }

            public IProcessing.Status process(TsCollection input, Map<String, IProcResults> results) {
                if (input == null || input.getCount() < 2) {
                    return IProcessing.Status.Invalid;
                }
                ParallelProcessingNode cmps = new ParallelProcessingNode(MultiSaProcessingFactory.COMPONENTS, null);
                int n = input.getCount();
                for (int i = 0; i < n; ++i) {
                    cmps.add(MultiSaProcessingFactory.createNode(specs.getSpecification(i), i));
                }
                return cmps.process((Object)input, results);
            }
        };
    }

    private static IProcessingNode<TsCollection> createNode(final ISaSpecification spec, final int pos) {
        return new IProcessingNode<TsCollection>(){

            public String getName() {
                return "component" + pos;
            }

            public String getPrefix() {
                return this.getName();
            }

            public IProcessing.Status process(TsCollection input, Map<String, IProcResults> results) {
                Ts ts = input.get(pos);
                CompositeResults process = SaManager.instance.process(spec, ts.getTsData());
                results.put(this.getName(), (IProcResults)process);
                return process == null ? IProcessing.Status.Invalid : IProcessing.Status.Valid;
            }
        };
    }

    private static TsData sum(TsCollection input) {
        TsData sum = null;
        for (Ts s : input) {
            if (s.hasData() == TsStatus.Undefined) {
                s.load(TsInformationType.Data);
            }
            sum = TsData.add(sum, (TsData)s.getTsData());
        }
        return sum;
    }

    private IProcessingNode<TsCollection> createDirectNode(final MultiSaSpecification specification) {
        return new IProcessingNode<TsCollection>(){

            public String getName() {
                return "direct";
            }

            public String getPrefix() {
                return "direct";
            }

            public IProcessing.Status process(TsCollection input, Map<String, IProcResults> results) {
                CompositeResults rslts = SaManager.instance.process(specification.getTotalSpecification(), MultiSaProcessingFactory.sum(input));
                results.put(this.getName(), (IProcResults)rslts);
                if (rslts != null) {
                    return IProcessing.Status.Valid;
                }
                return IProcessing.Status.Invalid;
            }
        };
    }

    private IProcessingNode<TsCollection> createIndirectNode() {
        return new IProcessingNode<TsCollection>(){

            public String getName() {
                return "indirect";
            }

            public String getPrefix() {
                return "indirect";
            }

            public IProcessing.Status process(TsCollection input, Map<String, IProcResults> results) {
                TsData sum = null;
                IProcResults all = results.get(MultiSaProcessingFactory.COMPONENTS);
                int n = input.getCount();
                for (int i = 0; i < n; ++i) {
                    TsData s = (TsData)all.getData(InformationSet.item((String)("component" + i), (String)"sa"), TsData.class);
                    sum = TsData.add(sum, (TsData)s);
                }
                SingleTsData sa = new SingleTsData("sa", sum);
                results.put("indirect", (IProcResults)sa);
                return IProcessing.Status.Valid;
            }
        };
    }

    private IProcessingNode<TsCollection> createDifferenceNode() {
        return new IProcessingNode<TsCollection>(){

            public String getName() {
                return MultiSaProcessingFactory.DIFFERENCES;
            }

            public String getPrefix() {
                return null;
            }

            public IProcessing.Status process(TsCollection input, Map<String, IProcResults> results) {
                IProcResults ir;
                TsData d = null;
                TsData i = null;
                IProcResults dr = results.get("direct");
                boolean mul = false;
                if (dr != null) {
                    d = (TsData)dr.getData("sa", TsData.class);
                    DecompositionMode mode = (DecompositionMode)dr.getData("mode", DecompositionMode.class);
                    if (mode != null) {
                        mul = mode.isMultiplicative();
                    }
                }
                if ((ir = results.get("indirect")) != null) {
                    i = (TsData)ir.getData("sa", TsData.class);
                }
                SingleTsData del = new SingleTsData(MultiSaProcessingFactory.DIFFERENCES, mul ? TsData.divide((TsData)d, (TsData)i).minus(1.0) : TsData.subtract((TsData)d, (TsData)i));
                results.put(MultiSaProcessingFactory.DIFFERENCES, (IProcResults)del);
                return IProcessing.Status.Valid;
            }
        };
    }

    private IProcessingNode<TsCollection> createBenchmarkingStep(final MultiSaBenchmarkingSpec bspec) {
        return new IProcessingNode<TsCollection>(){

            public String getName() {
                return MultiSaProcessingFactory.BENCHMARKING;
            }

            public String getPrefix() {
                return MultiSaProcessingFactory.BENCHMARKING;
            }

            public IProcessing.Status process(TsCollection input, Map<String, IProcResults> results) {
                TsData dsa = this.getDirectSa(results);
                if (dsa == null) {
                    return IProcessing.Status.Invalid;
                }
                TsMultiBenchmarking bench = new TsMultiBenchmarking();
                bench.setRho(bspec.getRho());
                bench.setLambda(bspec.getLambda());
                int n = input.getCount();
                List<String> sa = this.getSa(bench, results, n, dsa.getDomain());
                if (sa == null) {
                    return IProcessing.Status.Invalid;
                }
                if (!bspec.isAnnualConstraint()) {
                    bench.addInput(MultiSaProcessingFactory.TOTAL, dsa);
                } else {
                    TsData y = MultiSaProcessingFactory.sum(input).changeFrequency(TsFrequency.Yearly, TsAggregationType.Sum, true);
                    bench.addInput(MultiSaProcessingFactory.TOTAL, this.benchDsa(y, dsa, bspec));
                }
                this.fillContemporaneousConstraints(bench, sa, bspec.getContemporaneousConstraintType());
                if (bspec.isAnnualConstraint()) {
                    this.fillAnnualConstraints(bench, input, sa);
                }
                if (!bench.process()) {
                    return IProcessing.Status.Invalid;
                }
                boolean bsa = bspec.isAnnualConstraint() || bspec.getContemporaneousConstraintType() == MultiSaBenchmarkingSpec.ConstraintType.Free;
                this.fillResults(bench, sa, results, bsa);
                return IProcessing.Status.Valid;
            }

            List<String> getSa(TsMultiBenchmarking bench, Map<String, IProcResults> results, int n, TsDomain domain) {
                IProcResults cmps = results.get(MultiSaProcessingFactory.COMPONENTS);
                if (cmps == null) {
                    return null;
                }
                ArrayList<String> data = new ArrayList<String>(n);
                for (int i = 0; i < n; ++i) {
                    String id = "component" + i;
                    TsData s = (TsData)cmps.getData(InformationSet.item((String)id, (String)"sa"), TsData.class);
                    if (s == null) continue;
                    bench.addInput(id, s.fittoDomain(domain));
                    data.add(id);
                }
                return data;
            }

            void fillAnnualConstraints(TsMultiBenchmarking bench, TsCollection input, List<String> sa) {
                for (int i = 0; i < input.getCount(); ++i) {
                    String id = MultiSaProcessingFactory.ANNUALSERIES + i;
                    bench.addInput(id, input.get(i).getTsData().changeFrequency(TsFrequency.Yearly, TsAggregationType.Sum, true));
                    bench.addTemporalConstraint(id, sa.get(i));
                }
            }

            void fillContemporaneousConstraints(TsMultiBenchmarking bench, List<String> sa, MultiSaBenchmarkingSpec.ConstraintType type) {
                TsMultiBenchmarking.ContemporaneousConstraintDescriptor desc;
                switch (type) {
                    case Fixed: {
                        desc = new TsMultiBenchmarking.ContemporaneousConstraintDescriptor(MultiSaProcessingFactory.TOTAL);
                        for (String s : sa) {
                            desc.add(s, 1.0);
                        }
                        break;
                    }
                    case Free: {
                        desc = new TsMultiBenchmarking.ContemporaneousConstraintDescriptor(0.0);
                        desc.add(MultiSaProcessingFactory.TOTAL, -1.0);
                        for (String s : sa) {
                            desc.add(s, 1.0);
                        }
                        break;
                    }
                    default: {
                        return;
                    }
                }
                bench.addContemporaneousConstraint(desc);
            }

            TsData getDirectSa(Map<String, IProcResults> results) {
                IProcResults dr = results.get("direct");
                if (dr != null) {
                    return (TsData)dr.getData("sa", TsData.class);
                }
                return null;
            }

            private void fillResults(TsMultiBenchmarking bench, List<String> sa, Map<String, IProcResults> results, boolean b) {
                InformationSet info = new InformationSet();
                TsData bsa = null;
                for (String s : sa) {
                    TsData data = bench.getResult(s);
                    if (b) {
                        bsa = TsData.add(bsa, (TsData)data);
                    }
                    info.set(s, (Object)data);
                }
                if (b) {
                    info.set("sa", bsa);
                }
                results.put(MultiSaProcessingFactory.BENCHMARKING, (IProcResults)new ProxyResults(info, null));
            }

            private TsData benchDsa(TsData sum, TsData dsa, MultiSaBenchmarkingSpec bspec2) {
                TsCholette cholette = new TsCholette();
                cholette.setRho(bspec2.getRho());
                cholette.setLambda(bspec2.getLambda());
                return cholette.process(dsa, sum);
            }
        };
    }

    public Map<String, Class> getSpecificationDictionary(Class<MultiSaSpecification> specClass) {
        HashMap<String, Class> dic = new HashMap<String, Class>();
        MultiSaSpecification.fillDictionary(null, dic);
        return dic;
    }

    public Map<String, Class> getOutputDictionary(boolean compact) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

