/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.composite;

import ec.satoolkit.ISaSpecification;
import ec.satoolkit.benchmarking.MultiSaBenchmarkingSpec;
import ec.tss.sa.composite.MultiSaProcessingFactory;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.InformationSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MultiSaSpecification
implements IProcSpecification,
Cloneable {
    public static final String DIRECT = "direct";
    public static final String INDIRECT = "indirect";
    public static final String DEFAULT = "__default";
    public static final String COMPONENT = "component";
    public static final String BENCHMARKING = "benchmarking";
    private ISaSpecification totalSpec_;
    private ISaSpecification defSpec_;
    private List<ISaSpecification> specs_ = new ArrayList<ISaSpecification>();
    private MultiSaBenchmarkingSpec benchSpec_ = new MultiSaBenchmarkingSpec();

    public static void fillDictionary(String prefix, HashMap<String, Class> dic) {
    }

    public void set(int pos, ISaSpecification spec) {
        this.specs_.set(pos, spec);
    }

    public void add(ISaSpecification spec) {
        this.specs_.add(spec);
    }

    public MultiSaBenchmarkingSpec getBenchmarkingSpecification() {
        return this.benchSpec_;
    }

    public void setBenchmarkingSpecification(MultiSaBenchmarkingSpec spec) {
        if (spec == null) {
            throw new IllegalArgumentException();
        }
        this.benchSpec_ = spec;
    }

    public ISaSpecification getSpecification(int pos) {
        int nspecs = this.specs_.size();
        if (pos >= nspecs) {
            return this.defSpec_;
        }
        return this.specs_.get(pos);
    }

    public ISaSpecification getTotalSpecification() {
        return this.totalSpec_;
    }

    public void setTotalSpecification(ISaSpecification spec) {
        this.totalSpec_ = spec;
    }

    public ISaSpecification getDefaultSpecification() {
        return this.defSpec_;
    }

    public void setDefaultSpecification(ISaSpecification spec) {
        this.defSpec_ = spec;
        this.specs_.clear();
    }

    public MultiSaSpecification clone() {
        try {
            MultiSaSpecification c = (MultiSaSpecification)super.clone();
            c.benchSpec_ = this.benchSpec_.clone();
            c.specs_.addAll(this.specs_);
            return c;
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        info.add("algorithm", (Object)MultiSaProcessingFactory.DESCRIPTOR);
        info.add(DIRECT, (Object)this.totalSpec_.write(verbose));
        info.add(DEFAULT, (Object)this.defSpec_.write(verbose));
        for (int i = 0; i < this.specs_.size(); ++i) {
            String name = COMPONENT + (i + 1);
            info.add(name, (Object)this.specs_.get(i).write(verbose));
        }
        return info;
    }

    public boolean read(InformationSet info) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

