/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.diagnostics;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.GenericSaResults;
import ec.satoolkit.ISaResults;
import ec.satoolkit.diagnostics.QSTest;
import ec.tss.sa.diagnostics.AdvancedResidualSeasonalityDiagnosticsConfiguration;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IDiagnostics;
import ec.tstoolkit.algorithm.ProcQuality;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.modelling.DifferencingResults;
import ec.tstoolkit.modelling.arima.JointRegressionTest;
import ec.tstoolkit.stats.StatisticalTest;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.RegressionUtilities;
import ec.tstoolkit.timeseries.regression.SeasonalDummies;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AdvancedResidualSeasonalityDiagnostics
implements IDiagnostics {
    private static final double E_LIMIT = 0.005;
    private StatisticalTest qs_sa;
    private StatisticalTest qs_i;
    private StatisticalTest f_sa;
    private StatisticalTest f_i;
    private double sev;
    private double bad;
    private double unc;

    private static boolean isMultiplicative(CompositeResults rslts) {
        DecompositionMode mul = (DecompositionMode)rslts.getData("mode", DecompositionMode.class);
        return mul != null && mul.isMultiplicative();
    }

    private static boolean isSignificant(TsData s, TsData ref, double limit) {
        DescriptiveStatistics sdesc = new DescriptiveStatistics((IReadDataBlock)s);
        DescriptiveStatistics refdesc = new DescriptiveStatistics((IReadDataBlock)ref);
        double se = sdesc.getStdev();
        double refe = refdesc.getRmse();
        return refe == 0.0 || se / refe > limit;
    }

    private static boolean isSignificant(TsData i) {
        if (i == null) {
            return false;
        }
        DescriptiveStatistics idesc = new DescriptiveStatistics((IReadDataBlock)i);
        double se = idesc.getStdev();
        return se > 0.005;
    }

    public static IDiagnostics create(CompositeResults rslts, AdvancedResidualSeasonalityDiagnosticsConfiguration config) {
        try {
            TsData ilast;
            TsData ic;
            TsData salast;
            int ifreq;
            TsData sac;
            int ny;
            boolean isignif;
            if (rslts == null || GenericSaResults.getDecomposition((CompositeResults)rslts, ISaResults.class) == null) {
                return null;
            }
            AdvancedResidualSeasonalityDiagnostics test = new AdvancedResidualSeasonalityDiagnostics();
            TsData sa = (TsData)rslts.getData("sa_cmp", TsData.class);
            TsData i = (TsData)rslts.getData("i_cmp", TsData.class);
            if (sa == null && i == null) {
                return null;
            }
            boolean mul = AdvancedResidualSeasonalityDiagnostics.isMultiplicative(rslts);
            boolean bl = mul ? AdvancedResidualSeasonalityDiagnostics.isSignificant(i) : (isignif = sa != null && i != null ? AdvancedResidualSeasonalityDiagnostics.isSignificant(i, sa, 0.005) : true);
            if (config.isQsTest()) {
                ny = config.getQsTestLastYears();
                if (sa != null) {
                    sac = sa;
                    if (mul) {
                        sac = sac.log();
                    }
                    ifreq = sac.getFrequency().intValue();
                    salast = sac;
                    if (ny != 0) {
                        salast = sac.drop(Math.max(0, sac.getLength() - ifreq * ny - 1), 0);
                    }
                    DifferencingResults dsa = DifferencingResults.create((TsData)salast, (int)-1, (boolean)true);
                    if (mul ? AdvancedResidualSeasonalityDiagnostics.isSignificant(dsa.getDifferenced()) : AdvancedResidualSeasonalityDiagnostics.isSignificant(dsa.getDifferenced(), salast, 0.005)) {
                        test.qs_sa = QSTest.compute((double[])dsa.getDifferenced().internalStorage(), (int)ifreq, (int)2);
                    }
                }
                if (i != null && isignif) {
                    ic = i;
                    if (mul) {
                        ic = ic.log();
                    }
                    ifreq = ic.getFrequency().intValue();
                    ilast = ic;
                    if (ny != 0) {
                        ilast = ic.drop(Math.max(0, ic.getLength() - ifreq * ny), 0);
                    }
                    DifferencingResults di = DifferencingResults.create((TsData)ilast, (int)-1, (boolean)true);
                    test.qs_i = QSTest.compute((double[])di.getDifferenced().internalStorage(), (int)ifreq, (int)2);
                }
            }
            if (config.isFTest()) {
                ny = config.getFTestLastYears();
                if (sa != null) {
                    sac = sa;
                    if (mul) {
                        sac = sac.log();
                    }
                    ifreq = sac.getFrequency().intValue();
                    salast = sac;
                    if (ny != 0) {
                        salast = sac.drop(Math.max(0, sac.getLength() - ifreq * ny - 1), 0);
                    }
                    test.f_sa = AdvancedResidualSeasonalityDiagnostics.processAr(salast);
                }
                if (i != null && isignif) {
                    ic = i;
                    if (mul) {
                        ic = ic.log();
                    }
                    ifreq = ic.getFrequency().intValue();
                    ilast = ic;
                    if (ny != 0) {
                        ilast = ic.drop(Math.max(0, ic.getLength() - ifreq * ny - 1), 0);
                    }
                    test.f_i = AdvancedResidualSeasonalityDiagnostics.processAr(ilast);
                }
            }
            test.sev = config.getSevereThreshold();
            test.bad = config.getBadThreshold();
            test.unc = config.getUncertainThreshold();
            return test;
        }
        catch (Exception err) {
            return null;
        }
    }

    public String getName() {
        return "Residual seasonality tests";
    }

    public List<String> getTests() {
        ArrayList<String> tests = new ArrayList<String>();
        if (this.qs_sa != null) {
            tests.add("Qs test on SA");
        }
        if (this.f_sa != null) {
            tests.add("F-Test on SA (seasonal dummies)");
        }
        if (this.qs_i != null) {
            tests.add("Qs test on I");
        }
        if (this.f_i != null) {
            tests.add("F-Test on I (seasonal dummies)");
        }
        return tests;
    }

    public ProcQuality getDiagnostic(String test) {
        switch (test) {
            case "Qs test on SA": {
                return this.quality(this.qs_sa);
            }
            case "F-Test on SA (seasonal dummies)": {
                return this.quality(this.f_sa);
            }
            case "Qs test on I": {
                return this.quality(this.qs_i);
            }
            case "F-Test on I (seasonal dummies)": {
                return this.quality(this.f_i);
            }
        }
        return ProcQuality.Undefined;
    }

    public double getValue(String test) {
        switch (test) {
            case "Qs test on SA": {
                return this.pvalue(this.qs_sa);
            }
            case "F-Test on SA (seasonal dummies)": {
                return this.pvalue(this.f_sa);
            }
            case "Qs test on I": {
                return this.pvalue(this.qs_i);
            }
            case "F-Test on I (seasonal dummies)": {
                return this.pvalue(this.f_i);
            }
        }
        return Double.NaN;
    }

    public List<String> getWarnings() {
        return Collections.emptyList();
    }

    private ProcQuality quality(StatisticalTest test) {
        if (test == null) {
            return ProcQuality.Undefined;
        }
        double pval = test.getPValue();
        if (pval < this.sev) {
            return ProcQuality.Severe;
        }
        if (pval < this.bad) {
            return ProcQuality.Bad;
        }
        if (pval < this.unc) {
            return ProcQuality.Uncertain;
        }
        return ProcQuality.Good;
    }

    private double pvalue(StatisticalTest test) {
        return test == null ? Double.NaN : test.getPValue();
    }

    private static StatisticalTest processAr(TsData s) {
        try {
            RegModel reg = new RegModel();
            DataBlock y = new DataBlock((IReadDataBlock)s);
            reg.setY(y.drop(1, 0));
            TsDomain edomain = s.getDomain().drop(1, 0);
            SeasonalDummies dummies = new SeasonalDummies(edomain.getFrequency());
            List regs = RegressionUtilities.data((ITsVariable)dummies, (TsDomain)edomain);
            reg.addX(y.drop(0, 1));
            for (DataBlock r : regs) {
                reg.addX(r);
            }
            reg.setMeanCorrection(true);
            int nseas = dummies.getDim();
            Ols ols = new Ols();
            if (!ols.process(reg)) {
                return null;
            }
            JointRegressionTest test = new JointRegressionTest(0.01);
            test.accept(ols.getLikelihood(), 0, 2, nseas, null);
            return test.getTest();
        }
        catch (Exception err) {
            return null;
        }
    }

    private static StatisticalTest process(TsData s) {
        try {
            RegModel reg = new RegModel();
            DataBlock y = new DataBlock((IReadDataBlock)s);
            y.add(-y.average());
            reg.setY(y);
            TsDomain edomain = s.getDomain();
            SeasonalDummies dummies = new SeasonalDummies(edomain.getFrequency());
            List regs = RegressionUtilities.data((ITsVariable)dummies, (TsDomain)edomain);
            for (DataBlock r : regs) {
                reg.addX(r);
            }
            int nseas = dummies.getDim();
            Ols ols = new Ols();
            if (!ols.process(reg)) {
                return null;
            }
            JointRegressionTest test = new JointRegressionTest(0.01);
            test.accept(ols.getLikelihood(), 0, 0, nseas, null);
            return test.getTest();
        }
        catch (Exception err) {
            return null;
        }
    }
}

