/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.diagnostics;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.GenericSaResults;
import ec.satoolkit.ISaResults;
import ec.satoolkit.ISeriesDecomposition;
import ec.tss.sa.diagnostics.CoherenceDiagnosticsConfiguration;
import ec.tss.sa.diagnostics.CoherenceDiagnosticsFactory;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IDiagnostics;
import ec.tstoolkit.algorithm.ProcQuality;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataBlock;
import ec.tstoolkit.timeseries.simplets.YearIterator;
import java.util.Collections;
import java.util.List;

public final class CoherenceDiagnostics
implements IDiagnostics {
    private double maxDA_;
    private double maxDDef_;
    private double eb_ = 0.5;
    private double ub_ = 0.01;
    private double bb_ = 0.05;
    private double sb_ = 0.1;
    private double lDef_ = 1.0E-6;
    private int yshort_ = 7;
    private boolean mul_;
    private boolean short_;
    private double scale;
    private static String SHORTSERIES = "Short series";

    static CoherenceDiagnostics create(CoherenceDiagnosticsConfiguration config, CompositeResults rslts) {
        try {
            if (rslts == null || GenericSaResults.getDecomposition((CompositeResults)rslts, ISaResults.class) == null) {
                return null;
            }
            return new CoherenceDiagnostics(config, rslts);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private CoherenceDiagnostics(CoherenceDiagnosticsConfiguration config, CompositeResults rslts) {
        this.eb_ = config.getError();
        this.sb_ = config.getSevere();
        this.bb_ = config.getBad();
        this.ub_ = config.getUncertain();
        this.lDef_ = config.getTolerance();
        this.yshort_ = config.getShortSeries();
        this.test(rslts);
    }

    private void test(CompositeResults rslts) {
        ISeriesDecomposition decomposition;
        TsData yl = (TsData)rslts.getData("y_lin", TsData.class);
        if (yl != null && yl.getLength() < this.yshort_ * yl.getFrequency().intValue()) {
            this.short_ = true;
        }
        this.mul_ = (decomposition = GenericSaResults.getFinalDecomposition((CompositeResults)rslts)).getMode() != DecompositionMode.Additive;
        TsData y = (TsData)rslts.getData("yc", TsData.class);
        DescriptiveStatistics ds = new DescriptiveStatistics((IReadDataBlock)y);
        this.scale = ds.getRmse();
        TsData yc = y;
        TsData sa = (TsData)rslts.getData("sa", TsData.class);
        TsData s = (TsData)rslts.getData("s", TsData.class);
        TsData t = (TsData)rslts.getData("t", TsData.class);
        TsData i = (TsData)rslts.getData("i", TsData.class);
        if (decomposition.getMode() == DecompositionMode.PseudoAdditive) {
            TsData df0 = this.sub(y, TsData.multiply((TsData)t, (TsData)TsData.add((TsData)s, (TsData)i).minus(1.0)));
            TsData df1 = this.sub(sa, TsData.multiply((TsData)t, (TsData)i));
            this.check(df0);
            this.check(df1);
        } else {
            TsData regy = (TsData)rslts.getData("reg_y", TsData.class);
            TsData regsa = (TsData)rslts.getData("reg_sa", TsData.class);
            TsData cy = (TsData)rslts.getData("y_cmp", TsData.class);
            TsData ct = (TsData)rslts.getData("t_cmp", TsData.class);
            TsData cs = (TsData)rslts.getData("s_cmp", TsData.class);
            TsData ci = (TsData)rslts.getData("i_cmp", TsData.class);
            TsData csa = (TsData)rslts.getData("sa_cmp", TsData.class);
            TsData ly = (TsData)rslts.getData("y_lin", TsData.class);
            TsData lt = (TsData)rslts.getData("t_lin", TsData.class);
            TsData ls = (TsData)rslts.getData("s_lin", TsData.class);
            TsData li = (TsData)rslts.getData("i_lin", TsData.class);
            TsData lsa = (TsData)rslts.getData("sa_lin", TsData.class);
            TsData tde = (TsData)rslts.getData("tde", TsData.class);
            TsData ee = (TsData)rslts.getData("ee", TsData.class);
            TsData omhe = (TsData)rslts.getData("omhe", TsData.class);
            TsData cal = (TsData)rslts.getData("cal", TsData.class);
            TsData outs = (TsData)rslts.getData("out_s", TsData.class);
            TsData regs = (TsData)rslts.getData("reg_s", TsData.class);
            TsData outt = (TsData)rslts.getData("out_t", TsData.class);
            TsData regt = (TsData)rslts.getData("reg_t", TsData.class);
            TsData outi = (TsData)rslts.getData("out_i", TsData.class);
            TsData regi = (TsData)rslts.getData("reg_i", TsData.class);
            yc = this.inv_op(y, regy);
            TsData df0 = this.sub(yc, this.op(t, s, i, regsa));
            TsData df1 = this.sub(sa, this.op(t, i, regsa));
            TsData df2 = this.sub(this.inv_op(y, regy), this.op(sa, s));
            TsData df3 = this.sub(s, this.op(cs, cal, regs, outs));
            TsData df4 = this.sub(t, this.op(ct, regt, outt));
            TsData df5 = this.sub(i, this.op(ci, regi, outi));
            TsData dcal = this.sub(cal, this.op(tde, ee, omhe));
            TsData dc0 = this.sub(cy, this.op(ct, cs, ci));
            TsData dc1 = this.sub(csa, this.op(ct, ci));
            TsData dc2 = this.sub(cy, this.op(csa, cs));
            this.maxDDef_ = Double.NaN;
            this.check(df0);
            this.check(df1);
            this.check(df2);
            this.check(df3);
            this.check(df4);
            this.check(df5);
            this.check(dcal);
            this.check(dc0);
            this.check(dc1);
            this.check(dc2);
            if (lsa != null) {
                TsData dl0 = this.sub(ly, this.add(lt, ls, li));
                TsData dl1 = this.sub(lsa, this.add(lt, li));
                TsData dl2 = this.sub(ly, this.add(lsa, ls));
                this.check(dl0);
                this.check(dl1);
                this.check(dl2);
            }
        }
        YearIterator yiter = YearIterator.fullYears((TsData)yc);
        YearIterator saiter = YearIterator.fullYears((TsData)sa);
        this.maxDA_ = 0.0;
        while (yiter.hasMoreElements() && saiter.hasMoreElements()) {
            TsDataBlock ydb = yiter.nextElement();
            TsDataBlock sadb = saiter.nextElement();
            double dcur = Math.abs(ydb.data.sum() - sadb.data.sum());
            if (!(dcur > this.maxDA_)) continue;
            this.maxDA_ = dcur;
        }
        this.maxDA_ /= (double)y.getFrequency().intValue() * this.scale;
    }

    private TsData op(TsData l, TsData r) {
        if (this.mul_) {
            return TsData.multiply((TsData)l, (TsData)r);
        }
        return TsData.add((TsData)l, (TsData)r);
    }

    private TsData op(TsData a, TsData b, TsData c) {
        if (this.mul_) {
            return TsData.multiply((TsData)a, (TsData)TsData.multiply((TsData)b, (TsData)c));
        }
        return TsData.add((TsData)a, (TsData)TsData.add((TsData)b, (TsData)c));
    }

    private TsData add(TsData l, TsData r) {
        return TsData.add((TsData)l, (TsData)r);
    }

    private TsData add(TsData a, TsData b, TsData c) {
        return TsData.add((TsData)a, (TsData)TsData.add((TsData)b, (TsData)c));
    }

    private TsData op(TsData a, TsData b, TsData c, TsData d) {
        return this.op(this.op(a, b), this.op(c, d));
    }

    private TsData inv_op(TsData l, TsData r) {
        if (this.mul_) {
            return TsData.divide((TsData)l, (TsData)r);
        }
        return TsData.subtract((TsData)l, (TsData)r);
    }

    private TsData sub(TsData l, TsData r) {
        return TsData.subtract((TsData)l, (TsData)r);
    }

    public String getName() {
        return "Basic checks";
    }

    public List<String> getTests() {
        return CoherenceDiagnosticsFactory.ALL;
    }

    public ProcQuality getDiagnostic(String test) {
        if (test.equals(CoherenceDiagnosticsFactory.ALL.get(0))) {
            if (Double.isNaN(this.maxDDef_)) {
                return ProcQuality.Error;
            }
            return this.maxDDef_ < this.lDef_ ? ProcQuality.Good : ProcQuality.Error;
        }
        if (Double.isNaN(this.maxDA_) || this.maxDA_ > this.eb_) {
            return ProcQuality.Error;
        }
        if (this.maxDA_ > this.sb_) {
            return ProcQuality.Severe;
        }
        if (this.maxDA_ > this.bb_) {
            return ProcQuality.Bad;
        }
        if (this.maxDA_ > this.ub_) {
            return ProcQuality.Uncertain;
        }
        return ProcQuality.Good;
    }

    public double getValue(String test) {
        double val = test.equals(CoherenceDiagnosticsFactory.ALL.get(0)) ? this.maxDDef_ : this.maxDA_;
        return val;
    }

    public List<String> getWarnings() {
        if (this.short_) {
            return Collections.singletonList(SHORTSERIES);
        }
        return null;
    }

    public double getDefinitionTolerance() {
        return this.lDef_;
    }

    public int getShortSeries() {
        return this.yshort_;
    }

    public double getLowerBound(ProcQuality quality) {
        switch (quality) {
            case Error: {
                return this.eb_;
            }
            case Severe: {
                return this.sb_;
            }
            case Bad: {
                return this.bb_;
            }
            case Uncertain: {
                return this.ub_;
            }
        }
        return 0.0;
    }

    private void check(TsData d) {
        if (d == null || this.scale == 0.0) {
            return;
        }
        DescriptiveStatistics stats = new DescriptiveStatistics((IReadDataBlock)d);
        double dmax = Math.max(Math.abs(stats.getMax()), Math.abs(stats.getMin())) / this.scale;
        if (Double.isNaN(this.maxDDef_) || dmax > this.maxDDef_) {
            this.maxDDef_ = dmax;
        }
    }
}

