/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.diagnostics;

import ec.tstoolkit.BaseException;
import ec.tstoolkit.descriptors.EnhancedPropertyDescriptor;
import ec.tstoolkit.descriptors.IPropertyDescriptors;
import ec.tstoolkit.timeseries.TsException;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;

public class CoherenceDiagnosticsConfiguration
implements Cloneable,
IPropertyDescriptors {
    private static final double TOL = 0.001;
    private static final double ERR = 0.5;
    private static final double SEV = 0.1;
    private static final double BAD = 0.05;
    private static final double UNC = 0.01;
    private static final int SHORT = 7;
    private double m_Tolerance = 0.001;
    private double m_Error = 0.5;
    private double m_Severe = 0.1;
    private double m_Bad = 0.05;
    private double m_Uncertain = 0.01;
    private boolean m_Enabled = true;
    private int m_ShortSeries = 7;
    private static final int ENABLED_ID = 1;
    private static final int TOL_ID = 2;
    private static final int ERR_ID = 3;
    private static final int SEV_ID = 4;
    private static final int BAD_ID = 5;
    private static final int UNC_ID = 6;
    private static final int SHORT_ID = 7;
    private static final String ENABLED_DESC = "Enable or not the diagnostic";
    private static final String TOL_DESC = "Tolerance";
    private static final String ERR_DESC = "Error";
    private static final String SEV_DESC = "Severe";
    private static final String BAD_DESC = "Bad";
    private static final String UNC_DESC = "Uncertain";
    private static final String SHORT_DESC = "Length of series considered as short (in years)";
    private static final String ANNUAL_CATEGORY = "Annual totals (lower bound)";
    private static final String MISC_CATEGORY = "Miscellaneous";

    public void check() {
        if (this.m_Error < this.m_Severe || this.m_Severe < this.m_Bad || this.m_Bad < this.m_Uncertain || this.m_Uncertain < 0.0) {
            throw new BaseException("Invalid settings in Annual totals diagnostics");
        }
    }

    public boolean isEnabled() {
        return this.m_Enabled;
    }

    public void setEnabled(boolean value) {
        this.m_Enabled = value;
    }

    public double getTolerance() {
        return this.m_Tolerance;
    }

    public void setTolerance(double value) {
        if (value <= 0.0 || value > 0.1) {
            throw new BaseException("Should be in ]0, 0.1]");
        }
        this.m_Tolerance = value;
    }

    public double getError() {
        return this.m_Error;
    }

    public void setError(double value) {
        this.m_Error = value;
    }

    public double getSevere() {
        return this.m_Severe;
    }

    public void setSevere(double value) {
        this.m_Severe = value;
    }

    public double getBad() {
        return this.m_Bad;
    }

    public void setBad(double value) {
        this.m_Bad = value;
    }

    public double getUncertain() {
        return this.m_Uncertain;
    }

    public void setUncertain(double value) {
        this.m_Uncertain = value;
    }

    public int getShortSeries() {
        return this.m_ShortSeries;
    }

    public void setShortSeries(int value) {
        if (value <= 3) {
            throw new TsException("Invalid value. Should be > 3");
        }
        this.m_ShortSeries = value;
    }

    public CoherenceDiagnosticsConfiguration clone() {
        try {
            return (CoherenceDiagnosticsConfiguration)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            return null;
        }
    }

    public List<EnhancedPropertyDescriptor> getProperties() {
        ArrayList<EnhancedPropertyDescriptor> descs = new ArrayList<EnhancedPropertyDescriptor>();
        EnhancedPropertyDescriptor desc = this.enabledDesc();
        if (desc != null) {
            descs.add(desc);
        }
        if ((desc = this.tolDesc()) != null) {
            descs.add(desc);
        }
        if ((desc = this.errDesc()) != null) {
            descs.add(desc);
        }
        if ((desc = this.sevDesc()) != null) {
            descs.add(desc);
        }
        if ((desc = this.badDesc()) != null) {
            descs.add(desc);
        }
        if ((desc = this.uncDesc()) != null) {
            descs.add(desc);
        }
        if ((desc = this.shortDesc()) != null) {
            descs.add(desc);
        }
        return descs;
    }

    public String getDisplayName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private EnhancedPropertyDescriptor enabledDesc() {
        try {
            PropertyDescriptor desc = new PropertyDescriptor("enabled", this.getClass());
            EnhancedPropertyDescriptor edesc = new EnhancedPropertyDescriptor(desc, 1);
            edesc.setRefreshMode(EnhancedPropertyDescriptor.Refresh.All);
            desc.setShortDescription(ENABLED_DESC);
            return edesc;
        }
        catch (IntrospectionException ex) {
            return null;
        }
    }

    private EnhancedPropertyDescriptor tolDesc() {
        try {
            PropertyDescriptor desc = new PropertyDescriptor("tolerance", this.getClass());
            EnhancedPropertyDescriptor edesc = new EnhancedPropertyDescriptor(desc, 2);
            edesc.setRefreshMode(EnhancedPropertyDescriptor.Refresh.All);
            desc.setShortDescription(TOL_DESC);
            edesc.setReadOnly(this.m_Enabled);
            return edesc;
        }
        catch (IntrospectionException ex) {
            return null;
        }
    }

    private EnhancedPropertyDescriptor errDesc() {
        try {
            PropertyDescriptor desc = new PropertyDescriptor("error", this.getClass());
            EnhancedPropertyDescriptor edesc = new EnhancedPropertyDescriptor(desc, 3);
            edesc.setRefreshMode(EnhancedPropertyDescriptor.Refresh.All);
            desc.setShortDescription(ERR_DESC);
            edesc.setReadOnly(this.m_Enabled);
            edesc.setCategory(ANNUAL_CATEGORY);
            return edesc;
        }
        catch (IntrospectionException ex) {
            return null;
        }
    }

    private EnhancedPropertyDescriptor sevDesc() {
        try {
            PropertyDescriptor desc = new PropertyDescriptor("severe", this.getClass());
            EnhancedPropertyDescriptor edesc = new EnhancedPropertyDescriptor(desc, 4);
            edesc.setRefreshMode(EnhancedPropertyDescriptor.Refresh.All);
            desc.setShortDescription(SEV_DESC);
            edesc.setReadOnly(this.m_Enabled);
            edesc.setCategory(ANNUAL_CATEGORY);
            return edesc;
        }
        catch (IntrospectionException ex) {
            return null;
        }
    }

    private EnhancedPropertyDescriptor badDesc() {
        try {
            PropertyDescriptor desc = new PropertyDescriptor("bad", this.getClass());
            EnhancedPropertyDescriptor edesc = new EnhancedPropertyDescriptor(desc, 5);
            edesc.setRefreshMode(EnhancedPropertyDescriptor.Refresh.All);
            desc.setShortDescription(BAD_DESC);
            edesc.setReadOnly(this.m_Enabled);
            edesc.setCategory(ANNUAL_CATEGORY);
            return edesc;
        }
        catch (IntrospectionException ex) {
            return null;
        }
    }

    private EnhancedPropertyDescriptor uncDesc() {
        try {
            PropertyDescriptor desc = new PropertyDescriptor("uncertain", this.getClass());
            EnhancedPropertyDescriptor edesc = new EnhancedPropertyDescriptor(desc, 6);
            edesc.setRefreshMode(EnhancedPropertyDescriptor.Refresh.All);
            desc.setShortDescription(UNC_DESC);
            edesc.setReadOnly(this.m_Enabled);
            edesc.setCategory(ANNUAL_CATEGORY);
            return edesc;
        }
        catch (IntrospectionException ex) {
            return null;
        }
    }

    private EnhancedPropertyDescriptor shortDesc() {
        try {
            PropertyDescriptor desc = new PropertyDescriptor("shortSeries", this.getClass());
            EnhancedPropertyDescriptor edesc = new EnhancedPropertyDescriptor(desc, 7);
            edesc.setRefreshMode(EnhancedPropertyDescriptor.Refresh.All);
            desc.setShortDescription(SHORT_DESC);
            edesc.setReadOnly(this.m_Enabled);
            edesc.setCategory(MISC_CATEGORY);
            return edesc;
        }
        catch (IntrospectionException ex) {
            return null;
        }
    }
}

