/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.diagnostics;

import ec.satoolkit.x11.Mstatistics;
import ec.tss.sa.diagnostics.MDiagnosticsConfiguration;
import ec.tss.sa.diagnostics.MDiagnosticsFactory;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IDiagnostics;
import ec.tstoolkit.algorithm.ProcQuality;
import java.util.List;

public class MDiagnostics
implements IDiagnostics {
    public double[] stats_;
    private double bad_ = 1.0;
    private double severe_ = 2.0;
    private boolean all_ = true;

    public static MDiagnostics create(MDiagnosticsConfiguration config, CompositeResults rslts) {
        try {
            Mstatistics stats = (Mstatistics)rslts.get("m-statistics", Mstatistics.class);
            if (stats == null) {
                return null;
            }
            return new MDiagnostics(config, stats);
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected MDiagnostics(MDiagnosticsConfiguration config, Mstatistics mstats) {
        this.bad_ = config.getBad();
        this.severe_ = config.getSevere();
        this.all_ = config.isUseAll();
        int nm = mstats.getMCount();
        this.stats_ = new double[nm + 2];
        for (int i = 0; i < nm; ++i) {
            this.stats_[i] = mstats.getM(i + 1);
        }
        this.stats_[nm++] = mstats.getQ();
        this.stats_[nm] = mstats.getQm2();
    }

    public String getName() {
        return "M-Statistics";
    }

    public List<String> getTests() {
        return MDiagnosticsFactory.ALL;
    }

    public ProcQuality getDiagnostic(String test) {
        double pval = this.getValue(test);
        if (Double.isNaN(pval)) {
            return ProcQuality.Undefined;
        }
        if (pval >= this.severe_) {
            return ProcQuality.Severe;
        }
        if (pval >= this.bad_) {
            return ProcQuality.Bad;
        }
        return ProcQuality.Good;
    }

    public double getValue(String test) {
        double val = Double.NaN;
        if (test.equals("q")) {
            val = this.stats_[this.stats_.length - 2];
        }
        if (test.equals("q-m2")) {
            val = this.stats_[this.stats_.length - 1];
        }
        return val;
    }

    public List<String> getWarnings() {
        return null;
    }

    public double getBadThreshold() {
        return this.bad_;
    }

    public double getSevereThreshold() {
        return this.severe_;
    }

    public double[] getMStatistics() {
        return this.stats_;
    }
}

