/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.diagnostics;

import ec.satoolkit.GenericSaResults;
import ec.tss.sa.diagnostics.OutOfSampleDiagnosticsConfiguration;
import ec.tss.sa.diagnostics.OutOfSampleDiagnosticsFactory;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IDiagnostics;
import ec.tstoolkit.algorithm.ProcQuality;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.diagnostics.OneStepAheadForecastingTest;
import java.util.List;

public class OutOfSampleDiagnostics
implements IDiagnostics {
    private double ub_ = 0.1;
    private double bb_ = 0.01;
    private double mpval_;
    private double vpval_;

    static OutOfSampleDiagnostics create(OutOfSampleDiagnosticsConfiguration config, CompositeResults rslts) {
        try {
            if (rslts == null) {
                return null;
            }
            PreprocessingModel pp = GenericSaResults.getPreprocessingModel((CompositeResults)rslts);
            if (pp == null) {
                return null;
            }
            return new OutOfSampleDiagnostics(config, pp);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private OutOfSampleDiagnostics(OutOfSampleDiagnosticsConfiguration config, PreprocessingModel rslts) {
        this.bb_ = config.getBad();
        this.ub_ = config.getUncertain();
        this.test(rslts, config.getForecastingLength(), config.isMeanTestEnabled(), config.isMSETestEnabled());
    }

    private void test(PreprocessingModel rslts, double len, boolean m, boolean v) {
        int ifreq = rslts.description.getFrequency();
        int nback = (int)(len * (double)ifreq);
        if (nback < 5) {
            nback = 5;
        }
        OneStepAheadForecastingTest xtest = new OneStepAheadForecastingTest(nback);
        xtest.test(rslts.estimation.getRegArima());
        this.mpval_ = m ? xtest.outOfSampleMeanTest().getPValue() : Double.NaN;
        this.vpval_ = v ? xtest.mseTest().getPValue() : Double.NaN;
    }

    public String getName() {
        return "Out-of-sample";
    }

    public List<String> getTests() {
        return OutOfSampleDiagnosticsFactory.ALL;
    }

    public ProcQuality getDiagnostic(String test) {
        double r = this.getValue(test);
        if (Double.isNaN(r)) {
            return ProcQuality.Undefined;
        }
        if (r < this.bb_) {
            return ProcQuality.Bad;
        }
        if (r < this.ub_) {
            return ProcQuality.Uncertain;
        }
        return ProcQuality.Good;
    }

    public double getValue(String test) {
        if (test.equals("mean")) {
            return this.mpval_;
        }
        if (test.equals("mse")) {
            return this.vpval_;
        }
        return Double.NaN;
    }

    public List<String> getWarnings() {
        return null;
    }
}

