/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.diagnostics;

import ec.satoolkit.GenericSaResults;
import ec.tss.sa.diagnostics.OutliersDiagnosticsConfiguration;
import ec.tss.sa.diagnostics.OutliersDiagnosticsFactory;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IDiagnostics;
import ec.tstoolkit.algorithm.ProcQuality;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.List;

public final class OutliersDiagnostics
implements IDiagnostics {
    private double ub_ = 0.03;
    private double bb_ = 0.05;
    private double sb_ = 0.1;
    private int n_;
    private int p_;
    private int o_;

    static OutliersDiagnostics create(OutliersDiagnosticsConfiguration config, CompositeResults rslts) {
        try {
            if (rslts == null) {
                return null;
            }
            PreprocessingModel pp = GenericSaResults.getPreprocessingModel((CompositeResults)rslts);
            if (pp == null) {
                return null;
            }
            return new OutliersDiagnostics(config, pp);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private OutliersDiagnostics(OutliersDiagnosticsConfiguration config, PreprocessingModel rslts) {
        this.sb_ = config.getSevere();
        this.bb_ = config.getBad();
        this.ub_ = config.getUncertain();
        this.test(rslts);
    }

    private void test(PreprocessingModel rslts) {
        TsData y = rslts.description.getOriginal();
        if (y == null) {
            return;
        }
        this.n_ = y.getObsCount();
        this.p_ = rslts.description.getPrespecifiedOutliers().size();
        this.o_ = rslts.description.getOutliers().size();
    }

    public String getName() {
        return "Outliers";
    }

    public List<String> getTests() {
        return OutliersDiagnosticsFactory.ALL;
    }

    public ProcQuality getDiagnostic(String test) {
        double r = this.getValue(test);
        if (Double.isNaN(r)) {
            return ProcQuality.Undefined;
        }
        if (r > this.sb_) {
            return ProcQuality.Severe;
        }
        if (r > this.bb_) {
            return ProcQuality.Bad;
        }
        if (r > this.ub_) {
            return ProcQuality.Uncertain;
        }
        return ProcQuality.Good;
    }

    public double getValue(String test) {
        double val = Double.NaN;
        if (!test.equals("number of outliers")) {
            return val;
        }
        if (Double.isNaN(this.n_)) {
            return val;
        }
        double r = this.p_ + this.o_;
        val = r /= (double)this.n_;
        return val;
    }

    public List<String> getWarnings() {
        return null;
    }
}

