/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.diagnostics;

import ec.satoolkit.GenericSaResults;
import ec.satoolkit.ISaResults;
import ec.satoolkit.diagnostics.SeasonalityTest;
import ec.tss.sa.diagnostics.ResidualSeasonalityDiagnosticsConfiguration;
import ec.tss.sa.diagnostics.ResidualSeasonalityDiagnosticsFactory;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IDiagnostics;
import ec.tstoolkit.algorithm.ProcQuality;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.List;

public class ResidualSeasonalityDiagnostics
implements IDiagnostics {
    private SeasonalityTest fsa_;
    private SeasonalityTest fsa3_;
    private SeasonalityTest firr_;
    private double[] sa_ = new double[]{0.1, 0.05, 0.01};
    private double[] sa3_ = new double[]{0.1, 0.05, 0.01};
    private double[] irr_ = new double[]{0.1, 0.05, 0.01};

    protected static ResidualSeasonalityDiagnostics create(ResidualSeasonalityDiagnosticsConfiguration config, CompositeResults rslts) {
        try {
            ResidualSeasonalityDiagnostics diag = new ResidualSeasonalityDiagnostics(config);
            if (!diag.test(rslts)) {
                return null;
            }
            return diag;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public ResidualSeasonalityDiagnostics(ResidualSeasonalityDiagnosticsConfiguration config) {
        this.setSABounds(config.getSASevere(), config.getSABad(), config.getSAUncertain());
        this.setIrrBounds(config.getIrrSevere(), config.getIrrBad(), config.getIrrUncertain());
        this.setSA3Bounds(config.getSA3Severe(), config.getSA3Bad(), config.getSA3Uncertain());
    }

    public boolean test(CompositeResults rslts) {
        if (rslts == null || GenericSaResults.getDecomposition((CompositeResults)rslts, ISaResults.class) == null) {
            return false;
        }
        TsData s = (TsData)rslts.getData("sa", TsData.class);
        if (s != null) {
            int freq = s.getFrequency().intValue();
            s = s.delta(Math.max(1, freq / 4));
            this.fsa_ = SeasonalityTest.stableSeasonality((TsData)s);
            TsPeriodSelector sel = new TsPeriodSelector();
            sel.last(s.getFrequency().intValue() * 3);
            this.fsa3_ = SeasonalityTest.stableSeasonality((TsData)s.select(sel));
        }
        if ((s = (TsData)rslts.getData("i", TsData.class)) != null) {
            this.firr_ = SeasonalityTest.stableSeasonality((TsData)s);
        }
        return true;
    }

    public double getSABound(ProcQuality quality) {
        return this.bound(this.sa_, quality);
    }

    public double getIrrBound(ProcQuality quality) {
        return this.bound(this.irr_, quality);
    }

    public double getSA3Bound(ProcQuality quality) {
        return this.bound(this.sa3_, quality);
    }

    private void setSABounds(double severe, double bad, double uncertain) {
        this.setbounds(this.sa_, severe, bad, uncertain);
    }

    private void setIrrBounds(double severe, double bad, double uncertain) {
        this.setbounds(this.irr_, severe, bad, uncertain);
    }

    private void setSA3Bounds(double severe, double bad, double uncertain) {
        this.setbounds(this.sa3_, severe, bad, uncertain);
    }

    private void setbounds(double[] lb, double severe, double bad, double uncertain) {
        lb[0] = uncertain;
        lb[1] = bad;
        lb[2] = severe;
    }

    private double bound(double[] lb, ProcQuality quality) {
        if (quality == ProcQuality.Severe) {
            return lb[2];
        }
        if (quality == ProcQuality.Bad) {
            return lb[1];
        }
        if (quality == ProcQuality.Uncertain) {
            return lb[0];
        }
        return Double.NaN;
    }

    public String getName() {
        return "combined seasonality test";
    }

    public List<String> getTests() {
        return ResidualSeasonalityDiagnosticsFactory.ALL;
    }

    public ProcQuality getDiagnostic(String test) {
        if (test.equals("combined seasonality test on sa")) {
            return ResidualSeasonalityDiagnostics.test(this.fsa_, this.sa_);
        }
        if (test.equals("combined seasonality test on sa (last 3 years)")) {
            return ResidualSeasonalityDiagnostics.test(this.fsa3_, this.sa3_);
        }
        return ResidualSeasonalityDiagnostics.test(this.firr_, this.irr_);
    }

    public double getValue(String test) {
        double val = 0.0;
        if (test.equals("combined seasonality test on sa") && this.fsa_ != null) {
            val = this.fsa_.getPValue();
        } else if (test.equals("combined seasonality test on sa (last 3 years)") && this.fsa3_ != null) {
            val = this.fsa3_.getPValue();
        } else if (this.firr_ != null) {
            val = this.firr_.getPValue();
        }
        return val;
    }

    private static ProcQuality test(SeasonalityTest test, double[] b) {
        if (test == null) {
            return ProcQuality.Undefined;
        }
        if (test.getPValue() > b[0]) {
            return ProcQuality.Good;
        }
        if (test.getPValue() > b[1]) {
            return ProcQuality.Uncertain;
        }
        if (test.getPValue() > b[2]) {
            return ProcQuality.Bad;
        }
        return ProcQuality.Severe;
    }

    public List<String> getWarnings() {
        return null;
    }
}

