/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.diagnostics;

import ec.tss.sa.ISaDiagnosticsFactory;
import ec.tss.sa.diagnostics.ResidualSeasonalityDiagnostics;
import ec.tss.sa.diagnostics.ResidualSeasonalityDiagnosticsConfiguration;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IDiagnostics;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ResidualSeasonalityDiagnosticsFactory
implements ISaDiagnosticsFactory {
    public static final String NAME = "combined seasonality test";
    public static final String SA = "combined seasonality test on sa";
    public static final String SA_LAST = "combined seasonality test on sa (last 3 years)";
    public static final String IRR = "combined seasonality test on irregular";
    public static final List<String> ALL = Collections.unmodifiableList(Arrays.asList("combined seasonality test on sa", "combined seasonality test on sa (last 3 years)", "combined seasonality test on irregular"));
    private ResidualSeasonalityDiagnosticsConfiguration config_;

    public ResidualSeasonalityDiagnosticsFactory() {
        this.config_ = new ResidualSeasonalityDiagnosticsConfiguration();
    }

    public ResidualSeasonalityDiagnosticsFactory(ResidualSeasonalityDiagnosticsConfiguration config) {
        this.config_ = config;
    }

    public ResidualSeasonalityDiagnosticsConfiguration getConfiguration() {
        return this.config_;
    }

    public void dispose() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return "Checks the presence of residual seasonality (combined test)";
    }

    public List<String> getTestDictionary() {
        return ALL.stream().map(s -> s + ":2").collect(Collectors.toList());
    }

    public boolean isEnabled() {
        return this.config_.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.config_.setEnabled(enabled);
    }

    public Object getProperties() {
        return this.config_.clone();
    }

    public void setProperties(Object obj) {
        ResidualSeasonalityDiagnosticsConfiguration config = (ResidualSeasonalityDiagnosticsConfiguration)obj;
        if (config != null) {
            config.check();
            this.config_ = config.clone();
        }
    }

    public IDiagnostics create(CompositeResults rslts) {
        return ResidualSeasonalityDiagnostics.create(this.config_, rslts);
    }

    @Override
    public ISaDiagnosticsFactory.Scope getScope() {
        return ISaDiagnosticsFactory.Scope.Final;
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

