/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.diagnostics;

import ec.satoolkit.DecompositionMode;
import ec.tss.sa.diagnostics.ResidualTradingDaysDiagnosticsConfiguration;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IDiagnostics;
import ec.tstoolkit.algorithm.ProcQuality;
import ec.tstoolkit.data.DataBlock;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.eco.Ols;
import ec.tstoolkit.eco.RegModel;
import ec.tstoolkit.modelling.arima.JointRegressionTest;
import ec.tstoolkit.stats.StatisticalTest;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.GregorianCalendarVariables;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ResidualTradingDaysDiagnostics
implements IDiagnostics {
    private StatisticalTest f_sa;
    private StatisticalTest f_i;
    private double sev;
    private double bad;
    private double unc;
    private static final double E_LIMIT = 0.005;

    private static boolean isMultiplicative(CompositeResults rslts) {
        DecompositionMode mul = (DecompositionMode)rslts.getData("mode", DecompositionMode.class);
        return mul != null && mul.isMultiplicative();
    }

    private static boolean isSignificant(TsData s, TsData ref) {
        DescriptiveStatistics sdesc = new DescriptiveStatistics((IReadDataBlock)s);
        DescriptiveStatistics refdesc = new DescriptiveStatistics((IReadDataBlock)ref);
        double se = sdesc.getStdev();
        double refe = refdesc.getRmse();
        return refe == 0.0 || se / refe > 0.005;
    }

    private static boolean isSignificant(TsData i) {
        if (i == null) {
            return false;
        }
        DescriptiveStatistics idesc = new DescriptiveStatistics((IReadDataBlock)i);
        double se = idesc.getStdev();
        return se > 0.005;
    }

    static IDiagnostics create(CompositeResults rslts, ResidualTradingDaysDiagnosticsConfiguration config) {
        try {
            int ifreq;
            boolean isignif;
            ResidualTradingDaysDiagnostics test = new ResidualTradingDaysDiagnostics();
            TsData sa = (TsData)rslts.getData("sa_cmp", TsData.class);
            TsData i = (TsData)rslts.getData("i_cmp", TsData.class);
            if (sa == null && i == null) {
                return null;
            }
            int ny = config.getSpan();
            boolean ar = config.isArModelling();
            boolean mul = ResidualTradingDaysDiagnostics.isMultiplicative(rslts);
            boolean bl = mul ? ResidualTradingDaysDiagnostics.isSignificant(i) : (isignif = sa != null && i != null ? ResidualTradingDaysDiagnostics.isSignificant(i, sa) : true);
            if (sa != null) {
                TsData salast;
                if (mul) {
                    sa = sa.log();
                }
                ifreq = sa.getFrequency().intValue();
                if (ar) {
                    salast = sa;
                    if (ny != 0) {
                        salast = sa.drop(Math.max(0, sa.getLength() - ifreq * ny - 1), 0);
                    }
                    test.f_sa = ResidualTradingDaysDiagnostics.processAr(salast);
                } else {
                    salast = sa.delta(1);
                    if (ny != 0) {
                        salast = sa.drop(Math.max(0, sa.getLength() - ifreq * ny), 0);
                    }
                    test.f_sa = ResidualTradingDaysDiagnostics.process(salast);
                }
            }
            if (i != null && isignif) {
                if (mul) {
                    i = i.log();
                }
                ifreq = i.getFrequency().intValue();
                TsData ilast = i;
                if (ar) {
                    if (ny != 0) {
                        ilast = i.drop(Math.max(0, i.getLength() - ifreq * ny - 1), 0);
                    }
                    test.f_i = ResidualTradingDaysDiagnostics.processAr(ilast);
                } else {
                    if (ny != 0) {
                        ilast = i.drop(Math.max(0, i.getLength() - ifreq * ny), 0);
                    }
                    test.f_i = ResidualTradingDaysDiagnostics.process(ilast);
                }
            }
            test.sev = config.getSevereThreshold();
            test.bad = config.getBadThreshold();
            test.unc = config.getUncertainThreshold();
            return test;
        }
        catch (Exception err) {
            return null;
        }
    }

    public String getName() {
        return "Residual trading days tests";
    }

    public List<String> getTests() {
        ArrayList<String> tests = new ArrayList<String>();
        if (this.f_sa != null) {
            tests.add("F-Test on SA (td)");
        }
        if (this.f_i != null) {
            tests.add("F-Test on I (td)");
        }
        return tests;
    }

    public ProcQuality getDiagnostic(String test) {
        switch (test) {
            case "F-Test on SA (td)": {
                return this.quality(this.f_sa);
            }
            case "F-Test on I (td)": {
                return this.quality(this.f_i);
            }
        }
        return ProcQuality.Undefined;
    }

    public double getValue(String test) {
        switch (test) {
            case "F-Test on SA (td)": {
                return this.pvalue(this.f_sa);
            }
            case "F-Test on I (td)": {
                return this.pvalue(this.f_i);
            }
        }
        return Double.NaN;
    }

    public List<String> getWarnings() {
        return Collections.emptyList();
    }

    private ProcQuality quality(StatisticalTest test) {
        if (test == null) {
            return ProcQuality.Undefined;
        }
        double pval = test.getPValue();
        if (pval < this.sev) {
            return ProcQuality.Severe;
        }
        if (pval < this.bad) {
            return ProcQuality.Bad;
        }
        if (pval < this.unc) {
            return ProcQuality.Uncertain;
        }
        return ProcQuality.Good;
    }

    private double pvalue(StatisticalTest test) {
        return test == null ? Double.NaN : test.getPValue();
    }

    private static StatisticalTest process(TsData s) {
        try {
            int i;
            RegModel reg = new RegModel();
            DataBlock y = new DataBlock((IReadDataBlock)s);
            y.add(-y.average());
            reg.setY(y);
            GregorianCalendarVariables tdvars = GregorianCalendarVariables.getDefault((TradingDaysType)TradingDaysType.TradingDays);
            int ntd = tdvars.getDim();
            TsDomain edomain = s.getDomain();
            ArrayList<DataBlock> bvars = new ArrayList<DataBlock>(ntd);
            for (i = 0; i < ntd; ++i) {
                bvars.add(new DataBlock(edomain.getLength()));
            }
            tdvars.data(edomain, bvars);
            for (i = 0; i < ntd; ++i) {
                DataBlock cur = (DataBlock)bvars.get(i);
                reg.addX(cur);
            }
            Ols ols = new Ols();
            if (!ols.process(reg)) {
                return null;
            }
            JointRegressionTest test = new JointRegressionTest(0.01);
            test.accept(ols.getLikelihood(), 0, 0, ntd, null);
            return test.getTest();
        }
        catch (Exception err) {
            return null;
        }
    }

    private static StatisticalTest processAr(TsData s) {
        try {
            int i;
            RegModel reg = new RegModel();
            DataBlock y = new DataBlock((IReadDataBlock)s);
            reg.setY(y.drop(1, 0));
            GregorianCalendarVariables tdvars = GregorianCalendarVariables.getDefault((TradingDaysType)TradingDaysType.TradingDays);
            int ntd = tdvars.getDim();
            TsDomain edomain = s.getDomain().drop(1, 0);
            ArrayList<DataBlock> bvars = new ArrayList<DataBlock>(ntd);
            for (i = 0; i < ntd; ++i) {
                bvars.add(new DataBlock(edomain.getLength()));
            }
            tdvars.data(edomain, bvars);
            reg.addX(y.drop(0, 1));
            for (i = 0; i < ntd; ++i) {
                DataBlock cur = (DataBlock)bvars.get(i);
                reg.addX(cur);
            }
            Ols ols = new Ols();
            reg.setMeanCorrection(true);
            if (!ols.process(reg)) {
                return null;
            }
            JointRegressionTest test = new JointRegressionTest(0.01);
            test.accept(ols.getLikelihood(), 0, 2, ntd, null);
            return test.getTest();
        }
        catch (Exception err) {
            return null;
        }
    }
}

