/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.diagnostics;

import ec.satoolkit.GenericSaResults;
import ec.tss.sa.diagnostics.ResidualsDiagnosticsConfiguration;
import ec.tss.sa.diagnostics.ResidualsDiagnosticsFactory;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IDiagnostics;
import ec.tstoolkit.algorithm.ProcQuality;
import ec.tstoolkit.data.IReadDataBlock;
import ec.tstoolkit.data.Periodogram;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.stats.DoornikHansenTest;
import ec.tstoolkit.stats.LjungBoxTest;
import ec.tstoolkit.stats.NiidTests;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.ArrayList;
import java.util.List;

public class ResidualsDiagnostics
implements IDiagnostics {
    private double N0_ = 0.1;
    private double N1_ = 0.01;
    private double tdPeriodogram0_ = 0.1;
    private double tdPeriodogram1_ = 0.01;
    private double tdPeriodogram2_ = 0.001;
    private double sPeriodogram0_ = 0.1;
    private double sPeriodogram1_ = 0.01;
    private double sPeriodogram2_ = 0.001;
    private final List<String> warnings_ = new ArrayList<String>();
    private NiidTests stats_;
    private Periodogram periodogram_;
    private int freq_;

    static ResidualsDiagnostics create(ResidualsDiagnosticsConfiguration config, CompositeResults crslts) {
        try {
            PreprocessingModel regarima = GenericSaResults.getPreprocessingModel((CompositeResults)crslts);
            if (regarima instanceof PreprocessingModel) {
                return new ResidualsDiagnostics(config, regarima);
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public ResidualsDiagnostics(ResidualsDiagnosticsConfiguration config, PreprocessingModel rslts) {
        this.sPeriodogram2_ = config.getSpecSeasSevere();
        this.sPeriodogram1_ = config.getSpecSeasBad();
        this.sPeriodogram0_ = config.getSpecSeasUncertain();
        this.tdPeriodogram2_ = config.getSpecTDSevere();
        this.tdPeriodogram1_ = config.getSpecTDBad();
        this.tdPeriodogram0_ = config.getSpecTDUncertain();
        this.N0_ = config.getNIIDUncertain();
        this.N1_ = config.getNIIDBad();
        this.testRegarima(rslts);
    }

    private boolean testRegarima(PreprocessingModel regarima) {
        try {
            TsData res = regarima.getFullResiduals();
            this.freq_ = res.getFrequency().intValue();
            this.stats_ = new NiidTests((IReadDataBlock)res, this.freq_, regarima.description.getArimaComponent().getFreeParametersCount(), true);
            this.periodogram_ = new Periodogram((IReadDataBlock)res);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public String getName() {
        return "Regarima residuals";
    }

    public List<String> getTests() {
        return ResidualsDiagnosticsFactory.ALL;
    }

    public ProcQuality getDiagnostic(String test) {
        double pval = 0.0;
        switch (test) {
            case "normality": {
                if (this.stats_ == null) {
                    return ProcQuality.Undefined;
                }
                DoornikHansenTest dht = this.stats_.getNormalityTest();
                if (dht == null) {
                    return ProcQuality.Undefined;
                }
                pval = dht.getPValue();
                if (pval > this.N0_) {
                    return ProcQuality.Good;
                }
                if (pval < this.N1_) {
                    return ProcQuality.Bad;
                }
                return ProcQuality.Uncertain;
            }
            case "independence": {
                if (this.stats_ == null) {
                    return ProcQuality.Undefined;
                }
                LjungBoxTest lbt = this.stats_.getLjungBox();
                if (lbt == null) {
                    return ProcQuality.Undefined;
                }
                pval = lbt.getPValue();
                if (pval > this.N0_) {
                    return ProcQuality.Good;
                }
                if (pval < this.N1_) {
                    return ProcQuality.Bad;
                }
                return ProcQuality.Uncertain;
            }
            case "spectral td peaks": {
                if (this.periodogram_ == null) {
                    return ProcQuality.Undefined;
                }
                double[] tdfreqs = Periodogram.getTradingDaysFrequencies((int)this.freq_);
                double[] p = this.periodogram_.getS();
                double xmax = 0.0;
                double dstep = this.periodogram_.getIntervalInRadians();
                for (int i = 0; i < tdfreqs.length; ++i) {
                    int i0 = (int)(tdfreqs[i] / dstep);
                    double xcur = p[i0];
                    if (xcur > xmax) {
                        xmax = xcur;
                    }
                    if (!((xcur = p[i0 + 1]) > xmax)) continue;
                    xmax = xcur;
                }
                pval = 1.0 - Math.pow(1.0 - Math.exp(-xmax * 0.5), tdfreqs.length);
                if (pval < this.tdPeriodogram2_) {
                    return ProcQuality.Severe;
                }
                if (pval < this.tdPeriodogram1_) {
                    return ProcQuality.Bad;
                }
                if (pval > this.tdPeriodogram0_) {
                    return ProcQuality.Good;
                }
                return ProcQuality.Uncertain;
            }
            case "spectral seas peaks": {
                if (this.periodogram_ == null) {
                    return ProcQuality.Undefined;
                }
                double[] seasfreqs = new double[(this.freq_ - 1) / 2];
                for (int i = 0; i < seasfreqs.length; ++i) {
                    seasfreqs[i] = (double)((i + 1) * 2) * Math.PI / (double)this.freq_;
                }
                double[] p = this.periodogram_.getS();
                double xmax = 0.0;
                double dstep = this.periodogram_.getIntervalInRadians();
                for (int i = 0; i < seasfreqs.length; ++i) {
                    int i0 = (int)(seasfreqs[i] / dstep);
                    double xcur = p[i0];
                    if (xcur > xmax) {
                        xmax = xcur;
                    }
                    if (!((xcur = p[i0 + 1]) > xmax)) continue;
                    xmax = xcur;
                }
                pval = 1.0 - Math.pow(1.0 - Math.exp(-xmax * 0.5), seasfreqs.length);
                if (pval < this.sPeriodogram2_) {
                    return ProcQuality.Severe;
                }
                if (pval < this.sPeriodogram1_) {
                    return ProcQuality.Bad;
                }
                if (pval > this.sPeriodogram0_) {
                    return ProcQuality.Good;
                }
                return ProcQuality.Uncertain;
            }
        }
        return ProcQuality.Undefined;
    }

    public double getValue(String test) {
        try {
            double pval = 0.0;
            switch (test) {
                case "normality": {
                    if (this.stats_ == null) break;
                    DoornikHansenTest dht = this.stats_.getNormalityTest();
                    pval = dht.getPValue();
                    break;
                }
                case "independence": {
                    if (this.stats_ == null) break;
                    LjungBoxTest lbt = this.stats_.getLjungBox();
                    pval = lbt.getPValue();
                    break;
                }
                case "spectral td peaks": {
                    if (this.periodogram_ == null) break;
                    double[] tdfreqs = Periodogram.getTradingDaysFrequencies((int)this.freq_);
                    double[] p = this.periodogram_.getS();
                    double xmax = 0.0;
                    double dstep = this.periodogram_.getIntervalInRadians();
                    for (int i = 0; i < tdfreqs.length; ++i) {
                        int i0 = (int)(tdfreqs[i] / dstep);
                        double xcur = p[i0];
                        if (xcur > xmax) {
                            xmax = xcur;
                        }
                        if (!((xcur = p[i0 + 1]) > xmax)) continue;
                        xmax = xcur;
                    }
                    pval = 1.0 - Math.pow(1.0 - Math.exp(-xmax * 0.5), tdfreqs.length);
                    break;
                }
                case "spectral seas peaks": {
                    if (this.periodogram_ == null) break;
                    double[] seasfreqs = new double[(this.freq_ - 1) / 2];
                    for (int i = 0; i < seasfreqs.length; ++i) {
                        seasfreqs[i] = (double)((i + 1) * 2) * Math.PI / (double)this.freq_;
                    }
                    double[] p = this.periodogram_.getS();
                    double xmax = 0.0;
                    double dstep = this.periodogram_.getIntervalInRadians();
                    for (int i = 0; i < seasfreqs.length; ++i) {
                        int i0 = (int)(seasfreqs[i] / dstep);
                        double xcur = p[i0];
                        if (xcur > xmax) {
                            xmax = xcur;
                        }
                        if (!((xcur = p[i0 + 1]) > xmax)) continue;
                        xmax = xcur;
                    }
                    pval = 1.0 - Math.pow(1.0 - Math.exp(-xmax * 0.5), seasfreqs.length);
                    break;
                }
            }
            return pval;
        }
        catch (Exception err) {
            return Double.NaN;
        }
    }

    public List<String> getWarnings() {
        return this.warnings_;
    }

    public double getNIIDBound(ProcQuality quality) {
        switch (quality) {
            case Bad: {
                return this.N1_;
            }
            case Uncertain: {
                return this.N0_;
            }
        }
        return Double.NaN;
    }

    public double getTDPeriodogram(ProcQuality quality) {
        switch (quality) {
            case Severe: {
                return this.tdPeriodogram2_;
            }
            case Bad: {
                return this.tdPeriodogram1_;
            }
            case Uncertain: {
                return this.tdPeriodogram0_;
            }
        }
        return Double.NaN;
    }

    public double getSPeriodogram(ProcQuality quality) {
        switch (quality) {
            case Severe: {
                return this.sPeriodogram2_;
            }
            case Bad: {
                return this.sPeriodogram1_;
            }
            case Uncertain: {
                return this.sPeriodogram0_;
            }
        }
        return Double.NaN;
    }
}

