/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.diagnostics;

import ec.tss.sa.ISaDiagnosticsFactory;
import ec.tss.sa.diagnostics.ResidualsDiagnostics;
import ec.tss.sa.diagnostics.ResidualsDiagnosticsConfiguration;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IDiagnostics;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ResidualsDiagnosticsFactory
implements ISaDiagnosticsFactory {
    public static final String NORMALITY = "normality";
    public static final String INDEPENDENCE = "independence";
    public static final String TD_PEAK = "spectral td peaks";
    public static final String S_PEAK = "spectral seas peaks";
    public static final String NAME = "Regarima residuals";
    public static List<String> ALL = Collections.unmodifiableList(Arrays.asList("normality", "independence", "spectral td peaks", "spectral seas peaks"));
    private ResidualsDiagnosticsConfiguration config_;

    public ResidualsDiagnosticsFactory() {
        this.config_ = new ResidualsDiagnosticsConfiguration();
    }

    public ResidualsDiagnosticsFactory(ResidualsDiagnosticsConfiguration config) {
        this.config_ = config;
    }

    public ResidualsDiagnosticsConfiguration getConfiguration() {
        return this.config_;
    }

    public void dispose() {
    }

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return NAME;
    }

    public List<String> getTestDictionary() {
        return ALL.stream().map(s -> s + ":2").collect(Collectors.toList());
    }

    public boolean isEnabled() {
        return this.config_.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.config_.setEnabled(enabled);
    }

    public Object getProperties() {
        return this.config_.clone();
    }

    public void setProperties(Object obj) {
        ResidualsDiagnosticsConfiguration config = (ResidualsDiagnosticsConfiguration)obj;
        if (config != null) {
            config.check();
            this.config_ = config.clone();
        }
    }

    public IDiagnostics create(CompositeResults rslts) {
        return ResidualsDiagnostics.create(this.config_, rslts);
    }

    @Override
    public ISaDiagnosticsFactory.Scope getScope() {
        return ISaDiagnosticsFactory.Scope.Modelling;
    }

    @Override
    public int getOrder() {
        return 0;
    }
}

