/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.diagnostics;

import ec.satoolkit.GenericSaResults;
import ec.satoolkit.ISeriesDecomposition;
import ec.satoolkit.seats.SeatsResults;
import ec.tss.sa.diagnostics.SeatsDiagnosticsConfiguration;
import ec.tss.sa.diagnostics.SeatsDiagnosticsFactory;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IDiagnostics;
import ec.tstoolkit.algorithm.ProcQuality;
import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.ucarima.UcarimaModel;
import ec.tstoolkit.ucarima.WienerKolmogorovDiagnostics;
import java.util.Collections;
import java.util.List;

public class SeatsDiagnostics
implements IDiagnostics {
    private WienerKolmogorovDiagnostics diags_;
    private double bad_ = 0.005;
    private double uncertain_ = 0.05;
    private boolean same_;
    private boolean cutoff_;
    private static final int I_CMP = 3;
    private static final int S_CMP = 2;

    public static SeatsDiagnostics create(SeatsDiagnosticsConfiguration config, CompositeResults rslts) {
        try {
            SeatsResults srslts = (SeatsResults)GenericSaResults.getDecomposition((CompositeResults)rslts, SeatsResults.class);
            if (srslts == null) {
                return null;
            }
            SeatsDiagnostics sd = new SeatsDiagnostics(config, rslts);
            if (sd.isValid()) {
                return sd;
            }
            return null;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public SeatsDiagnostics(SeatsDiagnosticsConfiguration config, CompositeResults rslts) {
        this.bad_ = config.getBad();
        this.uncertain_ = config.getUncertain();
        this.test(rslts);
    }

    private void test(CompositeResults rslts) {
        PreprocessingModel pp = GenericSaResults.getPreprocessingModel((CompositeResults)rslts);
        SeatsResults srslts = (SeatsResults)GenericSaResults.getDecomposition((CompositeResults)rslts, SeatsResults.class);
        this.same_ = !srslts.getModel().isChanged();
        this.cutoff_ = srslts.getModel().isCutOff();
        ISeriesDecomposition decomposition = srslts.getComponents();
        UcarimaModel ucm = srslts.getUcarimaModel().clone();
        if (ucm.getComponentsCount() > 3) {
            ucm.compact(2, 2);
        }
        int[] cmps = new int[]{1, -2, 2, 3};
        double err = srslts.getModel().getSer();
        TsData t = decomposition.getSeries(ComponentType.Trend, ComponentInformation.Value);
        TsData s = decomposition.getSeries(ComponentType.Seasonal, ComponentInformation.Value);
        TsData i = decomposition.getSeries(ComponentType.Irregular, ComponentInformation.Value);
        TsData sa = decomposition.getSeries(ComponentType.SeasonallyAdjusted, ComponentInformation.Value);
        double[][] data = new double[][]{t == null ? null : t.internalStorage(), s == null ? null : sa.internalStorage(), s == null ? null : s.internalStorage(), i == null ? null : i.internalStorage()};
        this.diags_ = WienerKolmogorovDiagnostics.make((UcarimaModel)ucm, (double)err, (double[][])data, (int[])cmps);
    }

    public WienerKolmogorovDiagnostics getDiagnostics() {
        return this.diags_;
    }

    public double getBadThreshold() {
        return this.bad_;
    }

    public double getGoodThreshold() {
        return this.uncertain_;
    }

    public boolean isValid() {
        return this.diags_ != null;
    }

    public String getName() {
        return "Seats";
    }

    public List<String> getTests() {
        return SeatsDiagnosticsFactory.ALL;
    }

    public ProcQuality getDiagnostic(String test) {
        if (this.diags_ == null) {
            return ProcQuality.Undefined;
        }
        double pval = this.getValue(test);
        if (Double.isNaN(pval)) {
            return ProcQuality.Undefined;
        }
        if (pval <= this.bad_) {
            return ProcQuality.Bad;
        }
        if (pval > this.uncertain_) {
            return ProcQuality.Good;
        }
        return ProcQuality.Uncertain;
    }

    public double getValue(String test) {
        double val = Double.NaN;
        int icmp = -1;
        int jcmp = -1;
        if (test.equals("seas variance") || test.equals("seas/irr cross-correlation")) {
            icmp = 2;
        }
        if (test.equals("irregular variance") || test.equals("seas/irr cross-correlation")) {
            jcmp = 3;
        }
        if (test.equals("seas variance")) {
            val = this.diags_.getPValue(icmp);
        } else if (test.equals("irregular variance")) {
            val = this.diags_.getPValue(jcmp);
        } else if (icmp >= 0 && jcmp >= 0) {
            val = this.diags_.getPValue(icmp, jcmp);
        }
        return val;
    }

    public List<String> getWarnings() {
        if (!this.same_) {
            return Collections.singletonList("Non decomposable model. Changed by Seats");
        }
        if (this.cutoff_) {
            return Collections.singletonList("Parameters cut off by Seats");
        }
        return null;
    }
}

