/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.diagnostics;

import ec.tss.sa.ISaDiagnosticsFactory;
import ec.tss.sa.diagnostics.SeatsDiagnostics;
import ec.tss.sa.diagnostics.SeatsDiagnosticsConfiguration;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IDiagnostics;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SeatsDiagnosticsFactory
implements ISaDiagnosticsFactory {
    public static final String SEAS_VAR = "seas variance";
    public static final String IRR_VAR = "irregular variance";
    public static final String SEAS_I_CORR = "seas/irr cross-correlation";
    public static final String NOTSAME = "Non decomposable model. Changed by Seats";
    public static final String CUTOFF = "Parameters cut off by Seats";
    public static final String NAME = "Seats";
    public static final List<String> ALL = Collections.unmodifiableList(Arrays.asList("seas variance", "irregular variance", "seas/irr cross-correlation"));
    private SeatsDiagnosticsConfiguration config_;

    public SeatsDiagnosticsFactory() {
        SeatsDiagnosticsConfiguration config = null;
        if (config == null) {
            config = new SeatsDiagnosticsConfiguration();
        }
        this.config_ = config;
    }

    public SeatsDiagnosticsFactory(SeatsDiagnosticsConfiguration config) {
        this.config_ = config;
    }

    public SeatsDiagnosticsConfiguration getConfiguration() {
        return this.config_;
    }

    public void dispose() {
    }

    public String getName() {
        return NAME;
    }

    public String getDescription() {
        return "Comparison of the variance/covariance of estimators/estimates";
    }

    public List<String> getTestDictionary() {
        return ALL.stream().map(s -> s + ":2").collect(Collectors.toList());
    }

    public boolean isEnabled() {
        return this.config_.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.config_.setEnabled(enabled);
    }

    public Object getProperties() {
        return this.config_.clone();
    }

    public void setProperties(Object obj) {
        SeatsDiagnosticsConfiguration config = (SeatsDiagnosticsConfiguration)obj;
        if (config != null) {
            config.check();
            this.config_ = config.clone();
        }
    }

    public IDiagnostics create(CompositeResults rslts) {
        return SeatsDiagnostics.create(this.config_, rslts);
    }

    @Override
    public ISaDiagnosticsFactory.Scope getScope() {
        return ISaDiagnosticsFactory.Scope.Decomposition;
    }

    @Override
    public int getOrder() {
        return 100;
    }
}

