/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.diagnostics;

import ec.satoolkit.GenericSaResults;
import ec.satoolkit.ISaResults;
import ec.tss.sa.diagnostics.SpectralDiagnosticsConfiguration;
import ec.tss.sa.diagnostics.SpectralDiagnosticsFactory;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IDiagnostics;
import ec.tstoolkit.algorithm.ProcQuality;
import ec.tstoolkit.timeseries.TsPeriodSelector;
import ec.tstoolkit.timeseries.analysis.SpectralDiagnostic;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsFrequency;
import java.util.Collections;
import java.util.List;

public class SpectralDiagnostics
implements IDiagnostics {
    private boolean sorig_;
    private boolean ssa_;
    private boolean sirr_;
    private boolean tdsa_;
    private boolean tdirr_;
    private boolean strict_;
    private boolean processed_;

    protected static SpectralDiagnostics create(SpectralDiagnosticsConfiguration config, CompositeResults rslts) {
        try {
            if (rslts == null) {
                return null;
            }
            return new SpectralDiagnostics(config, rslts);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public SpectralDiagnostics(SpectralDiagnosticsConfiguration config, CompositeResults rslts) {
        this.processed_ = this.test(rslts, config.getSensitivity(), config.getLength(), config.isStrict());
    }

    private boolean test(CompositeResults rslt, double sens, int len, boolean strict) {
        this.strict_ = strict;
        try {
            if (rslt == null || GenericSaResults.getDecomposition((CompositeResults)rslt, ISaResults.class) == null) {
                return false;
            }
            boolean r = false;
            TsPeriodSelector sel = new TsPeriodSelector();
            SpectralDiagnostic diag = new SpectralDiagnostic();
            diag.setSensitivity(sens);
            TsData s = (TsData)rslt.getData("y_lin", TsData.class);
            if (s != null) {
                s = s.delta(1);
                if (len != 0) {
                    sel.last(len * s.getFrequency().intValue());
                    s = s.select(sel);
                }
                diag.setARLength(s.getFrequency() == TsFrequency.Monthly ? 30 : 3 * s.getFrequency().intValue());
                if (diag.test(s)) {
                    this.sorig_ = diag.hasSeasonalPeaks();
                }
            }
            if ((s = (TsData)rslt.getData("sa", TsData.class)) != null) {
                int del = Math.max(1, s.getFrequency().intValue() / 4);
                s = s.delta(del);
                if (len != 0) {
                    sel.last(len * s.getFrequency().intValue());
                    s = s.select(sel);
                }
                diag.setARLength(s.getFrequency() == TsFrequency.Monthly ? 30 : 3 * s.getFrequency().intValue());
                if (diag.test(s)) {
                    r = true;
                    this.ssa_ = diag.hasSeasonalPeaks();
                    if (s.getFrequency() == TsFrequency.Monthly) {
                        this.tdsa_ = diag.hasTradingDayPeaks();
                    }
                }
            }
            if ((s = (TsData)rslt.getData("i", TsData.class)) != null) {
                if (len != 0) {
                    r = true;
                    sel.last(len * s.getFrequency().intValue());
                    s = s.select(sel);
                }
                diag.setARLength(s.getFrequency() == TsFrequency.Monthly ? 30 : 3 * s.getFrequency().intValue());
                if (diag.test(s)) {
                    r = true;
                    this.sirr_ = diag.hasSeasonalPeaks();
                    if (s.getFrequency() == TsFrequency.Monthly) {
                        this.tdirr_ = diag.hasTradingDayPeaks();
                    }
                }
            }
            return r;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public String getName() {
        return "Visual spectral analysis";
    }

    public List<String> getTests() {
        return SpectralDiagnosticsFactory.ALL;
    }

    public ProcQuality getDiagnostic(String test) {
        if (!this.processed_) {
            return ProcQuality.Undefined;
        }
        if (test.equals("spectral seas peaks")) {
            if (!this.sirr_ && !this.ssa_) {
                return ProcQuality.Good;
            }
            if (this.sirr_ && this.ssa_) {
                return ProcQuality.Severe;
            }
            return this.strict_ ? ProcQuality.Severe : ProcQuality.Bad;
        }
        if (test.equals("spectral td peaks")) {
            if (!this.tdirr_ && !this.tdsa_) {
                return ProcQuality.Good;
            }
            if (this.tdirr_ && this.tdsa_) {
                return ProcQuality.Severe;
            }
            return this.strict_ ? ProcQuality.Severe : ProcQuality.Bad;
        }
        return ProcQuality.Undefined;
    }

    public double getValue(String test) {
        return 0.0;
    }

    public List<String> getWarnings() {
        if (!this.sorig_) {
            return Collections.singletonList("No seasonal peak in the original differenced series");
        }
        return Collections.emptyList();
    }
}

