/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.output;

import ec.tss.formatters.MatrixFormatter;
import ec.tss.sa.SaManager;
import ec.tstoolkit.algorithm.IDiagnosticsFactory;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.utilities.Files2;
import ec.tstoolkit.utilities.Id;
import java.io.File;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class BasicConfiguration {
    private static Character csvSeparator = null;
    private static final AtomicInteger ndec = new AtomicInteger(9);
    public static final String DEMETRA = "Demetra+";
    public static final String DEF_FILE = "demetra";
    public static final String defaultFolder = Files2.fromPath((String)ec.tstoolkit.utilities.Paths.getDefaultHome(), (String[])new String[]{"Demetra+"}).getPath();
    @Deprecated
    public static final String[] allDetails = new String[]{"span.start", "span.end", "span.n", "espan.start", "espan.end", "espan.n", "likelihood.neffectiveobs", "likelihood.np", "likelihood.logvalue", "likelihood.adjustedlogvalue", "likelihood.ssqerr", "likelihood.aic", "likelihood.aicc", "likelihood.bic", "likelihood.bicc", "residuals.ser", "residuals.ser-ml", "residuals.mean", "residuals.skewness", "residuals.kurtosis", "residuals.dh", "residuals.lb", "residuals.lb2", "residuals.seaslb", "residuals.bp", "residuals.bp2", "residuals.seasbp", "residuals.nruns", "residuals.lruns", "m-statistics.m1", "m-statistics.m2", "m-statistics.m3", "m-statistics.m4", "m-statistics.m5", "m-statistics.m6", "m-statistics.m7", "m-statistics.m8", "m-statistics.m9", "m-statistics.m10", "m-statistics.m11", "m-statistics.q", "m-statistics.q-m2", "diagnostics.quality", "diagnostics.basic checks.definition:2", "diagnostics.basic checks.annual totals:2", "diagnostics.visual spectral analysis.spectral seas peaks", "diagnostics.visual spectral analysis.spectral td peaks", "diagnostics.regarima residuals.normality:2", "diagnostics.regarima residuals.independence:2", "diagnostics.regarima residuals.spectral td peaks:2", "diagnostics.regarima residuals.spectral seas peaks:2", "diagnostics.residual seasonality.on sa:2", "diagnostics.residual seasonality.on sa (last 3 years):2", "diagnostics.residual seasonality.on irregular:2", "diagnostics.seats.seas variance:2", "diagnostics.seats.irregular variance:2", "diagnostics.seats.seas/irr cross-correlation:2", "log", "adjust", "arima.mean", "arima.p", "arima.d", "arima.q", "arima.bp", "arima.bd", "arima.bq", "arima.phi(1)", "arima.phi(2)", "arima.phi(3)", "arima.phi(4)", "arima.th(1)", "arima.th(2)", "arima.th(3)", "arima.th(4)", "arima.bphi(1)", "arima.bth(1)", "regression.lp:3", "regression.ntd", "regression.td(1):3", "regression.td(2):3", "regression.td(3):3", "regression.td(4):3", "regression.td(5):3", "regression.td(6):3", "regression.td(7):3", "regression.nmh", "regression.easter:3", "regression.nout", "regression.out(1):3", "regression.out(2):3", "regression.out(3):3", "regression.out(4):3", "regression.out(5):3", "regression.out(6):3", "regression.out(7):3", "regression.out(8):3", "regression.out(9):3", "regression.out(10):3", "regression.out(11):3", "regression.out(12):3", "regression.out(13):3", "regression.out(14):3", "regression.out(15):3", "regression.out(16):3", "decomposition.seasonality", "decomposition.trendfilter", "decomposition.seasfilter"};
    @Deprecated
    public static final String[] allSeries = new String[]{"y", "y_f", "y_ef", "yc", "yc_f", "yc_ef", "y_lin", "y_lin_f", "l", "ycal", "ycal_f", "l_f", "l_b", "t", "t_f", "sa", "sa_f", "s", "s_f", "i", "i_f", "det", "det_f", "cal", "cal_f", "tde", "tde_f", "mhe", "mhe_f", "ee", "ee_f", "omhe", "omhe_f", "out", "out_f", "out_i", "out_i_f", "out_t", "out_t_f", "out_s", "out_s_f", "reg", "reg_f", "reg_t", "reg_t_f", "reg_s", "reg_s_f", "reg_i", "reg_i_f", "reg_sa", "reg_sa_f", "reg_y", "reg_y_f", "fullresiduals", "decomposition.y_lin", "decomposition.y_lin_f", "decomposition.t_lin", "decomposition.t_lin_f", "decomposition.sa_lin", "decomposition.sa_lin_f", "decomposition.s_lin", "decomposition.s_lin_f", "decomposition.i_lin", "decomposition.i_lin_f", "decomposition.y_lin_ef", "decomposition.t_lin_e", "decomposition.t_lin_ef", "decomposition.sa_lin_e", "decomposition.sa_lin_ef", "decomposition.s_lin_e", "decomposition.s_lin_ef", "decomposition.i_lin_e", "decomposition.i_lin_ef", "decomposition.y_cmp", "decomposition.y_cmp_f", "decomposition.t_cmp", "decomposition.t_cmp_f", "decomposition.sa_cmp", "decomposition.sa_cmp_f", "decomposition.s_cmp", "decomposition.s_cmp_f", "decomposition.i_cmp", "decomposition.i_cmp_f", "decomposition.t_cmp_e", "decomposition.t_cmp_ef", "decomposition.sa_cmp_e", "decomposition.sa_cmp_ef", "decomposition.s_cmp_e", "decomposition.s_cmp_ef", "decomposition.i_cmp_e", "decomposition.i_cmp_ef", "decomposition.si_cmp", "benchmarking.target", "benchmarking.result"};

    public static int getFractionDigits() {
        return ndec.get();
    }

    public static void setDecimalNumber(int n) {
        ndec.set(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char getCsvSeparator() {
        AtomicInteger atomicInteger = ndec;
        synchronized (atomicInteger) {
            if (csvSeparator != null) {
                return csvSeparator.charValue();
            }
            DecimalFormat fmt = (DecimalFormat)NumberFormat.getNumberInstance();
            char sep = fmt.getDecimalFormatSymbols().getDecimalSeparator();
            if (sep == ',') {
                return ';';
            }
            return ',';
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCsvSeparator(Character c) {
        AtomicInteger atomicInteger = ndec;
        synchronized (atomicInteger) {
            csvSeparator = c;
        }
    }

    public static final List<String> allSeries(boolean compact, List<? extends IProcessingFactory> facs) {
        LinkedHashSet dic = new LinkedHashSet();
        for (IProcessingFactory iProcessingFactory : facs) {
            Map odic = iProcessingFactory.getOutputDictionary(compact);
            odic.forEach((s, c) -> {
                if (c == TsData.class && !dic.contains(s)) {
                    dic.add(s);
                }
            });
        }
        return dic.stream().collect(Collectors.toList());
    }

    public static final List<String> allSaSeries(boolean compact) {
        return BasicConfiguration.allSeries(compact, SaManager.instance.getProcessors());
    }

    public static final List<String> allDetails(boolean compact, List<? extends IProcessingFactory> facs, List<? extends IDiagnosticsFactory> diags) {
        LinkedHashSet dic = new LinkedHashSet();
        for (IProcessingFactory iProcessingFactory : facs) {
            Map odic = iProcessingFactory.getOutputDictionary(compact);
            odic.forEach((s, c) -> {
                if (c != TsData.class && MatrixFormatter.canProcess(c) && !dic.contains(s)) {
                    dic.add(s);
                }
            });
        }
        diags.stream().filter(d -> d.isEnabled()).forEach(z -> {
            String lz = z.getName().toLowerCase();
            z.getTestDictionary().forEach(t -> dic.add(InformationSet.concatenate((String[])new String[]{"diagnostics", lz, ((String)t).toLowerCase()})));
        });
        return dic.stream().collect(Collectors.toList());
    }

    public static final List<String> allSaDetails(boolean compact) {
        List<String> details = BasicConfiguration.allDetails(compact, SaManager.instance.getProcessors(), SaManager.instance.getDiagnostics());
        details.add(InformationSet.concatenate((String[])new String[]{"diagnostics", "quality"}));
        return details;
    }

    public static final List<String> allSingleSaDetails(boolean compact) {
        List<String> d = BasicConfiguration.allSaDetails(compact);
        ArrayList<String> dc = new ArrayList<String>();
        for (String cur : d) {
            int last = cur.lastIndexOf(":");
            if (last > 0) {
                dc.add(cur.substring(0, last));
                continue;
            }
            dc.add(cur);
        }
        return dc;
    }

    private static String fileFromId(Id id) {
        int n = id.getCount();
        if (n == 0) {
            return DEF_FILE;
        }
        if (n == 1) {
            return id.get(0);
        }
        String result = ec.tstoolkit.utilities.Paths.concatenate((String)id.get(0), (String)id.get(1));
        for (int i = 2; i < n; ++i) {
            result = ec.tstoolkit.utilities.Paths.concatenate((String)result, (String)id.get(i));
        }
        return result;
    }

    private static String fileFromId(String folder, Id id) {
        return ec.tstoolkit.utilities.Paths.concatenate((String)folder, (String)BasicConfiguration.fileFromId(id));
    }

    public static String fileFromContext(String folder, Object context) {
        if (context == null) {
            return BasicConfiguration.folder(folder);
        }
        if (context instanceof Id) {
            Id id = (Id)context;
            return BasicConfiguration.fileFromId(BasicConfiguration.folder(folder), (Id)context);
        }
        return ec.tstoolkit.utilities.Paths.concatenate((String)BasicConfiguration.folder(folder), (String)context.toString());
    }

    public static String folderFromContext(String folder, Object context) {
        File Folder;
        String nfolder = BasicConfiguration.folder(folder);
        if (context != null && context instanceof Id) {
            Id parent = (Id)context;
            for (int i = 0; i < parent.getCount(); ++i) {
                nfolder = ec.tstoolkit.utilities.Paths.concatenate((String)nfolder, (String)parent.get(i));
            }
        }
        if (!(Folder = Paths.get(nfolder, new String[0]).toFile()).exists()) {
            Folder.mkdirs();
        }
        return nfolder;
    }

    public static File folderFromContext(File folder, Object context) {
        File nfolder = BasicConfiguration.folder(folder);
        if (context != null && context instanceof Id) {
            Id parent = (Id)context;
            for (int i = 0; i < parent.getCount(); ++i) {
                nfolder = nfolder.toPath().resolve(parent.get(i)).toFile();
            }
        }
        if (!nfolder.exists()) {
            nfolder.mkdirs();
        }
        return nfolder;
    }

    public static String folder(String folder) {
        if (folder == null || folder.length() == 0) {
            return defaultFolder;
        }
        return folder;
    }

    public static File folder(File folder) {
        if (folder == null || !folder.isDirectory()) {
            return Paths.get(defaultFolder, new String[0]).toFile();
        }
        return folder;
    }
}

