/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.output;

import ec.satoolkit.ISaSpecification;
import ec.tss.Ts;
import ec.tss.formatters.CsvInformationFormatter;
import ec.tss.sa.documents.SaDocument;
import ec.tss.sa.output.BasicConfiguration;
import ec.tss.sa.output.CsvMatrixOutputConfiguration;
import ec.tstoolkit.algorithm.IOutput;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.utilities.NamedObject;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class CsvMatrixOutput
implements IOutput<SaDocument<ISaSpecification>> {
    CsvMatrixOutputConfiguration config_;
    List<NamedObject<IProcResults>> infos_;
    private File folder_;
    private boolean fullName;

    public CsvMatrixOutput(CsvMatrixOutputConfiguration config) {
        this.config_ = config.clone();
        this.fullName = this.config_.isFullName();
    }

    public String getName() {
        return "Csv matrix";
    }

    public boolean isAvailable() {
        return true;
    }

    public void start(Object context) {
        this.infos_ = new ArrayList<NamedObject<IProcResults>>();
        this.folder_ = BasicConfiguration.folderFromContext(this.config_.getFolder(), context);
    }

    public void end(Object context) throws Exception {
        CsvInformationFormatter fmt = new CsvInformationFormatter();
        fmt.setFullName(this.fullName);
        String file = ec.tstoolkit.utilities.Paths.concatenate((String)this.folder_.getAbsolutePath(), (String)this.config_.getFileName());
        file = ec.tstoolkit.utilities.Paths.changeExtension((String)file, (String)"csv");
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(file, new String[0]), StandardCharsets.ISO_8859_1, new OpenOption[0]);){
            fmt.formatResults(writer, this.infos_, this.config_.getItems(), true);
        }
        this.infos_ = null;
    }

    public void process(SaDocument<ISaSpecification> document) {
        this.infos_.add((NamedObject<IProcResults>)new NamedObject(((Ts)document.getInput()).getRawName(), document.getResults()));
    }
}

