/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.output;

import ec.satoolkit.ISaSpecification;
import ec.tss.formatters.StringFormatter;
import ec.tss.sa.documents.SaDocument;
import ec.tss.sa.output.BasicConfiguration;
import ec.tss.sa.output.CsvOutputConfiguration;
import ec.tss.sa.output.CsvOutputFactory;
import ec.tss.sa.output.DefaultCollectionSummary;
import ec.tss.sa.output.TsCollectionCsvFormatter;
import ec.tstoolkit.algorithm.IOutput;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.utilities.Jdk6;
import ec.tstoolkit.utilities.Paths;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvOutput
implements IOutput<SaDocument<ISaSpecification>> {
    public static final Logger LOGGER = LoggerFactory.getLogger(CsvOutputFactory.class);
    CsvOutputConfiguration config_;
    DefaultCollectionSummary summary_;
    private File folder_;

    public CsvOutput(CsvOutputConfiguration config) {
        this.config_ = config.clone();
    }

    public void process(SaDocument<ISaSpecification> document) {
        this.summary_.add((String[])Jdk6.Collections.toArray(this.config_.getSeries(), String.class), document);
    }

    public void start(Object context) {
        this.summary_ = new DefaultCollectionSummary();
        this.folder_ = BasicConfiguration.folderFromContext(this.config_.getFolder(), context);
    }

    public void end(Object context) throws Exception {
        for (String item : this.summary_.getItems()) {
            String nfile = this.config_.getFilePrefix();
            nfile = nfile + "_" + StringFormatter.cleanup(item.replace('.', '_'));
            nfile = Paths.changeExtension((String)nfile, (String)"csv");
            this.write(BasicConfiguration.folder(this.folder_).toPath().resolve(nfile), this.summary_.getNames(), this.summary_.getSeries(item));
        }
        this.summary_ = null;
    }

    public String getName() {
        return "csv";
    }

    public boolean isAvailable() {
        return true;
    }

    private void write(Path file, List<String> names, List<TsData> s) throws Exception {
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardCharsets.ISO_8859_1, new OpenOption[0]);){
            TsCollectionCsvFormatter fmt = new TsCollectionCsvFormatter();
            fmt.setFullName(this.config_.isFullName());
            fmt.setPresentation(this.config_.getPresentation());
            fmt.write(s, names, writer);
        }
    }
}

