/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.output;

import ec.satoolkit.IRegArimaSaResults;
import ec.tss.sa.documents.SaDocument;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.HashMap;
import java.util.Map;

public class CsvSummary {
    public final String Name;
    private TsDomain domain_;
    private TsDomain fdomain_;
    private final Map<String, TsData> series_ = new HashMap<String, TsData>();

    public CsvSummary(String[] items, String name, SaDocument<?> document) {
        TsData s = document.getTs().getTsData();
        this.Name = name;
        this.series_.put("y", s);
        this.domain_ = s.getDomain();
        this.fdomain_ = new TsDomain(this.domain_.getEnd(), this.domain_.getFrequency().intValue());
        this.fillDictionary(items, (IProcResults)document.getResults());
    }

    private void fillDictionary(String[] items, IProcResults results) {
        for (String item : items) {
            if (item.equalsIgnoreCase("y")) {
                this.series_.put("y", (TsData)results.getData("y", TsData.class));
                continue;
            }
            if (item.equalsIgnoreCase("yc")) {
                this.series_.put("yc", (TsData)results.getData("yc", TsData.class));
                continue;
            }
            if (item.equalsIgnoreCase("yl")) {
                this.series_.put("yl", (TsData)results.getData("y_cmp", TsData.class));
                continue;
            }
            if (item.equalsIgnoreCase("t")) {
                this.series_.put("t", (TsData)results.getData("t", TsData.class));
                continue;
            }
            if (item.equalsIgnoreCase("sa")) {
                this.series_.put("sa", (TsData)results.getData("sa", TsData.class));
                continue;
            }
            if (item.equalsIgnoreCase("s")) {
                this.series_.put("s", (TsData)results.getData("s", TsData.class));
                continue;
            }
            if (item.equalsIgnoreCase("i")) {
                this.series_.put("i", (TsData)results.getData("i", TsData.class));
                continue;
            }
            if (item.equalsIgnoreCase("tc")) {
                this.series_.put("tc", (TsData)results.getData("t_cmp", TsData.class));
                continue;
            }
            if (item.equalsIgnoreCase("sac")) {
                this.series_.put("sac", (TsData)results.getData("sa_cmp", TsData.class));
                continue;
            }
            if (item.equalsIgnoreCase("sc")) {
                this.series_.put("sc", (TsData)results.getData("s_cmp", TsData.class));
                continue;
            }
            if (item.equalsIgnoreCase("ic")) {
                this.series_.put("ic", (TsData)results.getData("i_cmp", TsData.class));
                continue;
            }
            if (item.equalsIgnoreCase("tl")) {
                this.series_.put("tc", (TsData)results.getData("t_lin", TsData.class));
                continue;
            }
            if (item.equalsIgnoreCase("sal")) {
                this.series_.put("sac", (TsData)results.getData("sa_lin", TsData.class));
                continue;
            }
            if (item.equalsIgnoreCase("sl")) {
                this.series_.put("sc", (TsData)results.getData("s_lin", TsData.class));
                continue;
            }
            if (item.equalsIgnoreCase("il")) {
                this.series_.put("ic", (TsData)results.getData("i_lin", TsData.class));
                continue;
            }
            if (item.equalsIgnoreCase("ycal")) {
                this.series_.put("ycal", (TsData)results.getData("ycal", TsData.class));
                continue;
            }
            TsDomain fullDomain = this.domain_.union(this.fdomain_);
            IRegArimaSaResults regmodel = (IRegArimaSaResults)results;
            if (regmodel == null || !item.equalsIgnoreCase("td")) continue;
            this.series_.put("td", regmodel.getPreprocessingPart().regressionEffect(fullDomain));
        }
    }

    public TsData getSeries(String name) {
        if (this.series_.containsKey(name)) {
            return this.series_.get(name);
        }
        return null;
    }
}

