/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.output;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.ISaSpecification;
import ec.tss.TsIdentifier;
import ec.tss.sa.documents.SaDocument;
import ec.tss.xml.sa.AbstractXmlSaSpecification;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.io.StringWriter;

public class SaSummary {
    public final TsData Orig;
    public final TsData T;
    public final TsData S;
    public final TsData I;
    public final TsData SA;
    public final TsData CAL;
    public final TsIdentifier Identifier;
    public final String Spec;
    public final DecompositionMode Mode;

    public SaSummary(SaDocument<ISaSpecification> doc) {
        this.Identifier = new TsIdentifier(doc.getTs());
        this.Orig = doc.getSeries();
        CompositeResults sadj = (CompositeResults)doc.getResults();
        if (sadj != null) {
            this.T = (TsData)sadj.getData("t", TsData.class);
            this.S = (TsData)sadj.getData("s", TsData.class);
            this.SA = (TsData)sadj.getData("sa", TsData.class);
            this.I = (TsData)sadj.getData("i", TsData.class);
            this.CAL = (TsData)sadj.getData("cal", TsData.class);
            this.Mode = doc.getFinalDecomposition().getMode();
        } else {
            this.T = null;
            this.S = null;
            this.SA = null;
            this.I = null;
            this.CAL = null;
            this.Mode = DecompositionMode.Undefined;
        }
        String xml = null;
        AbstractXmlSaSpecification xspec = AbstractXmlSaSpecification.create((ISaSpecification)doc.getSpecification());
        if (xspec != null) {
            try {
                StringWriter writer = new StringWriter();
                xspec.serialize(writer);
                xml = writer.toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.Spec = xml == null ? "" : xml;
    }
}

