/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.output;

import ec.tss.sa.documents.SaDocument;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class SeriesSummary {
    public final String Name;
    private final Map<String, TsData> series_ = new LinkedHashMap<String, TsData>();

    public SeriesSummary(String[] items, String name, SaDocument<?> document) {
        this.Name = name;
        this.fillDictionary(items, (IProcResults)document.getResults());
    }

    private void fillDictionary(String[] items, IProcResults results) {
        for (String item : items) {
            item = item.toLowerCase();
            if (results != null) {
                if (InformationSet.hasWildCards((String)item)) {
                    Map all = results.searchAll(item, TsData.class);
                    all.keySet().forEach(s -> this.series_.put((String)s, (TsData)results.getData(s, TsData.class)));
                    continue;
                }
                this.series_.put(item, (TsData)results.getData(item, TsData.class));
                continue;
            }
            this.series_.put(item, null);
        }
    }

    public TsData getSeries(String name) {
        if (this.series_.containsKey(name)) {
            return this.series_.get(name);
        }
        return null;
    }

    void fill(Set<String> set) {
        set.addAll(this.series_.keySet());
    }
}

