/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.output;

import ec.tss.sa.output.BasicConfiguration;
import ec.tss.sa.output.CsvLayout;
import ec.tss.tsproviders.utils.MultiLineNameUtil;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDataTable;
import ec.tstoolkit.timeseries.simplets.TsDataTableInfo;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.io.IOException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;

public class TsCollectionCsvFormatter {
    private CsvLayout layout_ = CsvLayout.VTable;
    private final char comma;
    private static final String newLine = System.lineSeparator();
    private final DecimalFormat fmt;
    private final NumberFormat ifmt = NumberFormat.getIntegerInstance();
    private boolean fullName;

    public TsCollectionCsvFormatter() {
        this.ifmt.setGroupingUsed(false);
        this.comma = BasicConfiguration.getCsvSeparator();
        this.fmt = (DecimalFormat)DecimalFormat.getNumberInstance();
        this.fmt.setMaximumFractionDigits(BasicConfiguration.getFractionDigits());
        this.fmt.setGroupingUsed(false);
    }

    public CsvLayout getPresentation() {
        return this.layout_;
    }

    public void setPresentation(CsvLayout layout) {
        this.layout_ = layout;
    }

    public void setFullName(boolean fullName) {
        this.fullName = fullName;
    }

    public boolean write(List<TsData> coll, List<String> names, Writer writer) throws IOException {
        if (coll.isEmpty() || names.size() != coll.size()) {
            return false;
        }
        if (this.layout_ == CsvLayout.List) {
            return this.writeList(coll, names, writer);
        }
        TsDataTable table = new TsDataTable();
        for (TsData s : coll) {
            table.insert(-1, s);
        }
        if (table.isEmpty()) {
            return false;
        }
        TsDomain domain = table.getDomain();
        int ndata = domain.getLength();
        int nseries = table.getSeriesCount();
        if (this.layout_ == CsvLayout.VTable) {
            writer.write(this.comma);
            for (int i = 0; i < nseries; ++i) {
                this.write(names.get(i), writer);
                if (i != nseries - 1) {
                    writer.write(this.comma);
                    continue;
                }
                writer.write(newLine);
            }
            for (int j = 0; j < ndata; ++j) {
                writer.write(domain.get(j).lastday().toString());
                for (int i = 0; i < nseries; ++i) {
                    writer.write(this.comma);
                    if (table.getDataInfo(j, i) != TsDataTableInfo.Valid) continue;
                    this.write(this.fmt.format(table.getData(j, i)), writer);
                }
                writer.write(newLine);
            }
        } else {
            writer.write(this.comma);
            for (int i = 0; i < ndata; ++i) {
                writer.write(domain.get(i).lastday().toString());
                if (i != ndata - 1) {
                    writer.write(this.comma);
                    continue;
                }
                writer.write(newLine);
            }
            for (int j = 0; j < nseries; ++j) {
                this.write(names.get(j), writer);
                for (int i = 0; i < ndata; ++i) {
                    writer.write(this.comma);
                    if (table.getDataInfo(i, j) != TsDataTableInfo.Valid) continue;
                    this.write(this.fmt.format(table.getData(i, j)), writer);
                }
                writer.write(newLine);
            }
        }
        return true;
    }

    private boolean writeList(List<TsData> coll, List<String> names, Writer writer) throws IOException {
        int nseries = names.size();
        for (int j = 0; j < nseries; ++j) {
            this.write(names.get(j), writer);
            writer.write(this.comma);
            TsData cur = coll.get(j);
            if (cur != null) {
                TsPeriod start = cur.getStart();
                writer.write(this.ifmt.format(start.getFrequency().intValue()));
                writer.write(this.comma);
                writer.write(this.ifmt.format(start.getYear()));
                writer.write(this.comma);
                writer.write(this.ifmt.format(start.getPosition() + 1));
                writer.write(this.comma);
                writer.write(this.ifmt.format(cur.getLength()));
                for (int i = 0; i < cur.getLength(); ++i) {
                    writer.write(this.comma);
                    double val = cur.get(i);
                    if (Double.isNaN(val)) continue;
                    this.write(this.fmt.format(val), writer);
                }
            }
            writer.write(newLine);
        }
        return true;
    }

    private void write(String txt, Writer writer) throws IOException {
        if (txt == null) {
            return;
        }
        txt = this.fullName ? MultiLineNameUtil.join(txt, " * ") : MultiLineNameUtil.last(txt);
        if (txt.indexOf(this.comma) >= 0) {
            if (txt.indexOf(34) >= 0) {
                writer.write("\"\"");
                writer.write(txt);
                writer.write("\"\"");
            } else {
                writer.write(34);
                writer.write(txt);
                writer.write(34);
            }
        } else if (txt.indexOf(34) >= 0) {
            writer.write("\"\"");
            writer.write(txt);
            writer.write("\"\"");
        } else {
            writer.write(txt);
        }
    }
}

