/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.output;

import ec.satoolkit.ISaSpecification;
import ec.tss.Ts;
import ec.tss.sa.documents.SaDocument;
import ec.tss.sa.output.BasicConfiguration;
import ec.tss.sa.output.TxtOutputConfiguration;
import ec.tss.sa.output.TxtOutputFactory;
import ec.tss.tsproviders.utils.MultiLineNameUtil;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IOutput;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.utilities.Paths;
import java.io.BufferedWriter;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TxtOutput
extends BasicConfiguration
implements IOutput<SaDocument<ISaSpecification>> {
    public static final Logger LOGGER = LoggerFactory.getLogger(TxtOutputFactory.class);
    private int id_;
    private TxtOutputConfiguration config_;
    private File folder;

    public TxtOutput(TxtOutputConfiguration config) {
        this.config_ = config.clone();
    }

    public void process(SaDocument<ISaSpecification> document) throws Exception {
        if (document.getResults() == null) {
            return;
        }
        String name = "s" + Integer.toString(++this.id_);
        for (String item : this.config_.getSeries()) {
            TsData s = (TsData)((CompositeResults)document.getResults()).getData(item, TsData.class);
            if (s == null) continue;
            TxtOutput.write(this.folder, name + '_' + item, ((Ts)document.getInput()).getName(), s, this.config_.isFullName());
        }
    }

    public void start(Object context) {
        this.id_ = 0;
        this.folder = BasicConfiguration.folderFromContext(this.config_.getFolder(), context);
    }

    public void end(Object file) {
    }

    public String getName() {
        return "txt";
    }

    public boolean isAvailable() {
        return true;
    }

    public static void write(File folder, String name, String sname, TsData s, boolean fullName) throws Exception {
        if (s == null) {
            return;
        }
        sname = fullName ? MultiLineNameUtil.join(sname, " * ") : MultiLineNameUtil.last(sname);
        Path file = folder.toPath().resolve(Paths.changeExtension((String)name, (String)"dta"));
        try (BufferedWriter w = Files.newBufferedWriter(file, StandardCharsets.ISO_8859_1, new OpenOption[0]);){
            w.write(sname);
            w.write(System.lineSeparator());
            w.write(Integer.toString(s.getLength()));
            w.write(" ");
            w.write(Integer.toString(s.getStart().getYear()));
            w.write(" ");
            w.write(Integer.toString(s.getStart().getPosition() + 1));
            w.write(" ");
            w.write(Integer.toString(s.getFrequency().intValue()));
            for (int i = 0; i < s.getLength(); ++i) {
                w.write(System.lineSeparator());
                double value = s.get(i);
                w.write(Double.toString(Double.isNaN(value) ? -99999.0 : value));
            }
        }
    }
}

