/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.processors;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.DefaultSeriesDecomposition;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.IProcessingNode;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.algorithm.SequentialProcessing;
import ec.tstoolkit.arima.special.mixedfrequencies.EstimateSpec;
import ec.tstoolkit.arima.special.mixedfrequencies.MixedFrequenciesModelDecomposition;
import ec.tstoolkit.arima.special.mixedfrequencies.MixedFrequenciesModelEstimation;
import ec.tstoolkit.arima.special.mixedfrequencies.MixedFrequenciesMonitor;
import ec.tstoolkit.arima.special.mixedfrequencies.MixedFrequenciesSpecification;
import ec.tstoolkit.modelling.ComponentInformation;
import ec.tstoolkit.modelling.ComponentType;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

@Deprecated
public class MixedFrequenciesArimaProcessor
implements IProcessingFactory<MixedFrequenciesSpecification, TsData[], CompositeResults> {
    public static final String FAMILY = "Seasonal adjustment";
    public static final AlgorithmDescriptor DESCRIPTOR = new AlgorithmDescriptor("Seasonal adjustment", "Mixed frequencies Arima model", null);
    public static final String PROCESSING = "processing";
    public static final String DECOMPOSITION = "decomposition";
    public static final String FINAL = "final";
    public static final String BENCHMARKING = "benchmarking";
    public static final MixedFrequenciesArimaProcessor instance = new MixedFrequenciesArimaProcessor();

    public void dispose() {
    }

    public AlgorithmDescriptor getInformation() {
        return DESCRIPTOR;
    }

    public boolean canHandle(IProcSpecification spec) {
        return spec instanceof MixedFrequenciesSpecification;
    }

    public IProcessing<TsData[], CompositeResults> generateProcessing(MixedFrequenciesSpecification specification, ProcessingContext context) {
        return new DefaultProcessing(specification);
    }

    public Map<String, Class> getSpecificationDictionary(Class<MixedFrequenciesSpecification> specClass) {
        HashMap<String, Class> dic = new HashMap<String, Class>();
        MixedFrequenciesSpecification.fillDictionary(null, dic);
        return dic;
    }

    public Map<String, Class> getOutputDictionary(boolean compact) {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        return dic;
    }

    public static class DefaultProcessing
    implements IProcessing<TsData[], CompositeResults> {
        private final MixedFrequenciesSpecification spec;

        public DefaultProcessing(MixedFrequenciesSpecification spec) {
            this.spec = spec.clone();
        }

        public CompositeResults process(TsData[] input) {
            SequentialProcessing processing = new SequentialProcessing();
            processing.add(DefaultProcessing.createModellingStep(this.spec));
            processing.add(DefaultProcessing.createDecompositionStep(this.spec));
            processing.add(DefaultProcessing.createFinalStep());
            return processing.process((Object)input);
        }

        protected static <S extends IProcSpecification> IProcessingNode<TsData[]> createModellingStep(final MixedFrequenciesSpecification spec) {
            return new IProcessingNode<TsData[]>(){

                public String getName() {
                    return MixedFrequenciesArimaProcessor.PROCESSING;
                }

                public String getPrefix() {
                    return null;
                }

                public IProcessing.Status process(TsData[] ts, Map<String, IProcResults> results) {
                    if (ts.length != 2) {
                        return IProcessing.Status.Invalid;
                    }
                    MixedFrequenciesMonitor monitor = new MixedFrequenciesMonitor();
                    if (!monitor.process(ts[0], ts[1], spec)) {
                        return IProcessing.Status.Invalid;
                    }
                    MixedFrequenciesModelEstimation rslt = new MixedFrequenciesModelEstimation(monitor, spec.getBasic().getDataType(), spec.getBasic().isLog());
                    if (spec.getBasic().isLog() && spec.getEstimate().getMethod() == EstimateSpec.Method.KalmanFilter) {
                        int l = monitor.getLowFreqData().getLength();
                        rslt.setLogTransformation((double)l * Math.log(monitor.getFrequenciesRatio()));
                    }
                    results.put(MixedFrequenciesArimaProcessor.PROCESSING, (IProcResults)rslt);
                    return IProcessing.Status.Valid;
                }
            };
        }

        protected static <S extends IProcSpecification> IProcessingNode<TsData[]> createDecompositionStep(final MixedFrequenciesSpecification spec) {
            return new IProcessingNode<TsData[]>(){

                public String getName() {
                    return MixedFrequenciesArimaProcessor.DECOMPOSITION;
                }

                public String getPrefix() {
                    return null;
                }

                public IProcessing.Status process(TsData[] ts, Map<String, IProcResults> results) {
                    TsData l;
                    if (ts.length != 2) {
                        return IProcessing.Status.Invalid;
                    }
                    IProcResults proc = results.get(MixedFrequenciesArimaProcessor.PROCESSING);
                    if (proc == null || !(proc instanceof MixedFrequenciesModelEstimation)) {
                        return IProcessing.Status.Unprocessed;
                    }
                    MixedFrequenciesModelEstimation model = (MixedFrequenciesModelEstimation)proc;
                    boolean log = spec.getBasic().isLog();
                    MixedFrequenciesModelDecomposition decomposition = new MixedFrequenciesModelDecomposition();
                    TsData h = model.getHighFreqLinearizedSeries();
                    if (decomposition.decompose(h, l = model.getLowFreqLinearizedSeries(), model.getArima(), spec.getArima().isMean(), spec.getBasic().getDataType(), log)) {
                        results.put(MixedFrequenciesArimaProcessor.DECOMPOSITION, (IProcResults)decomposition);
                        return IProcessing.Status.Valid;
                    }
                    return IProcessing.Status.Invalid;
                }
            };
        }

        protected static IProcessingNode<TsData[]> createFinalStep() {
            return new IProcessingNode<TsData[]>(){

                public String getName() {
                    return MixedFrequenciesArimaProcessor.FINAL;
                }

                public String getPrefix() {
                    return null;
                }

                public IProcessing.Status process(TsData[] ts, Map<String, IProcResults> results) {
                    IProcResults proc0 = results.get(MixedFrequenciesArimaProcessor.PROCESSING);
                    if (proc0 == null || !(proc0 instanceof MixedFrequenciesModelEstimation)) {
                        return IProcessing.Status.Unprocessed;
                    }
                    MixedFrequenciesModelEstimation model = (MixedFrequenciesModelEstimation)proc0;
                    IProcResults proc1 = results.get(MixedFrequenciesArimaProcessor.DECOMPOSITION);
                    if (proc1 == null || !(proc1 instanceof MixedFrequenciesModelDecomposition)) {
                        return IProcessing.Status.Unprocessed;
                    }
                    MixedFrequenciesModelDecomposition decomp = (MixedFrequenciesModelDecomposition)proc1;
                    DefaultSeriesDecomposition finals = new DefaultSeriesDecomposition(decomp.isMultiplicative() ? DecompositionMode.Multiplicative : DecompositionMode.Additive);
                    finals.add(model.getInterpolatedSeries(false), ComponentType.Series);
                    finals.add(model.getInterpolationErrors(false), ComponentType.Series, ComponentInformation.Stdev);
                    boolean mul = decomp.isMultiplicative();
                    TsData y = decomp.getSeries(ComponentType.Series, ComponentInformation.Value);
                    TsDomain cdomain = y.getDomain();
                    TsData fy = decomp.getSeries(ComponentType.Series, ComponentInformation.Forecast);
                    TsDomain fdomain = fy.getDomain();
                    TsData detT = model.regressionEffect(cdomain, ComponentType.Series);
                    TsData detS = model.regressionEffect(cdomain, ComponentType.Seasonal);
                    TsData detC = model.regressionEffect(cdomain, ComponentType.CalendarEffect);
                    detS = TsData.add((TsData)detS, (TsData)detC);
                    TsData detI = model.regressionEffect(cdomain, ComponentType.Irregular);
                    TsData detY = model.regressionEffect(cdomain);
                    TsData fdetT = model.regressionEffect(fdomain, ComponentType.Series);
                    TsData fdetS = model.regressionEffect(fdomain, ComponentType.Seasonal);
                    TsData fdetC = model.regressionEffect(fdomain, ComponentType.CalendarEffect);
                    fdetS = TsData.add((TsData)fdetS, (TsData)fdetC);
                    TsData fdetI = model.regressionEffect(fdomain, ComponentType.Irregular);
                    TsData fdetY = model.regressionEffect(fdomain);
                    if (mul) {
                        if (detT != null) {
                            detT = detT.exp();
                            fdetT = fdetT.exp();
                        }
                        if (detS != null) {
                            detS = detS.exp();
                            fdetS = fdetS.exp();
                        }
                        if (detI != null) {
                            detI = detI.exp();
                            fdetI = fdetI.exp();
                        }
                        if (detY != null) {
                            detY = detY.exp();
                            fdetY = fdetY.exp();
                        }
                    }
                    finals.add(DefaultProcessing.op(mul, y, detY), ComponentType.Series);
                    TsData t = DefaultProcessing.op(mul, detT, decomp.getSeries(ComponentType.Trend, ComponentInformation.Value));
                    finals.add(t, ComponentType.Trend);
                    TsData s = DefaultProcessing.op(mul, detS, decomp.getSeries(ComponentType.Seasonal, ComponentInformation.Value));
                    finals.add(s, ComponentType.Seasonal);
                    TsData i = DefaultProcessing.op(mul, detI, decomp.getSeries(ComponentType.Irregular, ComponentInformation.Value));
                    finals.add(i, ComponentType.Irregular);
                    finals.add(DefaultProcessing.op(mul, t, i), ComponentType.SeasonallyAdjusted);
                    finals.add(DefaultProcessing.op(mul, fy, fdetY), ComponentType.Series, ComponentInformation.Forecast);
                    TsData ft = DefaultProcessing.op(mul, fdetT, decomp.getSeries(ComponentType.Trend, ComponentInformation.Forecast));
                    finals.add(ft, ComponentType.Trend, ComponentInformation.Forecast);
                    TsData fs = DefaultProcessing.op(mul, fdetS, decomp.getSeries(ComponentType.Seasonal, ComponentInformation.Forecast));
                    finals.add(fs, ComponentType.Seasonal, ComponentInformation.Forecast);
                    TsData fi = DefaultProcessing.op(mul, fdetI, decomp.getSeries(ComponentType.Irregular, ComponentInformation.Forecast));
                    finals.add(fi, ComponentType.Irregular, ComponentInformation.Forecast);
                    finals.add(DefaultProcessing.op(mul, ft, fi), ComponentType.SeasonallyAdjusted, ComponentInformation.Forecast);
                    results.put(MixedFrequenciesArimaProcessor.FINAL, (IProcResults)finals);
                    return IProcessing.Status.Valid;
                }
            };
        }

        private static TsData op(boolean mul, TsData l, TsData r) {
            if (mul) {
                return TsData.multiply((TsData)l, (TsData)r);
            }
            return TsData.add((TsData)l, (TsData)r);
        }

        private static TsData inv_op(boolean mul, TsData l, TsData r) {
            if (mul) {
                return TsData.divide((TsData)l, (TsData)r);
            }
            return TsData.subtract((TsData)l, (TsData)r);
        }
    }
}

