/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.processors;

import ec.satoolkit.GenericSaResults;
import ec.satoolkit.ISaSpecification;
import ec.satoolkit.algorithm.implementation.TramoSeatsProcessingFactory;
import ec.satoolkit.tramoseats.TramoSeatsSpecification;
import ec.tss.sa.EstimationPolicyType;
import ec.tss.sa.ISaProcessingFactory;
import ec.tss.sa.SaItem;
import ec.tss.sa.documents.SaDocument;
import ec.tss.sa.documents.TramoSeatsDocument;
import ec.tstoolkit.ParameterType;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.tramo.ArimaSpec;
import ec.tstoolkit.modelling.arima.tramo.CalendarSpec;
import ec.tstoolkit.modelling.arima.tramo.EasterSpec;
import ec.tstoolkit.modelling.arima.tramo.OutlierSpec;
import ec.tstoolkit.modelling.arima.tramo.RegressionSpec;
import ec.tstoolkit.modelling.arima.tramo.TradingDaysSpec;
import ec.tstoolkit.modelling.arima.tramo.TramoSpecification;
import ec.tstoolkit.modelling.arima.tramo.TransformSpec;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.IEasterVariable;
import ec.tstoolkit.timeseries.regression.ILengthOfPeriodVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.ITradingDaysVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.InterventionVariable;
import ec.tstoolkit.timeseries.regression.OutlierDefinition;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.regression.Sequence;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class TramoSeatsProcessor
implements ISaProcessingFactory<TramoSeatsSpecification> {
    public static final AlgorithmDescriptor DESCRIPTOR = TramoSeatsProcessingFactory.DESCRIPTOR;

    @Override
    public ISaSpecification createSpecification(InformationSet info) {
        TramoSeatsSpecification spec = new TramoSeatsSpecification();
        if (spec.read(info)) {
            return spec;
        }
        return null;
    }

    @Override
    public ISaSpecification createSpecification(SaItem doc, TsDomain frozen, EstimationPolicyType policy, boolean nospan) {
        TsData cur;
        TramoSeatsSpecification spec = (TramoSeatsSpecification)doc.getPointSpecification();
        TramoSeatsSpecification defspec = (TramoSeatsSpecification)doc.getDomainSpecification();
        if (policy == EstimationPolicyType.Complete || spec == null) {
            TramoSeatsSpecification nspec = defspec.clone();
            if (nospan) {
                nspec.getTramoSpecification().getTransform().getSpan().all();
            }
            return nspec;
        }
        TramoSeatsSpecification newspec = spec.clone();
        TramoSpecification ntspec = newspec.getTramoSpecification();
        TramoSpecification dtspec = defspec.getTramoSpecification();
        if (nospan) {
            ntspec.getTransform().getSpan().all();
        }
        this.refreshArimaSpec(ntspec, dtspec, policy);
        this.refreshOutliersSpec(ntspec, dtspec, frozen, policy);
        RegressionSpec nrspec = ntspec.getRegression();
        switch (policy) {
            case Fixed: 
            case Current: {
                Map all = nrspec.getAllCoefficients();
                all.forEach((n, c) -> {
                    if (!n.startsWith("AO:")) {
                        nrspec.setFixedCoefficients(n, c);
                    }
                });
                break;
            }
            default: {
                nrspec.clearAllFixedCoefficients();
                Map all = dtspec.getRegression().getAllFixedCoefficients();
                all.forEach((n, c) -> nrspec.setFixedCoefficients(n, c));
                break;
            }
        }
        if (policy == EstimationPolicyType.Current && (cur = doc.getTsData()) != null && frozen != null) {
            TsDomain ndomain = cur.getDomain();
            TsPeriod end = ndomain.getEnd();
            int ndata = frozen.getEnd().minus(end);
            for (int i = 0; i < ndata; ++i) {
                Day day = end.firstday();
                Sequence seq = new Sequence(day, day);
                InterventionVariable var = new InterventionVariable();
                var.setDescription("AO:" + end.toString());
                var.setSequences(new Sequence[]{seq});
                nrspec.add(var);
                end.move(1);
            }
        }
        nrspec.clearAllCoefficients();
        return newspec;
    }

    private void refreshArimaSpec(TramoSpecification spec, TramoSpecification defspec, EstimationPolicyType policy) {
        ArimaSpec arima = spec.getArima();
        ArimaSpec defarima = defspec.isUsingAutoModel() ? null : defspec.getArima();
        switch (policy) {
            case Fixed: 
            case Current: {
                if (arima.isMean()) {
                    arima.fixMu();
                }
            }
            case FixedParameters: {
                arima.setParameterType(ParameterType.Fixed);
                break;
            }
            case FreeParameters: 
            case LastOutliers: 
            case Outliers: {
                if (defarima != null) {
                    spec.setArima(defarima.clone());
                    break;
                }
                arima.clearParameters();
                break;
            }
            case Outliers_StochasticComponent: {
                if (defarima != null) {
                    spec.setArima(defarima.clone());
                    break;
                }
                spec.setAutoModel(defspec.getAutoModel());
            }
        }
    }

    private void refreshOutliersSpec(TramoSpecification spec, TramoSpecification defspec, TsDomain frozen, EstimationPolicyType policy) {
        RegressionSpec rspec = spec.getRegression();
        RegressionSpec defrspec = defspec.getRegression();
        OutlierSpec defospec = defspec.getOutliers();
        switch (policy) {
            case Fixed: 
            case Current: 
            case FixedParameters: 
            case FreeParameters: {
                break;
            }
            case LastOutliers: {
                OutlierDefinition[] o = rspec.getOutliers();
                rspec.setOutliers(defrspec.getOutliers());
                if (frozen != null && o != null) {
                    for (int j = 0; j < o.length; ++j) {
                        OutlierDefinition cur = o[j];
                        if (frozen.search(cur.getPosition()) < 0 || defrspec.contains(cur)) continue;
                        rspec.add(cur);
                    }
                }
                OutlierSpec no = defospec.clone();
                if (frozen != null) {
                    no.getSpan().from(frozen.getEnd().firstday());
                }
                spec.setOutliers(no);
                break;
            }
            case Outliers: 
            case Outliers_StochasticComponent: {
                spec.setOutliers(defospec.clone());
                rspec.setOutliers(defrspec.getOutliers());
            }
        }
    }

    @Override
    public boolean updatePointSpecification(SaItem item) {
        OutlierSpec ospec;
        if (item.getStatus() != SaItem.Status.Valid) {
            return false;
        }
        TramoSeatsSpecification spec = (TramoSeatsSpecification)item.getEstimationSpecification().clone();
        CompositeResults rslts = item.process();
        PreprocessingModel regarima = GenericSaResults.getPreprocessingModel((CompositeResults)rslts);
        TramoSpecification tspec = spec.getTramoSpecification();
        if (regarima == null) {
            return false;
        }
        TransformSpec transform = tspec.getTransform();
        if (regarima.isMultiplicative()) {
            transform.setFunction(DefaultTransformationType.Log);
        } else {
            transform.setFunction(DefaultTransformationType.None);
        }
        RegressionSpec rspec = tspec.getRegression();
        CalendarSpec cspec = rspec.getCalendar();
        TradingDaysSpec tdspec = cspec.getTradingDays();
        EasterSpec espec = cspec.getEaster();
        TsVariableList vars = regarima.description.buildRegressionVariables();
        if (tdspec.isUsed() && (tdspec.isTest() || tdspec.isAutomatic())) {
            boolean used = false;
            if (vars.select(ILengthOfPeriodVariable.class).isEmpty()) {
                tdspec.setLeapYear(false);
            } else {
                used = true;
            }
            if (vars.select(ITradingDaysVariable.class).isEmpty()) {
                tdspec.setTradingDaysType(TradingDaysType.None);
            } else {
                used = true;
            }
            if (used) {
                if (tdspec.isAutomatic()) {
                    tdspec.setAutomatic(false);
                    int ntd = vars.select(ITradingDaysVariable.class).getVariablesCount();
                    if (ntd >= 6) {
                        tdspec.setTradingDaysType(TradingDaysType.TradingDays);
                    } else {
                        tdspec.setTradingDaysType(TradingDaysType.WorkingDays);
                    }
                }
                tdspec.setTest(false);
            } else {
                tdspec.disable();
            }
        }
        if (espec.isUsed() && espec.isTest()) {
            if (vars.select(IEasterVariable.class).isEmpty()) {
                espec.setOption(EasterSpec.Type.Unused);
            } else {
                espec.setTest(false);
            }
        }
        if ((ospec = tspec.getOutliers()).isUsed()) {
            TsVariableSelection sel = vars.select(OutlierType.Undefined);
            if (!sel.isEmpty()) {
                for (TsVariableSelection.Item o : sel.elements()) {
                    if (regarima.description.isPrespecified((IOutlierVariable)o.variable)) continue;
                    rspec.add((IOutlierVariable)o.variable);
                }
            }
            ospec.clearTypes();
        }
        tspec.getArima().setArimaComponent(regarima.description.getArimaComponent());
        tspec.setUsingAutoModel(false);
        rspec.clearAllCoefficients();
        double[] b = regarima.estimation.getLikelihood().getB();
        if (b != null) {
            int pos = regarima.description.getRegressionVariablesStartingPosition();
            for (ITsVariable var : vars.items()) {
                int npos = pos + var.getDim();
                rspec.setCoefficients(ITsVariable.shortName((String)var.getName()), Arrays.copyOfRange(b, pos, npos));
                pos = npos;
            }
        }
        item.setPointSpecification((ISaSpecification)spec);
        return true;
    }

    @Override
    public SaDocument<?> createDocument() {
        return new TramoSeatsDocument();
    }

    @Override
    public List<ISaSpecification> defaultSpecifications() {
        ArrayList<ISaSpecification> specs = new ArrayList<ISaSpecification>();
        specs.add((ISaSpecification)TramoSeatsSpecification.RSA0);
        specs.add((ISaSpecification)TramoSeatsSpecification.RSA1);
        specs.add((ISaSpecification)TramoSeatsSpecification.RSA2);
        specs.add((ISaSpecification)TramoSeatsSpecification.RSA3);
        specs.add((ISaSpecification)TramoSeatsSpecification.RSA4);
        specs.add((ISaSpecification)TramoSeatsSpecification.RSA5);
        specs.add((ISaSpecification)TramoSeatsSpecification.RSAfull);
        return specs;
    }

    public void dispose() {
    }

    public AlgorithmDescriptor getInformation() {
        return TramoSeatsProcessingFactory.instance.getInformation();
    }

    public boolean canHandle(IProcSpecification spec) {
        return TramoSeatsProcessingFactory.instance.canHandle(spec);
    }

    public IProcessing<TsData, CompositeResults> generateProcessing(TramoSeatsSpecification specification, ProcessingContext context) {
        return TramoSeatsProcessingFactory.instance.generateProcessing(specification, context);
    }

    public Map<String, Class> getSpecificationDictionary(Class<TramoSeatsSpecification> specClass) {
        return TramoSeatsProcessingFactory.instance.getSpecificationDictionary(specClass);
    }

    public Map<String, Class> getOutputDictionary(boolean compact) {
        return TramoSeatsProcessingFactory.instance.getOutputDictionary(compact);
    }
}

