/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.processors;

import ec.satoolkit.DecompositionMode;
import ec.satoolkit.GenericSaResults;
import ec.satoolkit.ISaSpecification;
import ec.satoolkit.algorithm.implementation.X13ProcessingFactory;
import ec.satoolkit.x11.X11Specification;
import ec.satoolkit.x13.X13Specification;
import ec.tss.sa.EstimationPolicyType;
import ec.tss.sa.ISaProcessingFactory;
import ec.tss.sa.SaItem;
import ec.tss.sa.documents.SaDocument;
import ec.tss.sa.documents.X13Document;
import ec.tstoolkit.ParameterType;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.modelling.DefaultTransformationType;
import ec.tstoolkit.modelling.RegressionTestSpec;
import ec.tstoolkit.modelling.arima.PreprocessingModel;
import ec.tstoolkit.modelling.arima.x13.ArimaSpec;
import ec.tstoolkit.modelling.arima.x13.MovingHolidaySpec;
import ec.tstoolkit.modelling.arima.x13.OutlierSpec;
import ec.tstoolkit.modelling.arima.x13.RegArimaSpecification;
import ec.tstoolkit.modelling.arima.x13.RegressionSpec;
import ec.tstoolkit.modelling.arima.x13.TradingDaysSpec;
import ec.tstoolkit.modelling.arima.x13.TransformSpec;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.calendars.LengthOfPeriodType;
import ec.tstoolkit.timeseries.calendars.TradingDaysType;
import ec.tstoolkit.timeseries.regression.EasterVariable;
import ec.tstoolkit.timeseries.regression.ILengthOfPeriodVariable;
import ec.tstoolkit.timeseries.regression.IOutlierVariable;
import ec.tstoolkit.timeseries.regression.ITradingDaysVariable;
import ec.tstoolkit.timeseries.regression.ITsVariable;
import ec.tstoolkit.timeseries.regression.InterventionVariable;
import ec.tstoolkit.timeseries.regression.JulianEasterVariable;
import ec.tstoolkit.timeseries.regression.OutlierDefinition;
import ec.tstoolkit.timeseries.regression.OutlierType;
import ec.tstoolkit.timeseries.regression.Sequence;
import ec.tstoolkit.timeseries.regression.TsVariableList;
import ec.tstoolkit.timeseries.regression.TsVariableSelection;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class X13Processor
implements ISaProcessingFactory<X13Specification> {
    public static final AlgorithmDescriptor DESCRIPTOR = X13ProcessingFactory.DESCRIPTOR;

    @Override
    public ISaSpecification createSpecification(InformationSet info) {
        X13Specification spec = new X13Specification();
        if (spec.read(info)) {
            return spec;
        }
        return null;
    }

    @Override
    public ISaSpecification createSpecification(SaItem doc, TsDomain frozen, EstimationPolicyType policy, boolean nospan) {
        TsData cur;
        X13Specification spec = (X13Specification)doc.getPointSpecification();
        X13Specification defspec = (X13Specification)doc.getDomainSpecification();
        if (policy == EstimationPolicyType.Complete || spec == null) {
            X13Specification nspec = defspec.clone();
            if (nospan) {
                nspec.getRegArimaSpecification().getBasic().getSpan().all();
            }
            return nspec;
        }
        X13Specification newspec = spec.clone();
        RegArimaSpecification ntspec = newspec.getRegArimaSpecification();
        RegArimaSpecification dtspec = defspec.getRegArimaSpecification();
        if (nospan) {
            ntspec.getBasic().getSpan().all();
        }
        this.refreshArimaSpec(ntspec, dtspec, policy);
        this.refreshOutliersSpec(ntspec, dtspec, frozen, policy);
        RegressionSpec nrspec = ntspec.getRegression();
        switch (policy) {
            case Fixed: 
            case Current: {
                Map all = nrspec.getAllCoefficients();
                all.forEach((n, c) -> {
                    if (!n.startsWith("AO:")) {
                        nrspec.setFixedCoefficients(n, c);
                    }
                });
                break;
            }
            default: {
                nrspec.clearAllFixedCoefficients();
                Map all = dtspec.getRegression().getAllFixedCoefficients();
                all.forEach((n, c) -> nrspec.setFixedCoefficients(n, c));
                break;
            }
        }
        if (policy == EstimationPolicyType.Current && (cur = doc.getTsData()) != null && frozen != null) {
            TsDomain ndomain = cur.getDomain();
            TsPeriod end = ndomain.getEnd();
            int ndata = frozen.getEnd().minus(end);
            for (int i = 0; i < ndata; ++i) {
                Day day = end.firstday();
                Sequence seq = new Sequence(day, day);
                InterventionVariable var = new InterventionVariable();
                var.setDescription("AO:" + end.toString());
                var.setSequences(new Sequence[]{seq});
                nrspec.add(var);
                end.move(1);
            }
        }
        nrspec.clearAllCoefficients();
        return newspec;
    }

    @Override
    public boolean updatePointSpecification(SaItem item) {
        if (item.getStatus() != SaItem.Status.Valid) {
            return false;
        }
        X13Specification spec = (X13Specification)item.getEstimationSpecification().clone();
        CompositeResults rslts = item.process();
        PreprocessingModel regarima = GenericSaResults.getPreprocessingModel((CompositeResults)rslts);
        RegArimaSpecification tspec = spec.getRegArimaSpecification();
        if (regarima == null) {
            item.setPointSpecification((ISaSpecification)spec);
            return true;
        }
        TransformSpec transform = tspec.getTransform();
        X11Specification x11 = spec.getX11Specification();
        if (regarima.isMultiplicative()) {
            transform.setFunction(DefaultTransformationType.Log);
            if (x11.getMode() == DecompositionMode.Undefined) {
                x11.setMode(DecompositionMode.Multiplicative);
            }
        } else if (transform != null) {
            transform.setFunction(DefaultTransformationType.None);
            if (x11.getMode() == DecompositionMode.Undefined) {
                x11.setMode(DecompositionMode.Additive);
            }
        }
        RegressionSpec rspec = tspec.getRegression();
        TradingDaysSpec tdspec = rspec.getTradingDays();
        MovingHolidaySpec espec = rspec.getEaster();
        TsVariableList vars = regarima.description.buildRegressionVariables();
        if (tdspec.getTest() != RegressionTestSpec.None) {
            boolean used = false;
            tdspec.setTest(RegressionTestSpec.None);
            if (vars.select(ITradingDaysVariable.class).isEmpty()) {
                tdspec.setTradingDaysType(TradingDaysType.None);
            } else {
                used = true;
                if (tdspec.isAutoAdjust() && regarima.isMultiplicative() && tdspec.getLengthOfPeriod() != LengthOfPeriodType.None) {
                    transform.setAdjust(tdspec.getLengthOfPeriod());
                }
            }
            if (vars.select(ILengthOfPeriodVariable.class).isEmpty()) {
                tdspec.setLengthOfPeriod(LengthOfPeriodType.None);
            } else {
                used = true;
            }
            if (!used) {
                rspec.getTradingDays().disable();
            }
        }
        if (espec != null && espec.getTest() != RegressionTestSpec.None) {
            if (espec.getType() == MovingHolidaySpec.Type.Easter) {
                TsVariableSelection evar = vars.select(EasterVariable.class);
                if (evar.isEmpty()) {
                    rspec.removeMovingHolidays(espec);
                } else {
                    espec.setTest(RegressionTestSpec.None);
                    espec.setW(((EasterVariable)evar.get((int)0).variable).getDuration());
                }
            } else if (espec.getType() == MovingHolidaySpec.Type.JulianEaster) {
                TsVariableSelection evar = vars.select(JulianEasterVariable.class);
                if (evar.isEmpty()) {
                    rspec.removeMovingHolidays(espec);
                } else {
                    espec.setTest(RegressionTestSpec.None);
                    espec.setW(((JulianEasterVariable)evar.get((int)0).variable).getDuration());
                }
            }
        }
        tdspec.setAutoAdjust(false);
        OutlierSpec ospec = tspec.getOutliers();
        if (ospec.isUsed()) {
            TsVariableSelection sel = vars.select(OutlierType.Undefined);
            if (!sel.isEmpty()) {
                for (TsVariableSelection.Item o : sel.elements()) {
                    if (regarima.description.isPrespecified((IOutlierVariable)o.variable)) continue;
                    rspec.add((IOutlierVariable)o.variable);
                }
            }
            ospec.clearTypes();
        }
        tspec.getArima().setArimaComponent(regarima.description.getArimaComponent());
        tspec.setUsingAutoModel(false);
        rspec.clearAllCoefficients();
        double[] b = regarima.estimation.getLikelihood().getB();
        if (b != null) {
            int pos = regarima.description.getRegressionVariablesStartingPosition();
            for (ITsVariable var : vars.items()) {
                int npos = pos + var.getDim();
                rspec.setCoefficients(ITsVariable.shortName((String)var.getName()), Arrays.copyOfRange(b, pos, npos));
                pos = npos;
            }
        }
        item.setPointSpecification((ISaSpecification)spec);
        return true;
    }

    private void refreshArimaSpec(RegArimaSpecification spec, RegArimaSpecification defspec, EstimationPolicyType policy) {
        ArimaSpec arima = spec.getArima();
        ArimaSpec defarima = defspec.isUsingAutoModel() ? null : defspec.getArima();
        switch (policy) {
            case Fixed: 
            case Current: {
                if (arima.isMean()) {
                    arima.fixMu();
                }
            }
            case FixedParameters: {
                arima.setParameterType(ParameterType.Fixed);
                break;
            }
            case FreeParameters: 
            case LastOutliers: 
            case Outliers: {
                if (defarima != null) {
                    spec.setArima(defarima.clone());
                    break;
                }
                arima.clearParameters();
                break;
            }
            case Outliers_StochasticComponent: {
                if (defarima != null) {
                    spec.setArima(defarima.clone());
                    break;
                }
                spec.setAutoModel(defspec.getAutoModel());
            }
        }
    }

    private void refreshOutliersSpec(RegArimaSpecification spec, RegArimaSpecification defspec, TsDomain frozen, EstimationPolicyType policy) {
        RegressionSpec rspec = spec.getRegression();
        RegressionSpec defrspec = defspec.getRegression();
        OutlierSpec defospec = defspec.getOutliers();
        switch (policy) {
            case Fixed: 
            case Current: 
            case FixedParameters: 
            case FreeParameters: {
                break;
            }
            case LastOutliers: {
                OutlierDefinition[] o = rspec.getOutliers();
                rspec.setOutliers(defrspec.getOutliers());
                if (frozen != null && o != null) {
                    for (int j = 0; j < o.length; ++j) {
                        OutlierDefinition cur = o[j];
                        if (frozen.search(cur.getPosition()) < 0 || defrspec.contains(cur)) continue;
                        rspec.add(cur);
                    }
                }
                OutlierSpec no = defospec.clone();
                if (frozen != null) {
                    no.getSpan().from(frozen.getEnd().firstday());
                }
                spec.setOutliers(no);
                break;
            }
            case Outliers: 
            case Outliers_StochasticComponent: {
                spec.setOutliers(defospec.clone());
                rspec.setOutliers(defrspec.getOutliers());
            }
        }
    }

    @Override
    public SaDocument<?> createDocument() {
        return new X13Document();
    }

    @Override
    public List<ISaSpecification> defaultSpecifications() {
        ArrayList<ISaSpecification> specs = new ArrayList<ISaSpecification>();
        specs.add((ISaSpecification)X13Specification.RSAX11);
        specs.add((ISaSpecification)X13Specification.RSA0);
        specs.add((ISaSpecification)X13Specification.RSA1);
        specs.add((ISaSpecification)X13Specification.RSA2);
        specs.add((ISaSpecification)X13Specification.RSA3);
        specs.add((ISaSpecification)X13Specification.RSA4);
        specs.add((ISaSpecification)X13Specification.RSA5);
        return specs;
    }

    public void dispose() {
    }

    public AlgorithmDescriptor getInformation() {
        return X13ProcessingFactory.instance.getInformation();
    }

    public boolean canHandle(IProcSpecification spec) {
        return X13ProcessingFactory.instance.canHandle(spec);
    }

    public IProcessing<TsData, CompositeResults> generateProcessing(X13Specification specification, ProcessingContext context) {
        return X13ProcessingFactory.instance.generateProcessing(specification, context);
    }

    public Map<String, Class> getSpecificationDictionary(Class<X13Specification> specClass) {
        return X13ProcessingFactory.instance.getSpecificationDictionary(specClass);
    }

    public Map<String, Class> getOutputDictionary(boolean compact) {
        return X13ProcessingFactory.instance.getOutputDictionary(compact);
    }
}

