/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.revisions;

import ec.tss.Ts;
import ec.tss.TsCollection;
import ec.tss.TsCollectionInformation;
import ec.tss.TsFactory;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.documents.ActiveDocument;
import ec.tss.sa.revisions.RevisionAnalysisProcessor;
import ec.tss.sa.revisions.RevisionAnalysisSpec;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.information.InformationSet;
import java.util.ArrayList;

public class RevisionAnalysisDocument
extends ActiveDocument<RevisionAnalysisSpec, TsCollection, CompositeResults> {
    private final RevisionAnalysisProcessor processor = RevisionAnalysisProcessor.instance;

    public RevisionAnalysisDocument() {
        super(RevisionAnalysisProcessor.DESCRIPTOR.name);
        this.setSpecification(new RevisionAnalysisSpec());
    }

    public RevisionAnalysisDocument(ProcessingContext context) {
        super(RevisionAnalysisProcessor.DESCRIPTOR.name, context);
        this.setSpecification(new RevisionAnalysisSpec());
    }

    public void setTsCollection(TsCollection coll) {
        super.setInput(coll);
    }

    public InformationSet write(boolean verbose) {
        InformationSet info = super.write(verbose);
        info.add("algorithm", (Object)this.processor.getInformation());
        TsCollectionInformation tsCollInfo = ((TsCollection)this.getInput()).toInfo(TsInformationType.All);
        info.add("input", (Object)tsCollInfo);
        info.set("specification", (Object)((RevisionAnalysisSpec)this.getSpecification()).write(verbose));
        return info;
    }

    public boolean read(InformationSet info) {
        InformationSet ispec;
        if (!super.read(info)) {
            return false;
        }
        AlgorithmDescriptor algorithm = (AlgorithmDescriptor)info.get("algorithm", AlgorithmDescriptor.class);
        if (algorithm == null || !this.processor.getInformation().isCompatible(algorithm)) {
            return false;
        }
        TsCollectionInformation inputs = (TsCollectionInformation)info.get("input", TsCollectionInformation.class);
        if (inputs != null) {
            ArrayList<Ts> allTs = new ArrayList<Ts>();
            ArrayList<TsInformation> allTsInfo = inputs.items;
            for (int i = 0; i < allTsInfo.size(); ++i) {
                TsInformation tsinfo = (TsInformation)allTsInfo.get(i);
                if (tsinfo.data != null) {
                    allTs.add(TsFactory.instance.createTs(tsinfo.name, tsinfo.moniker, tsinfo.metaData, tsinfo.data));
                    continue;
                }
                allTs.add(TsFactory.instance.createTs(tsinfo.name, tsinfo.moniker, TsInformationType.None));
            }
            super.setInput(TsFactory.instance.createTsCollection(inputs.name, inputs.moniker, inputs.metaData, allTs), true);
        }
        if ((ispec = info.getSubSet("specification")) != null) {
            RevisionAnalysisSpec spec = new RevisionAnalysisSpec();
            if (spec.read(ispec)) {
                this.setSpecification(spec, true);
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    protected CompositeResults recalc(RevisionAnalysisSpec spec, TsCollection input) {
        return (CompositeResults)this.processor.generateProcessing(spec, (ProcessingContext)null).process((Object)input);
    }

    @Override
    public String getDescription() {
        return this.processor.getInformation().name;
    }
}

