/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.revisions;

import ec.satoolkit.DecompositionMode;
import ec.tss.Ts;
import ec.tss.TsCollection;
import ec.tss.sa.revisions.RevisionAnalysisSpec;
import ec.tss.sa.revisions.RevisionStatistics;
import ec.tss.sa.revisions.SingleRevisionAnalysisProcessor;
import ec.tstoolkit.algorithm.AlgorithmDescriptor;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.algorithm.IProcessing;
import ec.tstoolkit.algorithm.IProcessingFactory;
import ec.tstoolkit.algorithm.IProcessingNode;
import ec.tstoolkit.algorithm.ParallelProcessingNode;
import ec.tstoolkit.algorithm.ProcessingContext;
import ec.tstoolkit.algorithm.SequentialProcessing;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.information.ProxyResults;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class RevisionAnalysisProcessor
implements IProcessingFactory<RevisionAnalysisSpec, TsCollection, CompositeResults> {
    public static final String BATCH = "batch";
    public static final String SERIES = "series";
    public static final String SUMMARY = "summary";
    public static final String FAMILY = "Seasonal adjustment";
    public static final AlgorithmDescriptor DESCRIPTOR = new AlgorithmDescriptor("Seasonal adjustment", "Revision Analysis", null);
    private final Map<String, Class> dictionary = new HashMap<String, Class>();
    public static final RevisionAnalysisProcessor instance = new RevisionAnalysisProcessor();

    public RevisionAnalysisProcessor() {
        this.setDefaultDictionary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDictionary(Map<String, Class> dic) {
        Map<String, Class> map = this.dictionary;
        synchronized (map) {
            this.dictionary.clear();
            this.dictionary.putAll(dic);
        }
    }

    public void dispose() {
    }

    public AlgorithmDescriptor getInformation() {
        return DESCRIPTOR;
    }

    public boolean canHandle(IProcSpecification spec) {
        return spec instanceof RevisionAnalysisSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IProcessing<TsCollection, CompositeResults> generateProcessing(final RevisionAnalysisSpec spec, ProcessingContext context) {
        Map<String, Class> map = this.dictionary;
        synchronized (map) {
            final HashMap<String, Class> localdictionary = new HashMap<String, Class>();
            localdictionary.putAll(this.dictionary);
            SequentialProcessing all = new SequentialProcessing();
            IProcessingNode<TsCollection> saStep = new IProcessingNode<TsCollection>(){

                public String getName() {
                    return RevisionAnalysisProcessor.BATCH;
                }

                public String getPrefix() {
                    return this.getName();
                }

                public IProcessing.Status process(TsCollection input, Map<String, IProcResults> results) {
                    if (input == null || input.isEmpty()) {
                        return IProcessing.Status.Invalid;
                    }
                    ParallelProcessingNode cmps = new ParallelProcessingNode(RevisionAnalysisProcessor.BATCH, null);
                    for (int i = 0; i < input.getCount(); ++i) {
                        cmps.add(this.createNode(spec, i));
                    }
                    return cmps.process((Object)input, results);
                }

                private IProcessingNode<TsCollection> createNode(final RevisionAnalysisSpec spec2, final int pos) {
                    return new IProcessingNode<TsCollection>(){

                        public String getName() {
                            return RevisionAnalysisProcessor.SERIES + pos;
                        }

                        public String getPrefix() {
                            return this.getName();
                        }

                        public IProcessing.Status process(TsCollection input, Map<String, IProcResults> results) {
                            Ts ts = input.get(pos);
                            SingleRevisionAnalysisProcessor proc = new SingleRevisionAnalysisProcessor(spec2, ts.getTsData());
                            if (!proc.process()) {
                                return IProcessing.Status.Invalid;
                            }
                            InformationSet rinfo = proc.search(localdictionary);
                            results.put(this.getName(), (IProcResults)new ProxyResults(rinfo, null));
                            return IProcessing.Status.Valid;
                        }
                    };
                }
            };
            all.add((IProcessingNode)saStep);
            IProcessingNode<TsCollection> statsStep = new IProcessingNode<TsCollection>(){

                public String getName() {
                    return RevisionAnalysisProcessor.SUMMARY;
                }

                public String getPrefix() {
                    return RevisionAnalysisProcessor.SUMMARY;
                }

                public IProcessing.Status process(TsCollection input, Map<String, IProcResults> results) {
                    IProcResults rslts = results.get(RevisionAnalysisProcessor.BATCH);
                    if (rslts != null) {
                        results.put(RevisionAnalysisProcessor.SUMMARY, new RevisionStatistics(input, rslts, spec.isOutOfSample(), spec.isTargetFinal()));
                        return IProcessing.Status.Valid;
                    }
                    return IProcessing.Status.Unprocessed;
                }
            };
            all.add((IProcessingNode)statsStep);
            return all;
        }
    }

    public Map<String, Class> getSpecificationDictionary(Class<RevisionAnalysisSpec> specClass) {
        HashMap<String, Class> dic = new HashMap<String, Class>();
        RevisionAnalysisSpec.fillDictionary(null, dic);
        return dic;
    }

    public Map<String, Class> getOutputDictionary(boolean compact) {
        LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
        return dic;
    }

    private void setDefaultDictionary() {
        this.dictionary.clear();
        this.dictionary.put("sa", TsData.class);
        this.dictionary.put("s", TsData.class);
        this.dictionary.put("cal", TsData.class);
        this.dictionary.put("s_lin", TsData.class);
        this.dictionary.put("sa_lin", TsData.class);
        this.dictionary.put("mode", DecompositionMode.class);
        this.dictionary.put("residuals.ser", Double.class);
    }
}

