/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.revisions;

import ec.satoolkit.ISaSpecification;
import ec.satoolkit.tramoseats.TramoSeatsSpecification;
import ec.tss.sa.EstimationPolicyType;
import ec.tss.sa.revisions.RevisionAnalysisProcessor;
import ec.tstoolkit.algorithm.IProcSpecification;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.Month;
import java.util.Map;

public class RevisionAnalysisSpec
implements IProcSpecification,
Cloneable {
    public static final String LENGTH = "revisionLength";
    public static final String DELAY = "revisionDelay";
    public static final String MAIN_POLICY = "mainPolicy";
    public static final String INTERMEDIATE_POLICY = "intermediatePolicy";
    public static final String SPECIFICATION = "specification";
    public static final String REVISION_START = "revisionStartDay";
    public static final String OUTOFSAMPLE = "outofsample";
    public static final String FINAL = "final";
    private MainPolicyType mainEstimation = MainPolicyType.Complete;
    private IntermediatePolicyType intermediateEstimation = IntermediatePolicyType.FreeParameters;
    private ISaSpecification specification = TramoSeatsSpecification.RSA4;
    private int analysisLength = 4;
    private int revisionDelay = 1;
    private boolean ftarget = false;
    private DayMonth revisionDay = DayMonth.BEG;
    private boolean outOfSample = true;

    public MainPolicyType getMainEstimation() {
        return this.mainEstimation;
    }

    public void setMainEstimation(MainPolicyType mainEstimation) {
        this.mainEstimation = mainEstimation;
    }

    public IntermediatePolicyType getIntermediateEstimation() {
        return this.intermediateEstimation;
    }

    public void setIntermediateEstimation(IntermediatePolicyType intermediateEstimation) {
        this.intermediateEstimation = intermediateEstimation;
    }

    public boolean isOutOfSample() {
        return this.outOfSample;
    }

    public void setOutOfSample(boolean b) {
        this.outOfSample = b;
    }

    public boolean isTargetFinal() {
        return this.ftarget;
    }

    public void setTargetFinal(boolean b) {
        this.ftarget = b;
    }

    public int getAnalysisLength() {
        return this.analysisLength;
    }

    public void setAnalysisLength(int analysisLength) {
        this.analysisLength = analysisLength;
    }

    public int getRevisionDelay() {
        return this.revisionDelay;
    }

    public void setRevisionDelay(int revisionDelay) {
        this.revisionDelay = revisionDelay;
    }

    public DayMonth getRevisionDay() {
        return this.revisionDay;
    }

    public void setRevisionDay(DayMonth revisionDay) {
        this.revisionDay = revisionDay;
    }

    public ISaSpecification getSaSpecification() {
        return this.specification;
    }

    public void setSaSpecification(ISaSpecification specification) {
        this.specification = specification;
    }

    public RevisionAnalysisSpec clone() {
        try {
            return (RevisionAnalysisSpec)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError();
        }
    }

    public InformationSet write(boolean verbose) {
        InformationSet info = new InformationSet();
        info.set("algorithm", (Object)RevisionAnalysisProcessor.DESCRIPTOR);
        info.set(LENGTH, (Object)this.analysisLength);
        info.set(DELAY, (Object)this.revisionDelay);
        if (this.mainEstimation != null) {
            info.set(MAIN_POLICY, (Object)this.mainEstimation.toString());
        }
        if (this.intermediateEstimation != null || verbose) {
            info.set(INTERMEDIATE_POLICY, (Object)this.intermediateEstimation.toString());
        }
        if (this.specification != null || verbose) {
            info.set(SPECIFICATION, (Object)this.specification.write(true));
        }
        if (this.revisionDay != null || verbose) {
            info.set(REVISION_START, (Object)this.revisionDay.toString());
        }
        if (!this.outOfSample || verbose) {
            info.set(OUTOFSAMPLE, (Object)this.outOfSample);
        }
        if (this.ftarget || verbose) {
            info.set(FINAL, (Object)this.ftarget);
        }
        return info;
    }

    public boolean read(InformationSet info) {
        Boolean b;
        InformationSet s;
        String i;
        String m;
        Integer d;
        Integer l = (Integer)info.get(LENGTH, Integer.class);
        if (l != null) {
            this.analysisLength = l;
        }
        if ((d = (Integer)info.get(DELAY, Integer.class)) != null) {
            this.revisionDelay = d;
        }
        if ((m = (String)info.get(MAIN_POLICY, String.class)) != null) {
            this.mainEstimation = MainPolicyType.valueOf(m);
        }
        if ((i = (String)info.get(INTERMEDIATE_POLICY, String.class)) != null) {
            this.intermediateEstimation = IntermediatePolicyType.valueOf(i);
        }
        if ((s = (InformationSet)info.get(SPECIFICATION, InformationSet.class)) != null && !this.specification.read(s)) {
            return false;
        }
        String f = (String)info.get(REVISION_START, String.class);
        if (f != null) {
            String[] split = f.split("/");
            this.revisionDay = new DayMonth(Integer.parseInt(split[0]), Month.valueOf((String)split[1]));
        }
        if ((b = (Boolean)info.get(OUTOFSAMPLE, Boolean.class)) != null) {
            this.outOfSample = b;
        }
        if ((b = (Boolean)info.get(FINAL, Boolean.class)) != null) {
            this.ftarget = b;
        }
        return true;
    }

    public static void fillDictionary(String prefix, Map<String, Class> dic) {
        dic.put(InformationSet.item((String)prefix, (String)LENGTH), Integer.class);
        dic.put(InformationSet.item((String)prefix, (String)DELAY), Integer.class);
        dic.put(InformationSet.item((String)prefix, (String)MAIN_POLICY), String.class);
        dic.put(InformationSet.item((String)prefix, (String)INTERMEDIATE_POLICY), String.class);
        dic.put(InformationSet.item((String)prefix, (String)SPECIFICATION), InformationSet.class);
        dic.put(InformationSet.item((String)prefix, (String)REVISION_START), String.class);
        dic.put(InformationSet.item((String)prefix, (String)OUTOFSAMPLE), Boolean.class);
        dic.put(InformationSet.item((String)prefix, (String)FINAL), Boolean.class);
    }

    public static enum MainPolicyType {
        Complete(EstimationPolicyType.Complete),
        Outliers(EstimationPolicyType.Outliers),
        LastOutliers(EstimationPolicyType.LastOutliers),
        FreeParameters(EstimationPolicyType.FreeParameters),
        FixedParameters(EstimationPolicyType.FixedParameters),
        Fixed(EstimationPolicyType.Fixed),
        Current(EstimationPolicyType.Current);

        private final EstimationPolicyType t;

        private MainPolicyType(EstimationPolicyType t) {
            this.t = t;
        }

        public EstimationPolicyType getType() {
            return this.t;
        }
    }

    public static enum IntermediatePolicyType {
        Complete(EstimationPolicyType.Complete),
        Outliers(EstimationPolicyType.Outliers),
        LastOutliers(EstimationPolicyType.LastOutliers),
        FreeParameters(EstimationPolicyType.FreeParameters),
        FixedParameters(EstimationPolicyType.FixedParameters),
        Fixed(EstimationPolicyType.Fixed),
        Current(EstimationPolicyType.Current);

        private final EstimationPolicyType t;

        private IntermediatePolicyType(EstimationPolicyType t) {
            this.t = t;
        }

        public EstimationPolicyType getType() {
            return this.t;
        }
    }

    public static class DayMonth {
        public final int day;
        public final Month month;
        public static DayMonth BEG = new DayMonth(0, Month.January);

        public DayMonth(int day, Month month) {
            this.day = day;
            this.month = month;
        }

        public String toString() {
            return String.valueOf(this.day) + "/" + this.month.toString();
        }
    }
}

