/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.revisions;

import ec.satoolkit.DecompositionMode;
import ec.tss.TsCollection;
import ec.tstoolkit.algorithm.IProcResults;
import ec.tstoolkit.algorithm.ProcessingInformation;
import ec.tstoolkit.data.DescriptiveStatistics;
import ec.tstoolkit.information.Information;
import ec.tstoolkit.information.InformationMapping;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.simplets.TsData;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class RevisionStatistics
implements IProcResults {
    public static final String DSACOUNT = "dn";
    public static final String DSAMIN = "dsamin";
    public static final String DSAMAX = "dsamax";
    public static final String DSAAVERAGE = "dsaaverage";
    public static final String DSASTDEV = "dsastdev";
    public static final String SACOUNT = "n";
    public static final String SAMIN = "samin";
    public static final String SAMAX = "samax";
    public static final String SAAVERAGE = "saaverage";
    public static final String SASTDEV = "sastdev";
    public static final String SCOUNT = "sn";
    public static final String SMIN = "smin";
    public static final String SMAX = "smax";
    public static final String SAVERAGE = "saverage";
    public static final String SSTDEV = "sstdev";
    public static final String CCOUNT = "cn";
    public static final String CMIN = "cmin";
    public static final String CMAX = "cmax";
    public static final String CAVERAGE = "caverage";
    public static final String CSTDEV = "cstdev";
    public static final String DSAREVS = "dsarevs";
    public static final String SAREVS = "sarevs";
    public static final String SREVS = "srevs";
    public static final String CREVS = "crevs";
    private static final InformationMapping<RevisionStatistics> MAPPING = new InformationMapping(RevisionStatistics.class);
    private int[] dsan_;
    private int[] san_;
    private int[] sn_;
    private int[] cn_;
    private double[] samin_;
    private double[] samax_;
    private double[] saavg_;
    private double[] sastdev_;
    private double[] dsamin_;
    private double[] dsamax_;
    private double[] dsaavg_;
    private double[] dsastdev_;
    private double[] smin_;
    private double[] smax_;
    private double[] savg_;
    private double[] sstdev_;
    private double[] cmin_;
    private double[] cmax_;
    private double[] cavg_;
    private double[] cstdev_;
    private double[][] dsarevs_;
    private double[][] sarevs_;
    private double[][] srevs_;
    private double[][] crevs_;
    private final boolean outofsample_;
    private final boolean ftarget_;

    public boolean contains(String id) {
        return MAPPING.contains(id);
    }

    public Map<String, Class> getDictionary() {
        LinkedHashMap<String, Class> map = new LinkedHashMap<String, Class>();
        MAPPING.fillDictionary(null, map, false);
        return map;
    }

    public <T> T getData(String id, Class<T> tclass) {
        return (T)MAPPING.getData((Object)this, id, tclass);
    }

    public static InformationMapping<RevisionStatistics> getMapping() {
        return MAPPING;
    }

    public static <T> void setMapping(String name, Class<T> tclass, Function<RevisionStatistics, T> extractor) {
        MAPPING.set(name, tclass, extractor);
    }

    public static <T> void setTsData(String name, Function<RevisionStatistics, TsData> extractor) {
        MAPPING.set(name, extractor);
    }

    public RevisionStatistics(TsCollection input, IProcResults results, boolean outofsample, boolean ftarget) {
        this.outofsample_ = outofsample;
        this.ftarget_ = ftarget;
        InformationSet[] all = new InformationSet[input.getCount()];
        InformationSet[][] details = new InformationSet[input.getCount()][];
        int[] nrevs = new int[all.length];
        int revmax = 0;
        for (int i = 0; i < nrevs.length; ++i) {
            int n;
            String item = InformationSet.item((String)("series" + i), (String)"all");
            all[i] = (InformationSet)results.getData(item, InformationSet.class);
            if (all[i] == null) continue;
            List ver = all[i].select("vintage*", InformationSet.class);
            nrevs[i] = n = ver.size();
            if (this.outofsample_ && !this.ftarget_ || !this.outofsample_ && this.ftarget_) {
                --n;
            }
            if (nrevs[i] > revmax) {
                revmax = nrevs[i];
            }
            details[i] = new InformationSet[n];
            for (int j = 0; j < n; ++j) {
                details[i][j] = (InformationSet)((Information)ver.get((int)j)).value;
            }
        }
        this.san_ = new int[revmax];
        this.samin_ = new double[revmax];
        this.samax_ = new double[revmax];
        this.saavg_ = new double[revmax];
        this.sastdev_ = new double[revmax];
        this.sarevs_ = new double[revmax][];
        this.sn_ = new int[revmax];
        this.smin_ = new double[revmax];
        this.smax_ = new double[revmax];
        this.savg_ = new double[revmax];
        this.sstdev_ = new double[revmax];
        this.srevs_ = new double[revmax][];
        this.cn_ = new int[revmax];
        this.cmin_ = new double[revmax];
        this.cmax_ = new double[revmax];
        this.cavg_ = new double[revmax];
        this.cstdev_ = new double[revmax];
        this.crevs_ = new double[revmax][];
        this.dsan_ = new int[revmax];
        this.dsamin_ = new double[revmax];
        this.dsamax_ = new double[revmax];
        this.dsaavg_ = new double[revmax];
        this.dsastdev_ = new double[revmax];
        this.dsarevs_ = new double[revmax][];
        if (this.ftarget_) {
            this.computeTowardsEnd(all, details, revmax);
        } else {
            this.computeTowardsStart(all, details, revmax);
        }
    }

    private static boolean isConstant(TsData s) {
        if (s == null) {
            return true;
        }
        double[] d = s.internalStorage();
        for (int i = 1; i < s.getLength(); ++i) {
            if (d[i] == d[0]) continue;
            return false;
        }
        return true;
    }

    private double[] toarray(List list) {
        double[] x = new double[list.size()];
        for (int i = 0; i < x.length; ++i) {
            x[i] = (Double)list.get(i);
        }
        return x;
    }

    private void computeTowardsStart(InformationSet[] all, InformationSet[][] details, int revmax) {
        List[] rsadata = new List[revmax];
        List[] rdsadata = new List[revmax];
        List[] rsdata = new List[revmax];
        List[] rcdata = new List[revmax];
        for (int i = 0; i < revmax; ++i) {
            rsadata[i] = new ArrayList();
            rdsadata[i] = new ArrayList();
            rsdata[i] = new ArrayList();
            rcdata[i] = new ArrayList();
        }
        String ref = "ref0";
        String refs = InformationSet.item((String)ref, (String)"s_lin");
        String refsa = InformationSet.item((String)ref, (String)"sa");
        String refc = InformationSet.item((String)ref, (String)"cal");
        String refmode = InformationSet.item((String)ref, (String)"mode");
        String refser = InformationSet.item((String)ref, (String)"residuals.ser");
        for (int i = 0; i < all.length; ++i) {
            boolean hass;
            DecompositionMode rmode = (DecompositionMode)all[i].search(refmode, DecompositionMode.class);
            double ser = (Double)all[i].search(refser, Double.class);
            TsData rs = (TsData)all[i].search(refs, TsData.class);
            TsData rsa = (TsData)all[i].search(refsa, TsData.class);
            TsData rc = (TsData)all[i].search(refc, TsData.class);
            if (rmode.isMultiplicative()) {
                if (rs != null) {
                    rs = rs.log();
                }
                if (rc != null) {
                    rc = rc.log();
                }
            }
            boolean bl = hass = !RevisionStatistics.isConstant(rs);
            if (!hass) continue;
            for (int j = 0; j < revmax; ++j) {
                boolean hasslin;
                DecompositionMode jmode;
                if (j >= details[i].length || details[i][j] == null || rmode != (jmode = (DecompositionMode)details[i][j].get("mode", DecompositionMode.class))) continue;
                TsData saj = (TsData)details[i][j].get("sa", TsData.class);
                int l = rsa.getLength() - 1;
                int d = !this.outofsample_ ? j : saj.getLength() - rsa.getLength() - 1;
                rsadata[d].add(saj.get(l) / rsa.get(l) - 1.0);
                rdsadata[d].add(saj.get(l) / saj.get(l - 1) - rsa.get(l) / rsa.get(l - 1));
                TsData slinj = (TsData)details[i][j].get("s_lin", TsData.class);
                TsData cj = (TsData)details[i][j].get("cal", TsData.class);
                boolean hasc = !RevisionStatistics.isConstant(rc) && !RevisionStatistics.isConstant(cj);
                boolean bl2 = hasslin = !RevisionStatistics.isConstant(rs) && !RevisionStatistics.isConstant(slinj);
                if (hasslin) {
                    if (rmode.isMultiplicative()) {
                        slinj = slinj.log();
                    }
                    rsdata[d].add((slinj.get(l) - rs.get(l)) / ser);
                }
                if (!hasc) continue;
                if (rmode.isMultiplicative()) {
                    cj = cj.log();
                }
                rcdata[d].add((cj.get(l) - rc.get(l)) / ser);
            }
        }
        this.computeStatistics(rsadata, rdsadata, rsdata, rcdata, revmax);
    }

    private void computeTowardsEnd(InformationSet[] all, InformationSet[][] details, int revmax) {
        List[] rsadata = new List[revmax];
        List[] rdsadata = new List[revmax];
        List[] rsdata = new List[revmax];
        List[] rcdata = new List[revmax];
        for (int i = 0; i < revmax; ++i) {
            rsadata[i] = new ArrayList();
            rdsadata[i] = new ArrayList();
            rsdata[i] = new ArrayList();
            rcdata[i] = new ArrayList();
        }
        String ref = "ref1";
        String refs = InformationSet.item((String)ref, (String)"s_lin");
        String refsa = InformationSet.item((String)ref, (String)"sa");
        String refc = InformationSet.item((String)ref, (String)"cal");
        String refmode = InformationSet.item((String)ref, (String)"mode");
        String refser = InformationSet.item((String)ref, (String)"residuals.ser");
        for (int i = 0; i < all.length; ++i) {
            boolean hass;
            DecompositionMode rmode = (DecompositionMode)all[i].search(refmode, DecompositionMode.class);
            double ser = (Double)all[i].search(refser, Double.class);
            TsData rs = (TsData)all[i].search(refs, TsData.class);
            TsData rsa = (TsData)all[i].search(refsa, TsData.class);
            TsData rc = (TsData)all[i].search(refc, TsData.class);
            if (rmode.isMultiplicative()) {
                if (rs != null) {
                    rs = rs.log();
                }
                if (rc != null) {
                    rc = rc.log();
                }
            }
            boolean bl = hass = !RevisionStatistics.isConstant(rs);
            if (!hass) continue;
            for (int j = 0; j < revmax; ++j) {
                boolean hasslin;
                DecompositionMode jmode;
                if (j >= details[i].length || details[i][j] == null || rmode != (jmode = (DecompositionMode)details[i][j].get("mode", DecompositionMode.class))) continue;
                TsData saj = (TsData)details[i][j].get("sa", TsData.class);
                int l = saj.getLength() - 1;
                int d = this.outofsample_ ? j : rsa.getLength() - saj.getLength() - 1;
                rsadata[d].add(rsa.get(l) / saj.get(l) - 1.0);
                rdsadata[d].add(rsa.get(l) / rsa.get(l - 1) - saj.get(l) / saj.get(l - 1));
                TsData slinj = (TsData)details[i][j].get("s_lin", TsData.class);
                TsData cj = (TsData)details[i][j].get("cal", TsData.class);
                boolean hasc = !RevisionStatistics.isConstant(rc) && !RevisionStatistics.isConstant(cj);
                boolean bl2 = hasslin = !RevisionStatistics.isConstant(rs) && !RevisionStatistics.isConstant(slinj);
                if (hasslin) {
                    if (rmode.isMultiplicative()) {
                        slinj = slinj.log();
                    }
                    rsdata[d].add((rs.get(l) - slinj.get(l)) / ser);
                }
                if (!hasc) continue;
                if (rmode.isMultiplicative()) {
                    cj = cj.log();
                }
                rcdata[d].add((rc.get(l) - cj.get(l)) / ser);
            }
        }
        this.computeStatistics(rsadata, rdsadata, rsdata, rcdata, revmax);
    }

    private void computeStatistics(List[] rsadata, List[] rdsadata, List[] rsdata, List[] rcdata, int revmax) {
        for (int i = 0; i < revmax; ++i) {
            double[] data = this.toarray(rsadata[i]);
            this.sarevs_[i] = data;
            DescriptiveStatistics stats = new DescriptiveStatistics(data);
            this.samax_[i] = stats.getMax();
            this.samin_[i] = stats.getMin();
            this.saavg_[i] = stats.getAverage();
            this.sastdev_[i] = stats.getRmse();
            this.san_[i] = stats.getObservationsCount();
            data = this.toarray(rdsadata[i]);
            this.dsarevs_[i] = data;
            stats = new DescriptiveStatistics(data);
            this.dsamax_[i] = stats.getMax();
            this.dsamin_[i] = stats.getMin();
            this.dsaavg_[i] = stats.getAverage();
            this.dsastdev_[i] = stats.getRmse();
            this.dsan_[i] = stats.getObservationsCount();
            data = this.toarray(rsdata[i]);
            this.srevs_[i] = data;
            stats = new DescriptiveStatistics(data);
            this.smax_[i] = stats.getMax();
            this.smin_[i] = stats.getMin();
            this.savg_[i] = stats.getAverage();
            this.sstdev_[i] = stats.getRmse();
            this.sn_[i] = stats.getObservationsCount();
            data = this.toarray(rcdata[i]);
            this.crevs_[i] = data;
            stats = new DescriptiveStatistics(data);
            this.cmax_[i] = stats.getMax();
            this.cmin_[i] = stats.getMin();
            this.cavg_[i] = stats.getAverage();
            this.cstdev_[i] = stats.getRmse();
            this.cn_[i] = stats.getObservationsCount();
        }
    }

    public List<ProcessingInformation> getProcessingInformation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        MAPPING.set(DSACOUNT, int[].class, source -> source.dsan_);
        MAPPING.set(DSAMIN, double[].class, source -> source.dsamin_);
        MAPPING.set(DSAMAX, double[].class, source -> source.dsamax_);
        MAPPING.set(DSAAVERAGE, double[].class, source -> source.dsaavg_);
        MAPPING.set(DSASTDEV, double[].class, source -> source.dsastdev_);
        MAPPING.set(SACOUNT, int[].class, source -> source.san_);
        MAPPING.set(SAMIN, double[].class, source -> source.samin_);
        MAPPING.set(SAMAX, double[].class, source -> source.samax_);
        MAPPING.set(SAAVERAGE, double[].class, source -> source.saavg_);
        MAPPING.set(SASTDEV, double[].class, source -> source.sastdev_);
        MAPPING.set(SCOUNT, int[].class, source -> source.sn_);
        MAPPING.set(SMIN, double[].class, source -> source.smin_);
        MAPPING.set(SMAX, double[].class, source -> source.smax_);
        MAPPING.set(SAVERAGE, double[].class, source -> source.savg_);
        MAPPING.set(SSTDEV, double[].class, source -> source.sstdev_);
        MAPPING.set(CCOUNT, int[].class, source -> source.cn_);
        MAPPING.set(CMIN, double[].class, source -> source.cmin_);
        MAPPING.set(CMAX, double[].class, source -> source.cmax_);
        MAPPING.set(CAVERAGE, double[].class, source -> source.cavg_);
        MAPPING.set(CSTDEV, double[].class, source -> source.cstdev_);
    }
}

