/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.sa.revisions;

import ec.satoolkit.ISaSpecification;
import ec.tss.Ts;
import ec.tss.TsFactory;
import ec.tss.sa.EstimationPolicyType;
import ec.tss.sa.SaItem;
import ec.tss.sa.SaManager;
import ec.tss.sa.revisions.RevisionAnalysisSpec;
import ec.tstoolkit.algorithm.CompositeResults;
import ec.tstoolkit.information.InformationSet;
import ec.tstoolkit.timeseries.Day;
import ec.tstoolkit.timeseries.simplets.TsData;
import ec.tstoolkit.timeseries.simplets.TsDomain;
import ec.tstoolkit.timeseries.simplets.TsPeriod;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SingleRevisionAnalysisProcessor {
    public static final String REF0 = "ref0";
    public static final String REF1 = "ref1";
    public static final String VER = "vintage";
    private final RevisionAnalysisSpec spec_;
    private final TsData s_;
    private final TsDomain refDomain_;
    private InformationSet rslts_;
    private CompositeResults ref0_;
    private CompositeResults ref1_;
    private final List<CompositeResults> details_ = new ArrayList<CompositeResults>();

    public SingleRevisionAnalysisProcessor(RevisionAnalysisSpec spec, TsData s) {
        this.spec_ = spec;
        this.s_ = s;
        this.refDomain_ = this.s_ == null ? null : this.s_.getDomain();
    }

    public InformationSet getReference() {
        return this.rslts_;
    }

    public boolean process() {
        TsPeriod end;
        int i;
        this.rslts_ = null;
        this.details_.clear();
        SaItem cur = this.computeReferences();
        if (cur == null) {
            return false;
        }
        TsDomain dom = this.searchStartingDomain();
        if (this.spec_.isOutOfSample()) {
            if (this.spec_.isTargetFinal()) {
                this.details_.add(cur.process());
            }
            i = 1;
            dom = dom.extend(0, 1);
            end = this.refDomain_.getEnd();
        } else {
            i = 0;
            end = this.refDomain_.getLast();
        }
        int freq = dom.getFrequency().intValue();
        while (dom.getEnd().isNotAfter(end)) {
            Ts tmp = TsFactory.instance.createTs("tmp" + i, null, this.s_.fittoDomain(dom));
            EstimationPolicyType policy = 0 == i % (freq * this.spec_.getRevisionDelay()) ? this.spec_.getMainEstimation().getType() : this.spec_.getIntermediateEstimation().getType();
            ISaSpecification espec = SaManager.instance.createSpecification(cur, dom.drop(0, freq), policy, true);
            cur = cur.newSpecification(tmp, espec, policy);
            this.details_.add(cur.process());
            ++i;
            dom = dom.extend(0, 1);
        }
        if (!this.spec_.isOutOfSample() && !this.spec_.isTargetFinal()) {
            this.details_.add(this.ref1_);
        }
        return true;
    }

    private SaItem computeReferences() {
        SaItem ref1 = this.inSampleReference();
        SaItem ref0 = this.outOfSampleReference();
        if (this.spec_.isOutOfSample()) {
            return ref0;
        }
        return ref1;
    }

    private SaItem inSampleReference() {
        Ts tmp = TsFactory.instance.createTs("ref", null, this.s_);
        SaItem cur = new SaItem(this.spec_.getSaSpecification(), tmp);
        this.ref1_ = cur.process();
        return this.ref1_ != null ? cur : null;
    }

    private SaItem outOfSampleReference() {
        TsDomain fdom = this.searchStartingDomain();
        Ts tmp = TsFactory.instance.createTs("ref", null, this.s_.fittoDomain(fdom));
        SaItem cur = new SaItem(this.spec_.getSaSpecification(), tmp);
        this.ref0_ = cur.process();
        return this.ref0_ != null ? cur : null;
    }

    private TsDomain searchStartingDomain() {
        TsDomain start = this.refDomain_.drop(0, this.spec_.getAnalysisLength() * this.refDomain_.getFrequency().intValue() - 1);
        Day day = new Day(start.getLast().getYear(), this.spec_.getRevisionDay().month, this.spec_.getRevisionDay().day);
        int pos = start.search(day);
        int del = start.getLength() - pos;
        if (pos >= 0 && del != 1) {
            start = start.drop(0, del - 1);
        }
        return start;
    }

    public <T> List<T> items(String name, Class<T> tclass) {
        ArrayList<Object> rslt = new ArrayList<Object>();
        for (CompositeResults r : this.details_) {
            rslt.add(r.getData(name, tclass));
        }
        return rslt;
    }

    public InformationSet search(Map<String, Class> dic) {
        InformationSet rslt = new InformationSet();
        for (String name : dic.keySet()) {
            Class cl = dic.get(name);
            String[] deepname = InformationSet.split((String)name);
            Object ref0 = this.ref0_.getData(name, cl);
            if (ref0 != null) {
                rslt.subSet(REF0).add(deepname, ref0);
            }
            int i = 0;
            for (CompositeResults x : this.details_) {
                Object v = x.getData(name, cl);
                if (v != null) {
                    rslt.subSet(VER + i).add(deepname, v);
                }
                ++i;
            }
            Object ref1 = this.ref1_.getData(name, cl);
            if (ref1 == null) continue;
            rslt.subSet(REF1).add(deepname, ref1);
        }
        return rslt;
    }
}

