/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSortedMap;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.Util;
import ec.tss.tsproviders.utils.AbstractConfigBuilder;
import ec.tss.tsproviders.utils.Formatters;
import ec.tss.tsproviders.utils.IConfig;
import ec.tss.tsproviders.utils.IConstraint;
import ec.tss.tsproviders.utils.ParamBean;
import ec.tss.tsproviders.utils.Parsers;
import ec.tss.tsproviders.utils.UriBuilder;
import ec.tstoolkit.design.VisibleForTesting;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.checkerframework.checker.nullness.qual.NonNull;

@XmlJavaTypeAdapter(value=XmlAdapter.class)
public final class DataSet
implements IConfig,
Serializable {
    private final DataSource dataSource;
    private final Kind kind;
    private final ImmutableSortedMap<String, String> params;
    private static final ThreadLocal<Xml> XML = ThreadLocal.withInitial(() -> new Xml());
    private static final String SCHEME = "demetra";
    private static final String HOST = "tsprovider";
    private static final Parsers.Parser<DataSet> URI_PARSER = new Parsers.FailSafeParser<DataSet>(){

        @Override
        protected DataSet doParse(CharSequence input) throws Exception {
            URI uri = new URI(input.toString());
            if (!DataSet.SCHEME.equals(uri.getScheme()) || !DataSet.HOST.equals(uri.getHost())) {
                return null;
            }
            String[] path = UriBuilder.getPathArray(uri, 3);
            if (path == null) {
                return null;
            }
            Map<String, String> query = UriBuilder.getQueryMap(uri);
            if (query == null) {
                return null;
            }
            Map<String, String> fragment = UriBuilder.getFragmentMap(uri);
            if (fragment == null) {
                return null;
            }
            DataSource dataSource = new DataSource(path[0], path[1], Util.toImmutable(query));
            return new DataSet(dataSource, Kind.valueOf(path[2]), Util.toImmutable(fragment));
        }
    };
    private static final Formatters.Formatter<DataSet> URI_FORMATTER = Formatters.wrap(DataSet::formatAsUri);

    @VisibleForTesting
    DataSet(@NonNull DataSource dataSource, @NonNull Kind kind, @NonNull ImmutableSortedMap<String, String> params) {
        this.dataSource = dataSource;
        this.kind = kind;
        this.params = params;
    }

    public @NonNull DataSource getDataSource() {
        return this.dataSource;
    }

    public @NonNull Kind getKind() {
        return this.kind;
    }

    @Override
    public SortedMap<String, String> getParams() {
        return this.params;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof DataSet && this.equals((DataSet)obj);
    }

    private boolean equals(DataSet that) {
        return this.dataSource.equals((Object)that.dataSource) && this.kind.equals(that.kind) && this.params.equals(that.params);
    }

    public int hashCode() {
        return Objects.hash(this.dataSource, this.kind, this.params);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)(this.dataSource + "(" + this.kind + ")"));
        this.params.forEach((arg_0, arg_1) -> ((MoreObjects.ToStringHelper)helper).add(arg_0, arg_1));
        return helper.toString();
    }

    public @NonNull Builder toBuilder(@NonNull Kind kind) {
        Objects.requireNonNull(kind, "kind");
        return (Builder)new Builder(this.dataSource, kind).putAll((Map<String, String>)this.params);
    }

    @VisibleForTesting
    DataSetBean toBean() {
        DataSetBean bean = new DataSetBean();
        bean.dataSource = this.dataSource.toBean();
        bean.kind = this.kind;
        bean.params = ParamBean.fromSortedMap(this.params);
        return bean;
    }

    public static @NonNull DataSet of(@NonNull DataSource dataSource, @NonNull Kind kind) {
        Objects.requireNonNull(dataSource, "dataSource");
        Objects.requireNonNull(kind, "kind");
        return new DataSet(dataSource, kind, (ImmutableSortedMap<String, String>)ImmutableSortedMap.of());
    }

    public static @NonNull DataSet of(@NonNull DataSource dataSource, @NonNull Kind kind, @NonNull String key, @NonNull String value) {
        Objects.requireNonNull(dataSource, "dataSource");
        Objects.requireNonNull(kind, "kind");
        return new DataSet(dataSource, kind, (ImmutableSortedMap<String, String>)ImmutableSortedMap.of((Comparable)((Object)key), (Object)value));
    }

    public static @NonNull DataSet deepCopyOf(@NonNull DataSource dataSource, @NonNull Kind kind, @NonNull Map<String, String> params) {
        Objects.requireNonNull(dataSource, "dataSource");
        Objects.requireNonNull(kind, "kind");
        return new DataSet(dataSource, kind, (ImmutableSortedMap<String, String>)ImmutableSortedMap.copyOf(params));
    }

    public static @NonNull Builder builder(@NonNull DataSource dataSource, @NonNull Kind kind) {
        Objects.requireNonNull(dataSource, "dataSource");
        Objects.requireNonNull(kind, "kind");
        return new Builder(dataSource, kind);
    }

    @Deprecated
    public static @NonNull Builder builder(@NonNull DataSet dataSet, @NonNull Kind kind) {
        return dataSet.toBuilder(kind);
    }

    public static @NonNull Formatters.Formatter<DataSet> xmlFormatter(boolean formattedOutput) {
        return formattedOutput ? DataSet.XML.get().formattedOutputFormatter : DataSet.XML.get().defaultFormatter;
    }

    public static @NonNull Parsers.Parser<DataSet> xmlParser() {
        return DataSet.XML.get().defaultParser;
    }

    public static @NonNull Formatters.Formatter<DataSet> uriFormatter() {
        return URI_FORMATTER;
    }

    public static @NonNull Parsers.Parser<DataSet> uriParser() {
        return URI_PARSER;
    }

    private static CharSequence formatAsUri(DataSet value) {
        DataSource dataSource = value.getDataSource();
        return new UriBuilder(SCHEME, HOST).path(dataSource.getProviderName(), dataSource.getVersion(), value.getKind().name()).query(dataSource.getParams()).fragment(value.getParams()).build().toString();
    }

    public static enum Kind implements IConstraint<DataSet>
    {
        SERIES,
        COLLECTION,
        DUMMY;


        @Override
        public String check(DataSet t) {
            return t.getKind().equals(this) ? null : String.format("Invalid DataSet Kind. Expected:%s Found:%s", this, t.getKind());
        }
    }

    public static class Builder
    extends AbstractConfigBuilder<Builder, DataSet> {
        final DataSource dataSource;
        final Kind kind;

        @VisibleForTesting
        Builder(DataSource dataSource, Kind kind) {
            this.dataSource = dataSource;
            this.kind = kind;
        }

        public DataSet build() {
            return new DataSet(this.dataSource, this.kind, Util.toImmutable(this.params));
        }
    }

    @XmlRootElement(name="dataSet")
    public static class DataSetBean {
        @XmlElement(name="dataSource")
        public DataSource.DataSourceBean dataSource;
        @XmlAttribute(name="kind")
        public Kind kind;
        @XmlElement(name="param")
        public ParamBean[] params;

        public DataSet toId() {
            return new DataSet(this.dataSource.toId(), this.kind != null ? this.kind : Kind.DUMMY, ParamBean.toSortedMap(this.params));
        }
    }

    private static final class Xml {
        static final JAXBContext BEAN_CONTEXT;
        final Parsers.Parser<DataSet> defaultParser = Parsers.wrap(Parsers.onJAXB(BEAN_CONTEXT).andThen(DataSetBean::toId));
        final Formatters.Formatter<DataSet> defaultFormatter = Formatters.onJAXB(BEAN_CONTEXT, false).compose(DataSet::toBean);
        final Formatters.Formatter<DataSet> formattedOutputFormatter = Formatters.onJAXB(BEAN_CONTEXT, true).compose(DataSet::toBean);

        private Xml() {
        }

        static {
            try {
                BEAN_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{DataSetBean.class});
            }
            catch (JAXBException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static class XmlAdapter
    extends javax.xml.bind.annotation.adapters.XmlAdapter<DataSetBean, DataSet> {
        public DataSet unmarshal(DataSetBean v) throws Exception {
            return v.toId();
        }

        public DataSetBean marshal(DataSet v) throws Exception {
            return v.toBean();
        }
    }
}

