/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSortedMap;
import ec.tss.tsproviders.Util;
import ec.tss.tsproviders.utils.AbstractConfigBuilder;
import ec.tss.tsproviders.utils.Formatters;
import ec.tss.tsproviders.utils.IConfig;
import ec.tss.tsproviders.utils.ParamBean;
import ec.tss.tsproviders.utils.Parsers;
import ec.tss.tsproviders.utils.UriBuilder;
import ec.tstoolkit.design.VisibleForTesting;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.checkerframework.checker.nullness.qual.NonNull;

@XmlJavaTypeAdapter(value=XmlAdapter.class)
public final class DataSource
implements IConfig,
Serializable {
    private final String providerName;
    private final String version;
    private final ImmutableSortedMap<String, String> params;
    private static final ThreadLocal<Xml> XML = ThreadLocal.withInitial(() -> new Xml());
    private static final String SCHEME = "demetra";
    private static final String HOST = "tsprovider";
    private static final Parsers.Parser<DataSource> URI_PARSER = new Parsers.FailSafeParser<DataSource>(){

        @Override
        protected DataSource doParse(CharSequence input) throws Exception {
            URI uri = new URI(input.toString());
            if (!DataSource.SCHEME.equals(uri.getScheme()) || !DataSource.HOST.equals(uri.getHost())) {
                return null;
            }
            String[] path = UriBuilder.getPathArray(uri, 2);
            if (path == null) {
                return null;
            }
            Map<String, String> query = UriBuilder.getQueryMap(uri);
            if (query == null) {
                return null;
            }
            return new DataSource(path[0], path[1], Util.toImmutable(query));
        }
    };
    private static final Formatters.Formatter<DataSource> URI_FORMATTER = Formatters.wrap(DataSource::formatAsUri);

    @VisibleForTesting
    DataSource(@NonNull String providerName, @NonNull String version, @NonNull ImmutableSortedMap<String, String> params) {
        this.providerName = providerName;
        this.version = version;
        this.params = params;
    }

    public @NonNull String getProviderName() {
        return this.providerName;
    }

    public @NonNull String getVersion() {
        return this.version;
    }

    @Override
    public SortedMap<String, String> getParams() {
        return this.params;
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof DataSource && this.equals((DataSource)obj);
    }

    private boolean equals(DataSource that) {
        return this.providerName.equals(that.providerName) && this.version.equals(that.version) && this.params.equals(that.params);
    }

    public int hashCode() {
        return Objects.hash(this.providerName, this.version, this.params);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)(this.providerName + "(" + this.version + ")"));
        this.params.forEach((arg_0, arg_1) -> ((MoreObjects.ToStringHelper)helper).add(arg_0, arg_1));
        return helper.toString();
    }

    public @NonNull Builder toBuilder() {
        return (Builder)new Builder(this.providerName, this.version).putAll((Map<String, String>)this.params);
    }

    @VisibleForTesting
    DataSourceBean toBean() {
        DataSourceBean bean = new DataSourceBean();
        bean.providerName = this.providerName;
        bean.version = this.version;
        bean.params = ParamBean.fromSortedMap(this.params);
        return bean;
    }

    public static @NonNull DataSource of(@NonNull String providerName, @NonNull String version) {
        Objects.requireNonNull(providerName, "providerName");
        Objects.requireNonNull(version, "version");
        return new DataSource(providerName, version, (ImmutableSortedMap<String, String>)ImmutableSortedMap.of());
    }

    public static @NonNull DataSource of(@NonNull String providerName, @NonNull String version, @NonNull String key, @NonNull String value) {
        Objects.requireNonNull(providerName, "providerName");
        Objects.requireNonNull(version, "version");
        return new DataSource(providerName, version, (ImmutableSortedMap<String, String>)ImmutableSortedMap.of((Comparable)((Object)key), (Object)value));
    }

    public static @NonNull DataSource deepCopyOf(@NonNull String providerName, @NonNull String version, @NonNull Map<String, String> params) {
        Objects.requireNonNull(providerName, "providerName");
        Objects.requireNonNull(version, "version");
        return new DataSource(providerName, version, (ImmutableSortedMap<String, String>)ImmutableSortedMap.copyOf(params));
    }

    public static @NonNull Builder builder(@NonNull String providerName, @NonNull String version) {
        Objects.requireNonNull(providerName, "providerName");
        Objects.requireNonNull(version, "version");
        return new Builder(providerName, version);
    }

    @Deprecated
    public static @NonNull Builder builder(@NonNull DataSource dataSource) {
        return dataSource.toBuilder();
    }

    public static @NonNull Formatters.Formatter<DataSource> xmlFormatter(boolean formattedOutput) {
        return formattedOutput ? DataSource.XML.get().formattedOutputFormatter : DataSource.XML.get().defaultFormatter;
    }

    public static @NonNull Parsers.Parser<DataSource> xmlParser() {
        return DataSource.XML.get().defaultParser;
    }

    public static @NonNull Formatters.Formatter<DataSource> uriFormatter() {
        return URI_FORMATTER;
    }

    public static @NonNull Parsers.Parser<DataSource> uriParser() {
        return URI_PARSER;
    }

    private static CharSequence formatAsUri(DataSource value) {
        return new UriBuilder(SCHEME, HOST).path(value.getProviderName(), value.getVersion()).query(value.getParams()).buildString();
    }

    public static class Builder
    extends AbstractConfigBuilder<Builder, DataSource> {
        final String providerName;
        final String version;

        @VisibleForTesting
        Builder(String providerName, String version) {
            this.providerName = providerName;
            this.version = version;
        }

        public DataSource build() {
            return new DataSource(this.providerName, this.version, Util.toImmutable(this.params));
        }
    }

    @XmlRootElement(name="dataSource")
    public static class DataSourceBean {
        @XmlAttribute(name="providerName")
        public String providerName;
        @XmlAttribute(name="version")
        public String version;
        @XmlElement(name="param")
        public ParamBean[] params;

        public DataSource toId() {
            return new DataSource(Strings.nullToEmpty((String)this.providerName), Strings.nullToEmpty((String)this.version), ParamBean.toSortedMap(this.params));
        }
    }

    private static final class Xml {
        static final JAXBContext BEAN_CONTEXT;
        final Parsers.Parser<DataSource> defaultParser = Parsers.wrap(Parsers.onJAXB(BEAN_CONTEXT).andThen(DataSourceBean::toId));
        final Formatters.Formatter<DataSource> defaultFormatter = Formatters.onJAXB(BEAN_CONTEXT, false).compose(DataSource::toBean);
        final Formatters.Formatter<DataSource> formattedOutputFormatter = Formatters.onJAXB(BEAN_CONTEXT, true).compose(DataSource::toBean);

        private Xml() {
        }

        static {
            try {
                BEAN_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{DataSourceBean.class});
            }
            catch (JAXBException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static class XmlAdapter
    extends javax.xml.bind.annotation.adapters.XmlAdapter<DataSourceBean, DataSource> {
        public DataSource unmarshal(DataSourceBean v) throws Exception {
            return v.toId();
        }

        public DataSourceBean marshal(DataSource v) throws Exception {
            return v.toBean();
        }
    }
}

