/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders;

import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.IDataSourceListener;
import ec.tss.tsproviders.Util;
import ec.tss.tsproviders.utils.DataSourceEventSupport;
import java.util.List;
import java.util.function.Consumer;
import net.jcip.annotations.ThreadSafe;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

@ThreadSafe
public interface HasDataSourceList {
    public void reload(@NonNull DataSource var1) throws IllegalArgumentException;

    public @NonNull List<DataSource> getDataSources();

    public void addDataSourceListener(@NonNull IDataSourceListener var1);

    public void removeDataSourceListener(@NonNull IDataSourceListener var1);

    public static @NonNull HasDataSourceList of(@NonNull String providerName, @NonNull Logger logger, @NonNull Iterable<DataSource> dataSources, @NonNull Consumer<? super DataSource> cacheCleaner) {
        return new Util.DataSourceListSupport(providerName, dataSources, DataSourceEventSupport.create(logger), cacheCleaner);
    }

    public static @NonNull HasDataSourceList of(@NonNull String providerName, @NonNull Logger logger, @NonNull Iterable<DataSource> dataSources) {
        return HasDataSourceList.of(providerName, logger, dataSources, Util.DO_NOTHING);
    }
}

