/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders;

import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.HasDataSourceList;
import ec.tss.tsproviders.Util;
import ec.tss.tsproviders.utils.DataSourceEventSupport;
import java.util.LinkedHashSet;
import java.util.function.Consumer;
import net.jcip.annotations.ThreadSafe;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

@ThreadSafe
public interface HasDataSourceMutableList
extends HasDataSourceList {
    public boolean open(@NonNull DataSource var1) throws IllegalArgumentException;

    public boolean close(@NonNull DataSource var1) throws IllegalArgumentException;

    default public void closeAll() {
        this.getDataSources().forEach(this::close);
    }

    public static @NonNull HasDataSourceMutableList of(@NonNull String providerName, @NonNull Logger logger, @NonNull Consumer<? super DataSource> cacheCleaner) {
        return new Util.DataSourceMutableListSupport(providerName, new LinkedHashSet<DataSource>(), DataSourceEventSupport.create(logger), cacheCleaner);
    }

    public static @NonNull HasDataSourceMutableList of(@NonNull String providerName, @NonNull Logger logger) {
        return HasDataSourceMutableList.of(providerName, logger, Util.DO_NOTHING);
    }
}

