/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders;

import ec.tss.tsproviders.Util;
import ec.tstoolkit.utilities.Files2;
import java.io.File;
import java.io.FileNotFoundException;
import net.jcip.annotations.ThreadSafe;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ThreadSafe
public interface HasFilePaths {
    public void setPaths(@Nullable File[] var1);

    public @NonNull File[] getPaths();

    default public @NonNull File resolveFilePath(@NonNull File file) throws FileNotFoundException {
        File result = Files2.getAbsoluteFile((File[])this.getPaths(), (File)file);
        if (result == null) {
            throw new FileNotFoundException("Relative file '" + file.getPath() + "' outside paths");
        }
        if (!result.exists()) {
            throw new FileNotFoundException(result.getPath());
        }
        return result;
    }

    public static @NonNull HasFilePaths of() {
        return new Util.FilePathSupport(() -> {});
    }

    public static @NonNull HasFilePaths of(@NonNull Runnable onPathsChange) {
        return new Util.FilePathSupport(onPathsChange);
    }
}

