/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders;

import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import ec.tss.ITsProvider;
import ec.tss.Ts;
import ec.tss.TsCollection;
import ec.tss.TsFactory;
import ec.tss.TsInformationType;
import ec.tss.TsMoniker;
import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.IDataSourceProvider;
import ec.tss.tsproviders.IFileLoader;
import ec.tss.tsproviders.IProviderVisitor;
import ec.tstoolkit.utilities.Files2;
import ec.tstoolkit.utilities.Trees;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.util.AbstractList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TsProviders {
    private TsProviders() {
    }

    static @NonNull List<ITsProvider> asList() {
        final String[] providers = TsFactory.instance.getProviders();
        return new AbstractList<ITsProvider>(){

            @Override
            public ITsProvider get(int index) {
                return TsFactory.instance.getProvider(providers[index]);
            }

            @Override
            public int size() {
                return providers.length;
            }
        };
    }

    public static @NonNull FluentIterable<ITsProvider> all() {
        return FluentIterable.from(TsProviders.asList());
    }

    public static <T extends ITsProvider> @NonNull Optional<T> lookup(@NonNull Class<T> clazz, @NonNull String providerName) {
        ITsProvider result = TsFactory.instance.getProvider(providerName);
        return clazz.isInstance(result) ? Optional.of((Object)((ITsProvider)clazz.cast(result))) : Optional.absent();
    }

    public static <T extends ITsProvider> @NonNull Optional<T> lookup(@NonNull Class<T> clazz, @NonNull DataSource dataSource) {
        return TsProviders.lookup(clazz, dataSource.getProviderName());
    }

    public static <T extends ITsProvider> @NonNull Optional<T> lookup(@NonNull Class<T> clazz, @NonNull DataSet dataSet) {
        return TsProviders.lookup(clazz, dataSet.getDataSource());
    }

    public static <T extends ITsProvider> @NonNull Optional<T> lookup(@NonNull Class<T> clazz, @NonNull TsMoniker moniker) {
        String providerName = moniker.getSource();
        return providerName != null ? TsProviders.lookup(clazz, providerName) : Optional.absent();
    }

    @Deprecated
    public static <T extends ITsProvider> List<T> findAll(Class<T> clazz) {
        return TsProviders.all().filter(clazz).toList();
    }

    @Deprecated
    public static <T extends ITsProvider> T find(Class<T> clazz, String providerName) {
        return (T)((ITsProvider)TsProviders.lookup(clazz, providerName).orNull());
    }

    @Deprecated
    public static <T extends ITsProvider> T find(Class<T> clazz, DataSource dataSource) {
        return (T)((ITsProvider)TsProviders.lookup(clazz, dataSource.getProviderName()).orNull());
    }

    @Deprecated
    public static <T extends ITsProvider> T find(Class<T> clazz, DataSet dataSet) {
        return (T)((ITsProvider)TsProviders.lookup(clazz, dataSet.getDataSource()).orNull());
    }

    @Deprecated
    public static <T extends ITsProvider> T find(Class<T> clazz, TsMoniker moniker) {
        String providerName = moniker.getSource();
        return (T)(providerName != null ? (ITsProvider)TsProviders.lookup(clazz, providerName).orNull() : null);
    }

    @Deprecated
    public static File getFile(DataSource dataSource) {
        return (File)TsProviders.tryGetFile(dataSource).orNull();
    }

    @Deprecated
    public static <P extends IDataSourceProvider> P walkProviderTree(P provider, IProviderVisitor<? super P> visitor) throws Exception {
        for (DataSource o : provider.getDataSources()) {
            if (!TsProviders.walkProviderTree(provider, visitor, o)) break;
        }
        return provider;
    }

    private static <P extends IDataSourceProvider> boolean walkProviderTree(P provider, IProviderVisitor<? super P> visitor, DataSource dataSource) throws IOException {
        if (!visitor.preVisitSource(provider, dataSource)) {
            return false;
        }
        try {
            for (DataSet o : provider.children(dataSource)) {
                if (TsProviders.walkProviderTree(provider, visitor, o, 0)) continue;
                return false;
            }
            return visitor.postVisitSource(provider, dataSource, null);
        }
        catch (IOException ex) {
            return visitor.postVisitSource(provider, dataSource, ex);
        }
    }

    private static <P extends IDataSourceProvider> boolean walkProviderTree(P provider, IProviderVisitor<? super P> visitor, DataSet dataSet, int level) throws IOException {
        switch (dataSet.getKind()) {
            case COLLECTION: {
                visitor.preVisitCollection(provider, dataSet, level);
                try {
                    for (DataSet o : provider.children(dataSet)) {
                        if (TsProviders.walkProviderTree(provider, visitor, o, level + 1)) continue;
                        return false;
                    }
                    return visitor.postVisitCollection(provider, dataSet, level, null);
                }
                catch (IOException ex) {
                    return visitor.postVisitCollection(provider, dataSet, level, ex);
                }
            }
            case DUMMY: {
                return visitor.visitDummy(provider, dataSet, level);
            }
            case SERIES: {
                return visitor.visitSeries(provider, dataSet, level);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static @NonNull Optional<File> tryGetFile(@NonNull DataSource dataSource) {
        Optional<IFileLoader> loader = TsProviders.lookup(IFileLoader.class, dataSource.getProviderName());
        if (loader.isPresent()) {
            File file = ((IFileLoader)loader.get()).decodeBean(dataSource).getFile();
            File realFile = Files2.getAbsoluteFile((File[])((IFileLoader)loader.get()).getPaths(), (File)file);
            return Optional.fromNullable((Object)realFile);
        }
        return Optional.absent();
    }

    public static @NonNull Optional<TsCollection> getTsCollection(@NonNull DataSource dataSource, @NonNull TsInformationType type) {
        IDataSourceProvider provider = TsProviders.find(IDataSourceProvider.class, dataSource);
        if (provider == null) {
            return Optional.absent();
        }
        String name = provider.getDisplayName(dataSource);
        TsMoniker moniker = provider.toMoniker(dataSource);
        return Optional.of((Object)TsFactory.instance.createTsCollection(name, moniker, type));
    }

    public static @NonNull Optional<TsCollection> getTsCollection(@NonNull DataSet dataSet, @NonNull TsInformationType type) {
        IDataSourceProvider provider = TsProviders.find(IDataSourceProvider.class, dataSet);
        if (provider == null) {
            return Optional.absent();
        }
        String name = provider.getDisplayName(dataSet);
        TsMoniker moniker = provider.toMoniker(dataSet);
        switch (dataSet.getKind()) {
            case COLLECTION: {
                return Optional.of((Object)TsFactory.instance.createTsCollection(name, moniker, type));
            }
            case DUMMY: {
                return Optional.of((Object)TsFactory.instance.createTsCollection(name));
            }
            case SERIES: {
                TsCollection result = TsFactory.instance.createTsCollection();
                result.quietAdd(TsFactory.instance.createTs(name, moniker, type));
                return Optional.of((Object)result);
            }
        }
        throw new RuntimeException("Not implemented");
    }

    public static @NonNull Optional<Ts> getTs(@NonNull DataSet dataSet, @NonNull TsInformationType type) {
        IDataSourceProvider provider = TsProviders.find(IDataSourceProvider.class, dataSet);
        if (provider == null) {
            return Optional.absent();
        }
        String name = provider.getDisplayName(dataSet);
        TsMoniker moniker = provider.toMoniker(dataSet);
        switch (dataSet.getKind()) {
            case SERIES: {
                Ts ts = TsFactory.instance.createTs(name, moniker, type);
                return Optional.of((Object)ts);
            }
        }
        throw new RuntimeException("Not implemented");
    }

    public static void prettyPrintTree(@NonNull IDataSourceProvider provider, @NonNull DataSource dataSource, @NonNegative int maxLevel, @NonNull PrintStream printStream, boolean displayName) throws IOException {
        Function<Object, String> toString = displayName ? o -> o instanceof DataSource ? provider.getDisplayName((DataSource)o) : " " + provider.getDisplayNodeName((DataSet)o) : o -> o instanceof DataSource ? provider.toMoniker((DataSource)o).getId() : " " + provider.toMoniker((DataSet)o).getId();
        Function<Object, Stream> children = o -> {
            try {
                return o instanceof DataSource ? provider.children((DataSource)o).stream() : (((DataSet)o).getKind() == DataSet.Kind.COLLECTION ? provider.children((DataSet)o).stream() : Stream.empty());
            }
            catch (IOException ex) {
                throw new UncheckedIOException(ex);
            }
        };
        try {
            Trees.prettyPrint((Object)dataSource, children, (int)maxLevel, toString, (Appendable)printStream);
        }
        catch (UncheckedIOException ex) {
            throw ex.getCause();
        }
    }
}

