/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMap;
import ec.tss.TsMoniker;
import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.HasDataDisplayName;
import ec.tss.tsproviders.HasDataHierarchy;
import ec.tss.tsproviders.HasDataMoniker;
import ec.tss.tsproviders.HasDataSourceBean;
import ec.tss.tsproviders.HasDataSourceList;
import ec.tss.tsproviders.HasDataSourceMutableList;
import ec.tss.tsproviders.HasFilePaths;
import ec.tss.tsproviders.IDataSourceListener;
import ec.tss.tsproviders.utils.DataSourceEventSupport;
import ec.tss.tsproviders.utils.DataSourcePreconditions;
import ec.tss.tsproviders.utils.IFormatter;
import ec.tss.tsproviders.utils.IParam;
import ec.tss.tsproviders.utils.IParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

final class Util {
    static final Consumer<Object> DO_NOTHING = o -> {};

    private Util() {
    }

    static ImmutableSortedMap<String, String> toImmutable(Map<String, String> params) {
        switch (params.size()) {
            case 0: {
                return ImmutableSortedMap.of();
            }
            case 1: {
                Map.Entry<String, String> first = params.entrySet().iterator().next();
                return ImmutableSortedMap.of((Comparable)((Object)first.getKey()), (Object)first.getValue());
            }
        }
        return ImmutableSortedMap.copyOf(params);
    }

    static String getDisplayNameFromMessageOrClassName(IOException exception) {
        if (exception instanceof FileNotFoundException) {
            return "File not found: " + exception.getMessage();
        }
        String message = exception.getMessage();
        return !Strings.isNullOrEmpty((String)message) ? message : exception.getClass().getSimpleName();
    }

    static final class NoOpDataHierarchy
    extends ProviderPart
    implements HasDataHierarchy {
        NoOpDataHierarchy(String providerName) {
            super(providerName);
        }

        @Override
        public List<DataSet> children(DataSource dataSource) throws IllegalArgumentException, IOException {
            this.checkProvider(dataSource);
            return Collections.emptyList();
        }

        @Override
        public List<DataSet> children(DataSet parent) throws IllegalArgumentException, IOException {
            this.checkProvider(parent);
            return Collections.emptyList();
        }
    }

    static final class FilePathSupport
    implements HasFilePaths {
        private static final File[] EMPTY = new File[0];
        private final Runnable onPathsChange;
        private final AtomicReference<File[]> paths;

        FilePathSupport(Runnable onPathsChange) {
            this.onPathsChange = Objects.requireNonNull(onPathsChange);
            this.paths = new AtomicReference<File[]>(EMPTY);
        }

        @Override
        public void setPaths(File[] paths) {
            Object[] newValue;
            Object[] objectArray = newValue = paths != null ? (File[])paths.clone() : EMPTY;
            if (!Arrays.equals(this.paths.getAndSet((File[])newValue), newValue)) {
                this.onPathsChange.run();
            }
        }

        @Override
        public File[] getPaths() {
            return (File[])this.paths.get().clone();
        }
    }

    static final class DataSourceMutableListSupport
    extends ProviderPart
    implements HasDataSourceMutableList {
        private final LinkedHashSet<DataSource> dataSources;
        private final DataSourceEventSupport eventSupport;
        private final Consumer<? super DataSource> cacheCleaner;

        DataSourceMutableListSupport(String providerName, LinkedHashSet<DataSource> dataSources, DataSourceEventSupport eventSupport, Consumer<? super DataSource> cacheCleaner) {
            super(providerName);
            this.dataSources = Objects.requireNonNull(dataSources);
            this.eventSupport = Objects.requireNonNull(eventSupport);
            this.cacheCleaner = Objects.requireNonNull(cacheCleaner);
        }

        @Override
        public void reload(DataSource dataSource) {
            this.checkProvider(dataSource);
            this.cacheCleaner.accept(dataSource);
            this.eventSupport.fireChanged(dataSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean open(DataSource dataSource) throws IllegalArgumentException {
            this.checkProvider(dataSource);
            LinkedHashSet<DataSource> linkedHashSet = this.dataSources;
            synchronized (linkedHashSet) {
                if (this.dataSources.add(dataSource)) {
                    this.eventSupport.fireOpened(dataSource);
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean close(DataSource dataSource) throws IllegalArgumentException {
            this.checkProvider(dataSource);
            LinkedHashSet<DataSource> linkedHashSet = this.dataSources;
            synchronized (linkedHashSet) {
                if (this.dataSources.remove(dataSource)) {
                    this.eventSupport.fireClosed(dataSource);
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closeAll() {
            LinkedHashSet<DataSource> linkedHashSet = this.dataSources;
            synchronized (linkedHashSet) {
                this.dataSources.clear();
                this.eventSupport.fireAllClosed(this.providerName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<DataSource> getDataSources() {
            LinkedHashSet<DataSource> linkedHashSet = this.dataSources;
            synchronized (linkedHashSet) {
                return ImmutableList.copyOf(this.dataSources);
            }
        }

        @Override
        public void addDataSourceListener(IDataSourceListener listener) {
            this.eventSupport.add(listener);
        }

        @Override
        public void removeDataSourceListener(IDataSourceListener listener) {
            this.eventSupport.remove(listener);
        }
    }

    static final class DataSourceListSupport
    extends ProviderPart
    implements HasDataSourceList {
        private final List<DataSource> dataSources;
        private final DataSourceEventSupport eventSupport;
        private final Consumer<? super DataSource> cacheCleaner;

        DataSourceListSupport(String providerName, Iterable<DataSource> dataSources, DataSourceEventSupport eventSupport, Consumer<? super DataSource> cacheCleaner) {
            super(providerName);
            this.dataSources = ImmutableList.copyOf(dataSources);
            this.eventSupport = Objects.requireNonNull(eventSupport);
            this.cacheCleaner = Objects.requireNonNull(cacheCleaner);
            dataSources.forEach(this::checkProvider);
        }

        @Override
        public void reload(DataSource dataSource) {
            this.checkProvider(dataSource);
            this.cacheCleaner.accept(dataSource);
            this.eventSupport.fireChanged(dataSource);
        }

        @Override
        public List<DataSource> getDataSources() {
            return this.dataSources;
        }

        @Override
        public void addDataSourceListener(IDataSourceListener listener) {
            this.eventSupport.add(listener);
        }

        @Override
        public void removeDataSourceListener(IDataSourceListener listener) {
            this.eventSupport.remove(listener);
        }
    }

    static final class DataSourceBeanSupport<T>
    extends ProviderPart
    implements HasDataSourceBean<T> {
        private final IParam<DataSource, T> param;
        private final String version;

        DataSourceBeanSupport(String providerName, IParam<DataSource, T> param, String version) {
            super(providerName);
            this.param = Objects.requireNonNull(param);
            this.version = Objects.requireNonNull(version);
        }

        @Override
        public T newBean() {
            return this.param.defaultValue();
        }

        @Override
        public DataSource encodeBean(Object bean) throws IllegalArgumentException {
            Objects.requireNonNull(bean);
            try {
                return ((DataSource.Builder)DataSource.builder(this.providerName, this.version).put(this.param, bean)).build();
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        @Override
        public T decodeBean(DataSource dataSource) throws IllegalArgumentException {
            this.checkProvider(dataSource);
            return this.param.get(dataSource);
        }
    }

    static final class DataMonikerSupport
    extends ProviderPart
    implements HasDataMoniker {
        private final IFormatter<DataSource> dataSourceFormatter;
        private final IFormatter<DataSet> dataSetFormatter;
        private final IParser<DataSource> dataSourceParser;
        private final IParser<DataSet> dataSetParser;

        DataMonikerSupport(String providerName, IFormatter<DataSource> dataSourceFormatter, IFormatter<DataSet> dataSetFormatter, IParser<DataSource> dataSourceParser, IParser<DataSet> dataSetParser) {
            super(providerName);
            this.dataSourceFormatter = Objects.requireNonNull(dataSourceFormatter);
            this.dataSetFormatter = Objects.requireNonNull(dataSetFormatter);
            this.dataSourceParser = Objects.requireNonNull(dataSourceParser);
            this.dataSetParser = Objects.requireNonNull(dataSetParser);
        }

        @Override
        public TsMoniker toMoniker(DataSource dataSource) throws IllegalArgumentException {
            this.checkProvider(dataSource);
            String id = this.dataSourceFormatter.formatAsString(dataSource);
            if (id == null) {
                throw new IllegalArgumentException("Cannot format DataSource");
            }
            return new TsMoniker(this.providerName, id);
        }

        @Override
        public TsMoniker toMoniker(DataSet dataSet) throws IllegalArgumentException {
            this.checkProvider(dataSet);
            String id = this.dataSetFormatter.formatAsString(dataSet);
            if (id == null) {
                throw new IllegalArgumentException("Cannot format DataSource");
            }
            return new TsMoniker(this.providerName, id);
        }

        @Override
        public DataSet toDataSet(TsMoniker moniker) throws IllegalArgumentException {
            this.checkProvider(moniker);
            String id = moniker.getId();
            return id != null ? this.dataSetParser.parse(id) : null;
        }

        @Override
        public DataSource toDataSource(TsMoniker moniker) throws IllegalArgumentException {
            this.checkProvider(moniker);
            String id = moniker.getId();
            return id != null ? this.dataSourceParser.parse(id) : null;
        }
    }

    static final class DataDisplayNameSupport
    extends ProviderPart
    implements HasDataDisplayName {
        private final IFormatter<DataSource> dataSourceFormatter;
        private final IFormatter<DataSet> dataSetFormatter;

        DataDisplayNameSupport(String providerName, IFormatter<DataSource> dataSourceFormatter, IFormatter<DataSet> dataSetFormatter) {
            super(providerName);
            this.dataSourceFormatter = Objects.requireNonNull(dataSourceFormatter);
            this.dataSetFormatter = Objects.requireNonNull(dataSetFormatter);
        }

        @Override
        public String getDisplayName(DataSource dataSource) throws IllegalArgumentException {
            this.checkProvider(dataSource);
            String result = this.dataSourceFormatter.formatAsString(dataSource);
            if (result == null) {
                throw new IllegalArgumentException("Cannot format DataSource");
            }
            return result;
        }

        @Override
        public String getDisplayName(DataSet dataSet) throws IllegalArgumentException {
            this.checkProvider(dataSet);
            String result = this.dataSetFormatter.formatAsString(dataSet);
            if (result == null) {
                throw new IllegalArgumentException("Cannot format DataSet");
            }
            return result;
        }
    }

    private static abstract class ProviderPart {
        protected final String providerName;

        ProviderPart(String providerName) {
            this.providerName = Objects.requireNonNull(providerName);
        }

        protected void checkProvider(DataSource dataSource) throws IllegalArgumentException {
            DataSourcePreconditions.checkProvider(this.providerName, dataSource);
        }

        protected void checkProvider(DataSet dataSet) throws IllegalArgumentException {
            DataSourcePreconditions.checkProvider(this.providerName, dataSet);
        }

        protected void checkProvider(TsMoniker moniker) throws IllegalArgumentException {
            DataSourcePreconditions.checkProvider(this.providerName, moniker);
        }
    }
}

