/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.cube;

import ec.tss.tsproviders.cube.CubeAccessor;
import ec.tss.tsproviders.cube.CubeId;
import ec.tss.tsproviders.cursor.TsCursor;
import ec.tss.tsproviders.utils.IteratorWithIO;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import net.jcip.annotations.ThreadSafe;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

final class CubeAccessors {
    private CubeAccessors() {
    }

    @ThreadSafe
    static final class BulkCubeAccessor
    extends ForwardingAccessor {
        private final ConcurrentMap<CubeId, Object> cache;
        private final int cacheLevel;
        private final boolean cacheEnabled;

        BulkCubeAccessor(@NonNull CubeAccessor delegate, @NonNegative int depth, @NonNull ConcurrentMap<CubeId, Object> cache) {
            super(delegate);
            this.cacheLevel = Math.max(0, delegate.getRoot().getMaxLevel() - depth);
            this.cache = cache;
            this.cacheEnabled = depth > 0;
        }

        @Override
        public TsCursor<CubeId> getAllSeriesWithData(CubeId ref) throws IOException {
            if (this.cacheEnabled && !ref.isSeries()) {
                if (ref.getLevel() == this.cacheLevel) {
                    return TsCursor.withCache(this.cache, ref, x$0 -> super.getAllSeriesWithData((CubeId)x$0));
                }
                CubeId ancestor = ref.getAncestor(this.cacheLevel);
                if (ancestor != null) {
                    return this.getAllSeriesWithData(ancestor).filter(ref::isAncestorOf);
                }
            }
            return super.getAllSeriesWithData(ref);
        }

        @Override
        public TsCursor<CubeId> getSeriesWithData(CubeId ref) throws IOException {
            CubeId ancestor;
            if (this.cacheEnabled && ref.isSeries() && (ancestor = ref.getAncestor(this.cacheLevel)) != null) {
                return this.getAllSeriesWithData(ancestor).filter(ref::equals);
            }
            return super.getSeriesWithData(ref);
        }
    }

    private static class ForwardingAccessor
    implements CubeAccessor {
        private final CubeAccessor delegate;

        ForwardingAccessor(CubeAccessor delegate) {
            this.delegate = delegate;
        }

        @Override
        public IOException testConnection() {
            return this.delegate.testConnection();
        }

        @Override
        public CubeId getRoot() {
            return this.delegate.getRoot();
        }

        @Override
        public TsCursor<CubeId> getAllSeries(CubeId id) throws IOException {
            return this.delegate.getAllSeries(id);
        }

        @Override
        public TsCursor<CubeId> getAllSeriesWithData(CubeId id) throws IOException {
            return this.delegate.getAllSeriesWithData(id);
        }

        @Override
        public TsCursor<CubeId> getSeriesWithData(CubeId id) throws IOException {
            return this.delegate.getSeriesWithData(id);
        }

        @Override
        public IteratorWithIO<CubeId> getChildren(CubeId id) throws IOException {
            return this.delegate.getChildren(id);
        }

        @Override
        public String getDisplayName() throws IOException {
            return this.delegate.getDisplayName();
        }

        @Override
        public String getDisplayName(CubeId id) throws IOException {
            return this.delegate.getDisplayName(id);
        }

        @Override
        public String getDisplayNodeName(CubeId id) throws IOException {
            return this.delegate.getDisplayNodeName(id);
        }

        @Override
        public CubeAccessor bulk(int depth, ConcurrentMap<CubeId, Object> cache) {
            return this.delegate.bulk(depth, cache);
        }
    }
}

