/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.cube;

import ec.tstoolkit.utilities.Arrays2;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CubeId {
    private static final CubeId VOID = new CubeId(Arrays2.EMPTY_STRING_ARRAY, Arrays2.EMPTY_STRING_ARRAY);
    private final String[] dimensionIds;
    private final String[] dimensionsValues;

    public static @NonNull CubeId root(String ... dimensionIds) throws IllegalArgumentException {
        for (String o : dimensionIds) {
            if (o != null) continue;
            throw new IllegalArgumentException("Dimensions cannot be null");
        }
        return dimensionIds.length == 0 ? VOID : new CubeId((String[])dimensionIds.clone(), Arrays2.EMPTY_STRING_ARRAY);
    }

    public static @NonNull CubeId root(@NonNull List<String> dimensionIds) throws IllegalArgumentException {
        for (String o : dimensionIds) {
            if (o != null) continue;
            throw new IllegalArgumentException("Dimensions cannot be null");
        }
        return dimensionIds.isEmpty() ? VOID : new CubeId(dimensionIds.toArray(new String[dimensionIds.size()]), Arrays2.EMPTY_STRING_ARRAY);
    }

    private CubeId(@NonNull String[] dimensionIds, @NonNull String[] dimensionsValues) {
        this.dimensionsValues = dimensionsValues;
        this.dimensionIds = dimensionIds;
    }

    public @NonNegative int getLevel() {
        return this.dimensionsValues.length;
    }

    public @NonNegative int getMaxLevel() {
        return this.dimensionIds.length;
    }

    public @NonNull String getDimensionValue(@NonNegative int index) throws IndexOutOfBoundsException {
        return this.dimensionsValues[index];
    }

    public @NonNull Stream<String> getDimensionValueStream() {
        return Stream.of(this.dimensionsValues);
    }

    public @NonNull String getDimensionId(@NonNegative int index) throws IndexOutOfBoundsException {
        return this.dimensionIds[index];
    }

    public @NonNegative int getDepth() {
        return this.getMaxLevel() - this.getLevel();
    }

    public boolean isRoot() {
        return this.getLevel() == 0;
    }

    public boolean isSeries() {
        return this.getLevel() == this.getMaxLevel();
    }

    public boolean isVoid() {
        return this.getMaxLevel() == 0;
    }

    public @NonNull CubeId child(String ... dimensionValues) throws IllegalArgumentException {
        if (this.dimensionsValues.length + dimensionValues.length > this.dimensionIds.length) {
            throw new IllegalArgumentException("Too much values");
        }
        for (String o : dimensionValues) {
            if (o != null) continue;
            throw new IllegalArgumentException("Dimension values cannot be null");
        }
        return new CubeId(this.dimensionIds, (String[])Arrays2.concat((Object[])this.dimensionsValues, (Object[])dimensionValues));
    }

    public boolean isAncestorOf(@NonNull CubeId input) {
        if (!this.haveSameDimensions(this, input) || this.getLevel() >= input.getLevel()) {
            return false;
        }
        for (int i = this.getLevel() - 1; i >= 0; --i) {
            if (input.getDimensionValue(i).equals(this.getDimensionValue(i))) continue;
            return false;
        }
        return true;
    }

    @Nullable CubeId getParent() {
        return this.getAncestor(this.getLevel() - 1);
    }

    @Nullable CubeId getAncestor(int level) {
        return 0 <= level && level < this.getLevel() ? new CubeId(this.dimensionIds, Arrays.copyOf(this.dimensionsValues, level)) : null;
    }

    public String toString() {
        return Arrays.toString(this.dimensionsValues);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof CubeId && this.equals((CubeId)obj);
    }

    public int hashCode() {
        return Arrays.deepHashCode(this.dimensionIds) + Arrays.deepHashCode(this.dimensionsValues);
    }

    private boolean equals(@NonNull CubeId that) {
        return CubeId.equalsReversed(this.dimensionsValues, that.dimensionsValues) && Arrays.equals(this.dimensionIds, that.dimensionIds);
    }

    private static boolean equalsReversed(@Nullable Object[] l, @Nullable Object[] r) {
        if (l == r) {
            return true;
        }
        if (l == null || r == null || l.length != r.length) {
            return false;
        }
        for (int i = l.length - 1; i >= 0; --i) {
            if (Objects.equals(l[i], r[i])) continue;
            return false;
        }
        return true;
    }

    private boolean haveSameDimensions(CubeId l, CubeId r) {
        return Arrays.equals(l.dimensionIds, r.dimensionIds);
    }
}

