/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.cube;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import ec.tss.ITsProvider;
import ec.tss.TsAsyncMode;
import ec.tss.TsCollectionInformation;
import ec.tss.TsInformationType;
import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.HasDataDisplayName;
import ec.tss.tsproviders.HasDataHierarchy;
import ec.tss.tsproviders.HasDataMoniker;
import ec.tss.tsproviders.cube.CubeAccessor;
import ec.tss.tsproviders.cube.CubeId;
import ec.tss.tsproviders.cursor.HasTsCursor;
import ec.tss.tsproviders.cursor.TsCursor;
import ec.tss.tsproviders.cursor.TsCursorAsFiller;
import ec.tss.tsproviders.utils.IConfig;
import ec.tss.tsproviders.utils.IParam;
import ec.tss.tsproviders.utils.IteratorWithIO;
import ec.tss.tsproviders.utils.TsFillerAsProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.jcip.annotations.ThreadSafe;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

@ThreadSafe
public final class CubeSupport
implements HasDataHierarchy,
HasTsCursor,
HasDataDisplayName {
    private final Resource resource;

    public static @NonNull CubeSupport of(@NonNull Resource resource) {
        return new CubeSupport(Objects.requireNonNull(resource));
    }

    private CubeSupport(Resource resource) {
        this.resource = resource;
    }

    @Override
    public List<DataSet> children(DataSource dataSource) throws IOException {
        CubeAccessor acc = this.resource.getAccessor(dataSource);
        IParam<DataSet, CubeId> idParam = this.resource.getIdParam(dataSource);
        CubeId parentId = acc.getRoot();
        if (parentId.isVoid()) {
            IOException ex = acc.testConnection();
            if (ex != null) {
                throw ex;
            }
            DataSet fake = DataSet.of(dataSource, DataSet.Kind.SERIES);
            return Collections.singletonList(fake);
        }
        DataSet.Builder builder = DataSet.builder(dataSource, DataSet.Kind.COLLECTION);
        return CubeSupport.children(builder, acc.getChildren(parentId), idParam);
    }

    @Override
    public List<DataSet> children(DataSet parent) throws IOException {
        if (!DataSet.Kind.COLLECTION.equals(parent.getKind())) {
            throw new IllegalArgumentException("Not a collection");
        }
        CubeAccessor acc = this.resource.getAccessor(parent.getDataSource());
        IParam<DataSet, CubeId> idParam = this.resource.getIdParam(parent.getDataSource());
        CubeId parentId = idParam.get(parent);
        DataSet.Builder builder = parent.toBuilder(parentId.getDepth() > 1 ? DataSet.Kind.COLLECTION : DataSet.Kind.SERIES);
        return CubeSupport.children(builder, acc.getChildren(parentId), idParam);
    }

    @Override
    public TsCursor<DataSet> getData(DataSource dataSource, TsInformationType type) throws IOException {
        CubeAccessor acc = this.resource.getAccessor(dataSource);
        IParam<DataSet, CubeId> idParam = this.resource.getIdParam(dataSource);
        CubeId parentId = acc.getRoot();
        TsCursor<CubeId> cursor = type.encompass(TsInformationType.Data) ? acc.getAllSeriesWithData(parentId) : acc.getAllSeries(parentId);
        return cursor.transform(CubeSupport.toDataSetFunc(DataSet.builder(dataSource, DataSet.Kind.SERIES), idParam));
    }

    @Override
    public TsCursor<DataSet> getData(DataSet dataSet, TsInformationType type) throws IOException {
        CubeAccessor acc = this.resource.getAccessor(dataSet.getDataSource());
        IParam<DataSet, CubeId> idParam = this.resource.getIdParam(dataSet.getDataSource());
        CubeId id = idParam.get(dataSet);
        TsCollectionInformation result = new TsCollectionInformation();
        result.type = type;
        TsCursor<CubeId> cursor = DataSet.Kind.COLLECTION.equals(dataSet.getKind()) ? (type.encompass(TsInformationType.Data) ? acc.getAllSeriesWithData(id) : acc.getAllSeries(id)) : (type.encompass(TsInformationType.Data) ? acc.getSeriesWithData(id) : TsCursor.singleton(id));
        return cursor.transform(CubeSupport.toDataSetFunc(dataSet.toBuilder(DataSet.Kind.SERIES), idParam));
    }

    @Override
    public String getDisplayName(DataSource dataSource) throws IllegalArgumentException {
        try {
            return this.resource.getAccessor(dataSource).getDisplayName();
        }
        catch (IOException ex) {
            return ex.getMessage();
        }
    }

    @Override
    public String getDisplayName(DataSet dataSet) throws IllegalArgumentException {
        try {
            DataSource dataSource = dataSet.getDataSource();
            CubeId id = this.resource.getIdParam(dataSource).get(dataSet);
            return this.resource.getAccessor(dataSource).getDisplayName(id);
        }
        catch (IOException ex) {
            return ex.getMessage();
        }
    }

    @Override
    public String getDisplayNodeName(DataSet dataSet) throws IllegalArgumentException {
        try {
            DataSource dataSource = dataSet.getDataSource();
            CubeId id = this.resource.getIdParam(dataSource).get(dataSet);
            return this.resource.getAccessor(dataSource).getDisplayNodeName(id);
        }
        catch (IOException ex) {
            return ex.getMessage();
        }
    }

    public static @NonNull IParam<DataSet, CubeId> idByName(@NonNull CubeId root) {
        return new ByNameParam(Objects.requireNonNull(root));
    }

    public static @NonNull IParam<DataSet, CubeId> idBySeparator(@NonNull CubeId root, @NonNull String separator, @NonNull String name) {
        return new BySeparatorParam(Objects.requireNonNull(separator), Objects.requireNonNull(root), Objects.requireNonNull(name));
    }

    public static @NonNull ITsProvider asTsProvider(@NonNull String providerName, @NonNull Logger logger, @NonNull CubeSupport cubeSupport, @NonNull HasDataMoniker monikerSupport, @NonNull Runnable cacheCleaner) {
        return TsFillerAsProvider.of(providerName, TsAsyncMode.Once, TsCursorAsFiller.of(logger, cubeSupport, monikerSupport, cubeSupport), cacheCleaner);
    }

    private static List<DataSet> children(DataSet.Builder builder, IteratorWithIO<CubeId> values, IParam<DataSet, CubeId> idParam) throws IOException {
        try (IteratorWithIO<DataSet> cursor = values.transform(CubeSupport.toDataSetFunc(builder, idParam));){
            ArrayList<DataSet> result = new ArrayList<DataSet>();
            while (cursor.hasNext()) {
                result.add(cursor.next());
            }
            ArrayList<DataSet> arrayList = result;
            return arrayList;
        }
    }

    private static Function<CubeId, DataSet> toDataSetFunc(DataSet.Builder builder, IParam<DataSet, CubeId> dimValuesParam) {
        return o -> ((DataSet.Builder)builder.put(dimValuesParam, o)).build();
    }

    @ThreadSafe
    public static interface Resource {
        public @NonNull CubeAccessor getAccessor(@NonNull DataSource var1) throws IOException, IllegalArgumentException;

        public @NonNull IParam<DataSet, CubeId> getIdParam(@NonNull DataSource var1) throws IOException, IllegalArgumentException;
    }

    private static final class ByNameParam
    implements IParam<DataSet, CubeId> {
        private final CubeId root;

        public ByNameParam(CubeId root) {
            this.root = root;
        }

        @Override
        public CubeId defaultValue() {
            return this.root;
        }

        @Override
        public CubeId get(DataSet config) {
            String tmp;
            ArrayList<String> result = new ArrayList<String>(this.root.getMaxLevel());
            for (int i = 0; i < this.root.getMaxLevel() && !Strings.isNullOrEmpty((String)(tmp = config.get(this.root.getDimensionId(i)))); ++i) {
                result.add(tmp);
            }
            return this.root.child(result.toArray(new String[result.size()]));
        }

        @Override
        public void set(IConfig.Builder<?, DataSet> builder, CubeId value) {
            for (int i = 0; i < value.getLevel(); ++i) {
                builder.put(value.getDimensionId(i), value.getDimensionValue(i));
            }
        }
    }

    private static final class BySeparatorParam
    implements IParam<DataSet, CubeId> {
        private final Splitter splitter;
        private final String separator;
        private final CubeId root;
        private final String name;

        public BySeparatorParam(String separator, CubeId root, String name) {
            this.splitter = Splitter.on((String)separator).trimResults();
            this.separator = separator;
            this.root = root;
            this.name = name;
        }

        @Override
        public CubeId defaultValue() {
            return this.root;
        }

        @Override
        public CubeId get(DataSet config) {
            String tmp = config.get(this.name);
            if (Strings.isNullOrEmpty((String)tmp)) {
                return this.defaultValue();
            }
            List items = this.splitter.splitToList((CharSequence)tmp);
            return this.root.child(items.toArray(new String[items.size()]));
        }

        @Override
        public void set(IConfig.Builder<?, DataSet> builder, CubeId value) {
            if (value.getLevel() > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(value.getDimensionValue(0));
                for (int i = 1; i < value.getLevel(); ++i) {
                    sb.append(this.separator).append(value.getDimensionValue(i));
                }
                builder.put(this.name, sb.toString());
            }
        }
    }
}

