/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.cube;

import ec.tss.tsproviders.cube.CubeAccessor;
import ec.tss.tsproviders.cube.CubeId;
import ec.tss.tsproviders.cursor.TsCursor;
import ec.tss.tsproviders.utils.IteratorWithIO;
import ec.tss.tsproviders.utils.OptionalTsData;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.jcip.annotations.NotThreadSafe;
import net.jcip.annotations.ThreadSafe;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@ThreadSafe
public final class TableAsCubeAccessor
implements CubeAccessor {
    private final Resource<?> resource;

    public static @NonNull TableAsCubeAccessor create(@NonNull Resource<?> resource) {
        return new TableAsCubeAccessor(Objects.requireNonNull(resource));
    }

    private TableAsCubeAccessor(Resource<?> resource) {
        this.resource = resource;
    }

    @Override
    public IOException testConnection() {
        Exception result = this.resource.testConnection();
        return result != null ? TableAsCubeAccessor.propagateIOException(result) : null;
    }

    @Override
    public CubeId getRoot() {
        return this.resource.getRoot();
    }

    @Override
    public TsCursor<CubeId> getAllSeries(CubeId id) throws IOException {
        try {
            AllSeriesCursor cursor = this.resource.getAllSeriesCursor(id);
            return new AllSeriesAdapter(id, cursor);
        }
        catch (Exception ex) {
            throw TableAsCubeAccessor.propagateIOException(ex);
        }
    }

    @Override
    public TsCursor<CubeId> getAllSeriesWithData(CubeId id) throws IOException {
        try {
            AllSeriesWithDataCursor<?> cursor = this.resource.getAllSeriesWithDataCursor(id);
            return new AllSeriesWithDataAdapter(id, cursor, this.resource.newBuilder());
        }
        catch (Exception ex) {
            throw TableAsCubeAccessor.propagateIOException(ex);
        }
    }

    @Override
    public TsCursor<CubeId> getSeriesWithData(CubeId id) throws IOException {
        try {
            SeriesWithDataCursor<?> cursor = this.resource.getSeriesWithDataCursor(id);
            return new SeriesWithDataAdapter(id, cursor, this.resource.newBuilder());
        }
        catch (Exception ex) {
            throw TableAsCubeAccessor.propagateIOException(ex);
        }
    }

    @Override
    public IteratorWithIO<CubeId> getChildren(CubeId id) throws IOException {
        try {
            ChildrenCursor cursor = this.resource.getChildrenCursor(id);
            return new ChildrenAdapter(id, cursor);
        }
        catch (Exception ex) {
            throw TableAsCubeAccessor.propagateIOException(ex);
        }
    }

    @Override
    public String getDisplayName() throws IOException {
        try {
            return this.resource.getDisplayName();
        }
        catch (Exception ex) {
            throw TableAsCubeAccessor.propagateIOException(ex);
        }
    }

    @Override
    public String getDisplayName(CubeId id) throws IOException {
        try {
            return this.resource.getDisplayName(id);
        }
        catch (Exception ex) {
            throw TableAsCubeAccessor.propagateIOException(ex);
        }
    }

    @Override
    public String getDisplayNodeName(CubeId id) throws IOException {
        try {
            return this.resource.getDisplayNodeName(id);
        }
        catch (Exception ex) {
            throw TableAsCubeAccessor.propagateIOException(ex);
        }
    }

    private static IOException propagateIOException(Exception ex) {
        return ex instanceof IOException ? (IOException)ex : new IOException(ex);
    }

    @ThreadSafe
    public static interface Resource<T> {
        public @Nullable Exception testConnection();

        public @NonNull CubeId getRoot();

        public @NonNull AllSeriesCursor getAllSeriesCursor(@NonNull CubeId var1) throws Exception;

        public @NonNull AllSeriesWithDataCursor<T> getAllSeriesWithDataCursor(@NonNull CubeId var1) throws Exception;

        public @NonNull SeriesWithDataCursor<T> getSeriesWithDataCursor(@NonNull CubeId var1) throws Exception;

        public @NonNull ChildrenCursor getChildrenCursor(@NonNull CubeId var1) throws Exception;

        public @NonNull String getDisplayName() throws Exception;

        public @NonNull String getDisplayName(@NonNull CubeId var1) throws Exception;

        public @NonNull String getDisplayNodeName(@NonNull CubeId var1) throws Exception;

        public @NonNull OptionalTsData.Builder2<T> newBuilder();
    }

    @NotThreadSafe
    public static interface AllSeriesCursor
    extends SeriesCursor {
        public @NonNull String[] getDimValues() throws Exception;
    }

    private static final class AllSeriesAdapter
    extends TableAsCubeAdapter<AllSeriesCursor> {
        private AllSeriesAdapter(CubeId parentId, AllSeriesCursor cursor) {
            super(parentId, cursor, null);
        }

        @Override
        public boolean nextSeries() throws IOException {
            try {
                return ((AllSeriesCursor)this.cursor).nextRow();
            }
            catch (Exception ex) {
                throw TableAsCubeAccessor.propagateIOException(ex);
            }
        }

        @Override
        public CubeId getSeriesId() throws IOException {
            try {
                return this.parentId.child(((AllSeriesCursor)this.cursor).getDimValues());
            }
            catch (Exception ex) {
                throw TableAsCubeAccessor.propagateIOException(ex);
            }
        }

        @Override
        public String getSeriesLabel() throws IOException, IllegalStateException {
            try {
                return ((AllSeriesCursor)this.cursor).getLabel();
            }
            catch (Exception ex) {
                throw TableAsCubeAccessor.propagateIOException(ex);
            }
        }

        @Override
        public OptionalTsData getSeriesData() throws IOException {
            throw new IOException("Not requested");
        }
    }

    @NotThreadSafe
    public static interface AllSeriesWithDataCursor<T>
    extends SeriesCursor {
        public @NonNull String[] getDimValues() throws Exception;

        public @Nullable T getPeriod() throws Exception;

        public @Nullable Number getValue() throws Exception;
    }

    private static final class AllSeriesWithDataAdapter<T>
    extends TableAsCubeAdapter<AllSeriesWithDataCursor<T>> {
        private final OptionalTsData.Builder2<T> data;
        private boolean first;
        private boolean t0;
        private String[] currentId;
        private String currentLabel;

        private AllSeriesWithDataAdapter(CubeId parentId, AllSeriesWithDataCursor cursor, OptionalTsData.Builder2<T> data) {
            super(parentId, cursor, null);
            this.data = data;
            this.first = true;
            this.t0 = false;
            this.currentId = null;
            this.currentLabel = null;
        }

        @Override
        public boolean nextSeries() throws IOException {
            try {
                if (this.first) {
                    this.t0 = ((AllSeriesWithDataCursor)this.cursor).nextRow();
                    this.first = false;
                }
                if (this.t0) {
                    this.data.clear();
                    this.currentId = ((AllSeriesWithDataCursor)this.cursor).getDimValues();
                    this.currentLabel = ((AllSeriesWithDataCursor)this.cursor).getLabel();
                    boolean t1 = true;
                    while (t1) {
                        Object period = ((AllSeriesWithDataCursor)this.cursor).getPeriod();
                        Number value = null;
                        boolean t2 = true;
                        while (t2) {
                            value = ((AllSeriesWithDataCursor)this.cursor).getValue();
                            this.t0 = ((AllSeriesWithDataCursor)this.cursor).nextRow();
                            t1 = this.t0 && Arrays.equals(this.currentId, ((AllSeriesWithDataCursor)this.cursor).getDimValues());
                            t2 = t1 && Objects.equals(period, ((AllSeriesWithDataCursor)this.cursor).getPeriod());
                        }
                        this.data.add(period, value);
                    }
                    return true;
                }
                this.currentId = null;
                this.currentLabel = null;
                return false;
            }
            catch (Exception ex) {
                throw TableAsCubeAccessor.propagateIOException(ex);
            }
        }

        @Override
        public CubeId getSeriesId() throws IOException {
            return this.parentId.child(this.currentId);
        }

        @Override
        public String getSeriesLabel() throws IOException, IllegalStateException {
            return this.currentLabel;
        }

        @Override
        public OptionalTsData getSeriesData() throws IOException {
            return this.data.build();
        }
    }

    @NotThreadSafe
    public static interface SeriesWithDataCursor<T>
    extends SeriesCursor {
        public @Nullable T getPeriod() throws Exception;

        public @Nullable Number getValue() throws Exception;
    }

    private static final class SeriesWithDataAdapter<T>
    extends TableAsCubeAdapter<SeriesWithDataCursor<T>> {
        private final OptionalTsData.Builder2<T> data;
        private String currentLabel;

        private SeriesWithDataAdapter(CubeId parentId, SeriesWithDataCursor cursor, OptionalTsData.Builder2<T> data) {
            super(parentId, cursor, null);
            this.data = data;
            this.currentLabel = null;
        }

        @Override
        public boolean nextSeries() throws IOException {
            try {
                boolean t0 = ((SeriesWithDataCursor)this.cursor).nextRow();
                if (t0) {
                    this.currentLabel = ((SeriesWithDataCursor)this.cursor).getLabel();
                    Object latestPeriod = ((SeriesWithDataCursor)this.cursor).getPeriod();
                    while (t0) {
                        Object period = latestPeriod;
                        Number value = null;
                        boolean t1 = true;
                        while (t1) {
                            value = ((SeriesWithDataCursor)this.cursor).getValue();
                            t0 = ((SeriesWithDataCursor)this.cursor).nextRow();
                            t1 = t0 && Objects.equals(period, latestPeriod = ((SeriesWithDataCursor)this.cursor).getPeriod());
                        }
                        this.data.add(period, value);
                    }
                    return true;
                }
                this.currentLabel = null;
                return false;
            }
            catch (Exception ex) {
                throw TableAsCubeAccessor.propagateIOException(ex);
            }
        }

        @Override
        public CubeId getSeriesId() throws IOException {
            return this.parentId;
        }

        @Override
        public String getSeriesLabel() throws IOException, IllegalStateException {
            return this.currentLabel;
        }

        @Override
        public OptionalTsData getSeriesData() throws IOException {
            return this.data.build();
        }
    }

    @NotThreadSafe
    public static interface ChildrenCursor
    extends TableCursor {
        public @NonNull String getChild() throws Exception;
    }

    private static final class ChildrenAdapter
    implements IteratorWithIO<CubeId> {
        private final CubeId parentId;
        private final ChildrenCursor cursor;
        private boolean hasNext;

        private ChildrenAdapter(CubeId parentId, ChildrenCursor cursor) throws Exception {
            this.parentId = parentId;
            this.cursor = cursor;
            this.hasNext = cursor.nextRow();
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.hasNext;
        }

        @Override
        public CubeId next() throws IOException, NoSuchElementException {
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            try {
                CubeId result = this.parentId.child(this.cursor.getChild());
                this.hasNext = this.cursor.nextRow();
                return result;
            }
            catch (Exception ex) {
                throw TableAsCubeAccessor.propagateIOException(ex);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.cursor.close();
            }
            catch (Exception ex) {
                throw TableAsCubeAccessor.propagateIOException(ex);
            }
        }
    }

    private static abstract class TableAsCubeAdapter<T extends SeriesCursor>
    implements TsCursor<CubeId> {
        protected final CubeId parentId;
        protected final T cursor;

        private TableAsCubeAdapter(CubeId parentId, T cursor) {
            this.parentId = parentId;
            this.cursor = cursor;
        }

        @Override
        public boolean isClosed() throws IOException {
            try {
                return this.cursor.isClosed();
            }
            catch (Exception ex) {
                throw TableAsCubeAccessor.propagateIOException(ex);
            }
        }

        @Override
        public Map<String, String> getMetaData() throws IOException {
            try {
                return this.cursor.getMetaData();
            }
            catch (Exception ex) {
                throw TableAsCubeAccessor.propagateIOException(ex);
            }
        }

        @Override
        public Map<String, String> getSeriesMetaData() throws IOException {
            return Collections.emptyMap();
        }

        @Override
        public void close() throws IOException {
            try {
                this.cursor.close();
            }
            catch (Exception ex) {
                throw TableAsCubeAccessor.propagateIOException(ex);
            }
        }

        /* synthetic */ TableAsCubeAdapter(CubeId x0, SeriesCursor x1, 1 x2) {
            this(x0, x1);
        }
    }

    @NotThreadSafe
    public static interface SeriesCursor
    extends TableCursor {
        public @NonNull Map<String, String> getMetaData() throws Exception;

        public @NonNull String getLabel() throws Exception;
    }

    @NotThreadSafe
    public static interface TableCursor
    extends AutoCloseable {
        public boolean isClosed() throws Exception;

        public boolean nextRow() throws Exception;
    }
}

