/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.cursor;

import ec.tss.tsproviders.cursor.TsCursors;
import ec.tss.tsproviders.utils.FunctionWithIO;
import ec.tss.tsproviders.utils.OptionalTsData;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import net.jcip.annotations.NotThreadSafe;
import org.checkerframework.checker.nullness.qual.NonNull;

@NotThreadSafe
public interface TsCursor<ID>
extends Closeable {
    public boolean isClosed() throws IOException;

    public @NonNull Map<String, String> getMetaData() throws IOException, IllegalStateException;

    public boolean nextSeries() throws IOException, IllegalStateException;

    public @NonNull ID getSeriesId() throws IOException, IllegalStateException;

    public @NonNull String getSeriesLabel() throws IOException, IllegalStateException;

    public @NonNull Map<String, String> getSeriesMetaData() throws IOException, IllegalStateException;

    public @NonNull OptionalTsData getSeriesData() throws IOException, IllegalStateException;

    default public <Z> @NonNull TsCursor<Z> transform(@NonNull Function<? super ID, ? extends Z> function) {
        return new TsCursors.TransformingCursor<ID, Z>(this, function);
    }

    default public @NonNull TsCursor<ID> filter(@NonNull Predicate<? super ID> predicate) {
        return new TsCursors.FilteringCursor<ID>(this, predicate);
    }

    default public @NonNull TsCursor<ID> withMetaData(@NonNull Map<String, String> meta) {
        return new TsCursors.WithMetaDataCursor(this, meta);
    }

    default public @NonNull TsCursor<ID> onClose(@NonNull Closeable closeHandler) {
        return new TsCursors.OnCloseCursor(this, closeHandler);
    }

    public static <ID> @NonNull TsCursor<ID> empty() {
        return new TsCursors.EmptyCursor();
    }

    public static <ID> @NonNull TsCursor<ID> singleton(@NonNull ID id, @NonNull OptionalTsData data, @NonNull Map<String, String> meta, @NonNull String label) {
        return new TsCursors.SingletonCursor<ID>(id, data, meta, label);
    }

    public static <ID> @NonNull TsCursor<ID> singleton(@NonNull ID id, @NonNull OptionalTsData data, @NonNull Map<String, String> meta) {
        return new TsCursors.SingletonCursor<ID>(id, data, meta, id.toString());
    }

    public static <ID> @NonNull TsCursor<ID> singleton(@NonNull ID id, @NonNull OptionalTsData data) {
        return new TsCursors.SingletonCursor<ID>(id, data, Collections.emptyMap(), id.toString());
    }

    public static <ID> @NonNull TsCursor<ID> singleton(@NonNull ID id) {
        return new TsCursors.SingletonCursor<ID>(id, TsCursors.NOT_REQUESTED, Collections.emptyMap(), id.toString());
    }

    public static <E> @NonNull TsCursor<E> from(@NonNull Iterator<E> iterator, @NonNull Function<? super E, OptionalTsData> toData, @NonNull Function<? super E, Map<String, String>> toMeta, @NonNull Function<? super E, String> toLabel) {
        return new TsCursors.IteratingCursor(iterator, Function.identity(), toData, toMeta, toLabel);
    }

    public static <E> @NonNull TsCursor<E> from(@NonNull Iterator<E> iterator, @NonNull Function<? super E, OptionalTsData> toData, @NonNull Function<? super E, Map<String, String>> toMeta) {
        return new TsCursors.IteratingCursor(iterator, Function.identity(), toData, toMeta, Object::toString);
    }

    public static <E> @NonNull TsCursor<E> from(@NonNull Iterator<E> iterator, @NonNull Function<? super E, OptionalTsData> toData) {
        return new TsCursors.IteratingCursor(iterator, Function.identity(), toData, TsCursors.NO_META, Object::toString);
    }

    public static <E> @NonNull TsCursor<E> from(@NonNull Iterator<E> iterator) {
        return new TsCursors.IteratingCursor(iterator, Function.identity(), TsCursors.NO_DATA, TsCursors.NO_META, Object::toString);
    }

    public static <KEY, ID> @NonNull TsCursor<ID> withCache(@NonNull ConcurrentMap<KEY, Object> cache, @NonNull KEY key, @NonNull FunctionWithIO<? super KEY, ? extends TsCursor<ID>> loader) throws IOException {
        return TsCursors.getOrLoad(cache, key, loader);
    }
}

