/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.cursor;

import ec.tss.TsCollectionInformation;
import ec.tss.TsInformation;
import ec.tss.TsInformationType;
import ec.tss.tsproviders.DataSet;
import ec.tss.tsproviders.DataSource;
import ec.tss.tsproviders.HasDataDisplayName;
import ec.tss.tsproviders.HasDataMoniker;
import ec.tss.tsproviders.cursor.HasTsCursor;
import ec.tss.tsproviders.cursor.TsCursor;
import ec.tss.tsproviders.utils.OptionalTsData;
import ec.tss.tsproviders.utils.TsFiller;
import ec.tstoolkit.MetaData;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;

public final class TsCursorAsFiller {
    private TsCursorAsFiller() {
    }

    public static @NonNull TsFiller of(@NonNull Logger logger, @NonNull HasTsCursor hdc, @NonNull HasDataMoniker hdm, @NonNull HasDataDisplayName hddn) {
        return new ComposedFiller(new CursorResource(logger, hdc, hdm, hddn));
    }

    private static final class ComposedFiller
    implements TsFiller {
        private final Resource resource;

        ComposedFiller(@NonNull Resource resource) {
            this.resource = Objects.requireNonNull(resource);
        }

        @Override
        public boolean fillCollection(TsCollectionInformation info) {
            DataSource dataSource = this.resource.toDataSource(info);
            if (ComposedFiller.isCollection(dataSource)) {
                try {
                    return this.resource.fill(info, dataSource);
                }
                catch (IOException ex) {
                    return this.resource.reportException(info, dataSource, ex);
                }
            }
            DataSet dataSet = this.resource.toDataSet(info);
            if (ComposedFiller.isCollection(dataSet)) {
                try {
                    return this.resource.fill(info, dataSet);
                }
                catch (IOException ex) {
                    return this.resource.reportException(info, dataSet, ex);
                }
            }
            return this.resource.reportInvalid(info);
        }

        @Override
        public boolean fillSeries(TsInformation info) {
            DataSet dataSet = this.resource.toDataSet(info);
            if (ComposedFiller.isSeries(dataSet)) {
                try {
                    return this.resource.fill(info, dataSet);
                }
                catch (IOException ex) {
                    return this.resource.reportException(info, dataSet, ex);
                }
            }
            return this.resource.reportInvalid(info);
        }

        private static boolean isCollection(DataSource dataSource) {
            return dataSource != null;
        }

        private static boolean isCollection(DataSet dataSet) {
            return dataSet != null && DataSet.Kind.COLLECTION.equals(dataSet.getKind());
        }

        private static boolean isSeries(DataSet dataSet) {
            return dataSet != null && DataSet.Kind.SERIES.equals(dataSet.getKind());
        }
    }

    private static final class CursorResource
    implements Resource {
        private final Logger logger;
        private final HasTsCursor htc;
        private final HasDataMoniker hdm;
        private final HasDataDisplayName hddn;

        CursorResource(@NonNull Logger logger, @NonNull HasTsCursor htc, @NonNull HasDataMoniker hdm, @NonNull HasDataDisplayName hddn) {
            this.logger = Objects.requireNonNull(logger, "Logger");
            this.htc = Objects.requireNonNull(htc, "HasTsCursor");
            this.hdm = Objects.requireNonNull(hdm, "HasDataMoniker");
            this.hddn = Objects.requireNonNull(hddn, "HasDataDisplayName");
        }

        @Override
        public DataSource toDataSource(TsCollectionInformation info) {
            return this.hdm.toDataSource(info.moniker);
        }

        @Override
        public DataSet toDataSet(TsCollectionInformation info) {
            return this.hdm.toDataSet(info.moniker);
        }

        @Override
        public DataSet toDataSet(TsInformation info) {
            return this.hdm.toDataSet(info.moniker);
        }

        @Override
        public boolean reportException(TsCollectionInformation info, DataSet dataSet, IOException ex) {
            this.logger.info("Failed to get collection '" + info.moniker + "'", (Throwable)ex);
            info.invalidDataCause = this.hddn.getDisplayName(ex);
            return false;
        }

        @Override
        public boolean reportException(TsCollectionInformation info, DataSource dataSource, IOException ex) {
            this.logger.info("Failed to get collection '" + info.moniker + "'", (Throwable)ex);
            info.invalidDataCause = this.hddn.getDisplayName(ex);
            return false;
        }

        @Override
        public boolean reportException(TsInformation info, DataSet dataSet, IOException ex) {
            this.logger.info("Failed to get series '" + info.moniker + "'", (Throwable)ex);
            info.invalidDataCause = this.hddn.getDisplayName(ex);
            return false;
        }

        @Override
        public boolean reportInvalid(TsCollectionInformation info) {
            this.logger.warn("Invalid collection moniker '{}'", (Object)info.moniker);
            info.invalidDataCause = "Invalid moniker";
            return false;
        }

        @Override
        public boolean reportInvalid(TsInformation info) {
            this.logger.warn("Invalid ts moniker '{}'", (Object)info.moniker);
            info.invalidDataCause = "Invalid moniker";
            return false;
        }

        @Override
        public boolean fill(TsCollectionInformation info, DataSource dataSource) throws IOException {
            try (TsCursor<DataSet> cursor = this.htc.getData(dataSource, info.type);){
                this.fill(info, cursor);
                boolean bl = true;
                return bl;
            }
        }

        @Override
        public boolean fill(TsCollectionInformation info, DataSet dataSet) throws IOException {
            try (TsCursor<DataSet> cursor = this.htc.getData(dataSet, info.type);){
                this.fill(info, cursor);
                boolean bl = true;
                return bl;
            }
        }

        @Override
        public boolean fill(TsInformation info, DataSet dataSet) throws IOException {
            try (TsCursor<DataSet> cursor = this.htc.getData(dataSet, info.type);){
                if (cursor.nextSeries()) {
                    info.name = cursor.getSeriesLabel();
                    this.fill(info, cursor);
                    boolean bl = true;
                    return bl;
                }
                info.invalidDataCause = "Missing time series";
                boolean bl = false;
                return bl;
            }
        }

        private void fill(TsCollectionInformation info, TsCursor<DataSet> cursor) throws IOException {
            if (info.type.encompass(TsInformationType.MetaData)) {
                this.fillMeta(info, cursor);
            }
            while (cursor.nextSeries()) {
                DataSet dataSet = cursor.getSeriesId();
                TsInformation item = new TsInformation(cursor.getSeriesLabel(), this.hdm.toMoniker(dataSet), info.type);
                this.fill(item, cursor);
                info.items.add(item);
            }
        }

        private void fill(TsInformation info, TsCursor<DataSet> cursor) throws IOException {
            if (info.type.encompass(TsInformationType.MetaData)) {
                this.fillMeta(info, cursor);
            }
            if (info.type.encompass(TsInformationType.Data)) {
                this.fillData(info, cursor);
            }
        }

        private void fillData(TsInformation info, TsCursor<DataSet> cursor) throws IOException {
            OptionalTsData data = cursor.getSeriesData();
            if (data.isPresent()) {
                info.data = data.get();
                info.invalidDataCause = null;
            } else {
                info.data = null;
                info.invalidDataCause = data.getCause();
            }
        }

        private void fillMeta(TsCollectionInformation info, TsCursor<DataSet> cursor) throws IOException {
            Map<String, String> meta = cursor.getMetaData();
            info.metaData = !meta.isEmpty() ? new MetaData(meta) : null;
        }

        private void fillMeta(TsInformation info, TsCursor<DataSet> cursor) throws IOException {
            Map<String, String> meta = cursor.getSeriesMetaData();
            info.metaData = !meta.isEmpty() ? new MetaData(meta) : null;
        }
    }

    private static interface Resource {
        public DataSource toDataSource(TsCollectionInformation var1);

        public boolean fill(TsCollectionInformation var1, DataSource var2) throws IOException;

        public boolean reportException(TsCollectionInformation var1, DataSource var2, IOException var3);

        public DataSet toDataSet(TsCollectionInformation var1);

        public boolean fill(TsCollectionInformation var1, DataSet var2) throws IOException;

        public boolean reportException(TsCollectionInformation var1, DataSet var2, IOException var3);

        public boolean reportInvalid(TsCollectionInformation var1);

        public DataSet toDataSet(TsInformation var1);

        public boolean fill(TsInformation var1, DataSet var2) throws IOException;

        public boolean reportException(TsInformation var1, DataSet var2, IOException var3);

        public boolean reportInvalid(TsInformation var1);
    }
}

