/*
 * Decompiled with CFR 0.152.
 */
package ec.tss.tsproviders.cursor;

import com.google.common.collect.Iterators;
import ec.tss.tsproviders.cursor.TsCursor;
import ec.tss.tsproviders.utils.FunctionWithIO;
import ec.tss.tsproviders.utils.OptionalTsData;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Predicate;
import nbbrd.io.Resource;
import net.jcip.annotations.Immutable;
import org.checkerframework.checker.nullness.qual.NonNull;

final class TsCursors {
    static final OptionalTsData NOT_REQUESTED = OptionalTsData.absent("Not requested");
    static final Function<Object, Map<String, String>> NO_META = o -> Collections.emptyMap();
    static final Function<Object, OptionalTsData> NO_DATA = o -> NOT_REQUESTED;
    static final String CLOSE_ISE = "This cursor is closed";
    static final String NEXT_ISE = "This cursor has no more series or has not been started";
    static final String ID_NPE = "id";
    static final String DATA_NPE = "data";
    static final String META_DATA_NPE = "meta data";
    static final String LABEL_NPE = "label";
    static final String DELEGATE_NPE = "delegate";
    static final String ID_FILTER_NPE = "id filter";
    static final String ID_TRANSFORMER_NPE = "id transformer";
    static final String CLOSE_HANDLER_NPE = "close handler";

    private TsCursors() {
    }

    private static <X, Y> Y applyNotNull(String funcName, Function<X, Y> func, X input) throws RuntimeException {
        Y result = func.apply(input);
        if (result != null) {
            return result;
        }
        throw new RuntimeException("Invalid function '" + funcName + "': expected non-null result with parameter + '" + input + "'");
    }

    static <KEY, ID> @NonNull TsCursor<ID> getOrLoad(@NonNull ConcurrentMap<KEY, Object> cache, @NonNull KEY key, @NonNull FunctionWithIO<? super KEY, ? extends TsCursor<ID>> loader) throws IOException {
        Objects.requireNonNull(cache, "cache");
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(loader, "loader");
        Object result = cache.get(key);
        return result instanceof XCollection ? ((XCollection)result).toCursor() : new CachingCursor<KEY, ID>(loader.apply(key), key, cache);
    }

    private static <E, ID> Iterator<E> compose(Iterator<E> iterator, Function<? super E, ? extends ID> toId, Predicate<? super ID> predicate) {
        return Iterators.filter(iterator, o -> predicate.test((Object)TsCursors.applyNotNull(ID_NPE, toId, o)));
    }

    @Immutable
    static final class XCollection<ID>
    implements Iterable<XSeries<ID>> {
        private final Map<String, String> meta;
        private final List<XSeries<ID>> items;

        private XCollection(Map<String, String> meta, List<XSeries<ID>> items) {
            this.meta = Collections.unmodifiableMap(meta);
            this.items = Collections.unmodifiableList(items);
        }

        public Map<String, String> getMetaData() {
            return this.meta;
        }

        @Override
        public Iterator<XSeries<ID>> iterator() {
            return this.items.iterator();
        }

        public TsCursor<ID> toCursor() {
            return new IteratingCursor<XSeries, Object>(this.iterator(), XSeries::getId, XSeries::getData, XSeries::getMetadata, XSeries::getLabel).withMetaData((Map)this.meta);
        }
    }

    static final class CachingCursor<KEY, ID>
    extends ForwardingCursor<ID> {
        private final KEY key;
        private final ConcurrentMap<KEY, Object> cache;
        private final List<XSeries<ID>> items;
        private XSeries<ID> currentItem;

        CachingCursor(TsCursor<ID> delegate, KEY key, ConcurrentMap<KEY, Object> cache) {
            super(delegate);
            this.key = key;
            this.cache = cache;
            this.items = new ArrayList<XSeries<ID>>();
            this.currentItem = null;
        }

        private void checkState() throws IllegalStateException, IOException {
            if (this.isClosed()) {
                throw new IllegalStateException(TsCursors.CLOSE_ISE);
            }
            if (this.currentItem == null) {
                throw new IllegalStateException(TsCursors.NEXT_ISE);
            }
        }

        @Override
        public Map<String, String> getMetaData() throws IOException {
            return this.delegate.getMetaData();
        }

        @Override
        public boolean nextSeries() throws IOException {
            if (this.delegate.nextSeries()) {
                this.currentItem = this.fetchCurrentSeries();
                return true;
            }
            this.currentItem = null;
            return false;
        }

        @Override
        public ID getSeriesId() throws IOException {
            this.checkState();
            return this.currentItem.getId();
        }

        @Override
        public String getSeriesLabel() throws IOException, IllegalStateException {
            this.checkState();
            return this.currentItem.getLabel();
        }

        @Override
        public Map<String, String> getSeriesMetaData() throws IOException {
            this.checkState();
            return this.currentItem.getMetadata();
        }

        @Override
        public OptionalTsData getSeriesData() throws IOException {
            this.checkState();
            return this.currentItem.getData();
        }

        @Override
        public void close() throws IOException {
            Resource.closeBoth(this::flushToCache, this.delegate::close);
        }

        private void flushToCache() throws IOException {
            if (!this.isClosed()) {
                while (this.delegate.nextSeries()) {
                    this.fetchCurrentSeries();
                }
                this.cache.put(this.key, new XCollection(this.delegate.getMetaData(), this.items));
            }
        }

        private XSeries<ID> fetchCurrentSeries() throws IOException {
            XSeries item = new XSeries(this.delegate.getSeriesId(), this.delegate.getSeriesLabel(), this.delegate.getSeriesMetaData(), this.delegate.getSeriesData());
            this.items.add(item);
            return item;
        }
    }

    static final class IteratingCursor<E, ID>
    extends InMemoryCursor<ID> {
        private Iterator<E> iterator;
        private Function<? super E, ? extends ID> toId;
        private final Function<? super E, OptionalTsData> toData;
        private final Function<? super E, Map<String, String>> toMeta;
        private final Function<? super E, String> toLabel;
        private E current;

        IteratingCursor(@NonNull Iterator<E> iterator, @NonNull Function<? super E, ? extends ID> toId, @NonNull Function<? super E, OptionalTsData> toData, @NonNull Function<? super E, Map<String, String>> toMeta, @NonNull Function<? super E, String> toLabel) {
            this.iterator = Objects.requireNonNull(iterator, "iterator");
            this.toId = Objects.requireNonNull(toId, "id extractor");
            this.toData = Objects.requireNonNull(toData, "data extractor");
            this.toMeta = Objects.requireNonNull(toMeta, "meta extractor");
            this.toLabel = Objects.requireNonNull(toLabel, "label extractor");
        }

        private void checkSeriesState() throws IllegalStateException {
            if (this.current == null) {
                throw new IllegalStateException(TsCursors.NEXT_ISE);
            }
        }

        @Override
        public boolean nextSeries() {
            this.checkClosedState();
            this.current = this.iterator.hasNext() ? this.iterator.next() : null;
            return this.current != null;
        }

        @Override
        public ID getSeriesId() {
            this.checkClosedState();
            this.checkSeriesState();
            return (ID)TsCursors.applyNotNull(TsCursors.ID_NPE, this.toId, this.current);
        }

        @Override
        public String getSeriesLabel() {
            this.checkClosedState();
            this.checkSeriesState();
            return (String)TsCursors.applyNotNull(TsCursors.LABEL_NPE, this.toLabel, this.current);
        }

        @Override
        public Map<String, String> getSeriesMetaData() {
            this.checkClosedState();
            this.checkSeriesState();
            return (Map)TsCursors.applyNotNull("meta", this.toMeta, this.current);
        }

        @Override
        public OptionalTsData getSeriesData() {
            this.checkClosedState();
            this.checkSeriesState();
            return (OptionalTsData)TsCursors.applyNotNull(TsCursors.DATA_NPE, this.toData, this.current);
        }

        public IteratingCursor<E, ID> filter(Predicate<? super ID> predicate) {
            this.iterator = TsCursors.compose(this.iterator, this.toId, Objects.requireNonNull(predicate, TsCursors.ID_FILTER_NPE));
            return this;
        }

        public <Z> IteratingCursor<E, Z> transform(Function<? super ID, ? extends Z> function) {
            IteratingCursor result = this;
            result.toId = this.toId.andThen(Objects.requireNonNull(function, TsCursors.ID_TRANSFORMER_NPE));
            return result;
        }
    }

    static final class SingletonCursor<ID>
    extends InMemoryCursor<ID> {
        private ID id;
        private final OptionalTsData data;
        private final Map<String, String> meta;
        private final String label;
        private Boolean first;

        SingletonCursor(@NonNull ID id, @NonNull OptionalTsData data, @NonNull Map<String, String> meta, @NonNull String label) {
            this.id = Objects.requireNonNull(id, TsCursors.ID_NPE);
            this.data = Objects.requireNonNull(data, TsCursors.DATA_NPE);
            this.meta = Objects.requireNonNull(meta, TsCursors.META_DATA_NPE);
            this.label = Objects.requireNonNull(label, TsCursors.LABEL_NPE);
            this.first = true;
        }

        private void checkSeriesState() throws IllegalStateException {
            if (this.first == null || this.first.booleanValue()) {
                throw new IllegalStateException(TsCursors.NEXT_ISE);
            }
        }

        @Override
        public boolean nextSeries() {
            this.checkClosedState();
            if (Boolean.TRUE.equals(this.first)) {
                this.first = false;
                return true;
            }
            if (Boolean.FALSE.equals(this.first)) {
                this.first = null;
                return false;
            }
            return false;
        }

        @Override
        public ID getSeriesId() {
            this.checkClosedState();
            this.checkSeriesState();
            return this.id;
        }

        @Override
        public String getSeriesLabel() {
            this.checkClosedState();
            this.checkSeriesState();
            return this.label;
        }

        @Override
        public Map<String, String> getSeriesMetaData() {
            this.checkClosedState();
            this.checkSeriesState();
            return this.meta;
        }

        @Override
        public OptionalTsData getSeriesData() {
            this.checkClosedState();
            this.checkSeriesState();
            return this.data;
        }

        @Override
        public SingletonCursor<ID> filter(Predicate<? super ID> predicate) {
            Objects.requireNonNull(predicate, TsCursors.ID_FILTER_NPE);
            this.first = this.first != null && this.first != false && predicate.test(this.id);
            return this;
        }

        @Override
        public <Z> SingletonCursor<Z> transform(Function<? super ID, ? extends Z> function) {
            Objects.requireNonNull(function, TsCursors.ID_TRANSFORMER_NPE);
            SingletonCursor result = this;
            result.id = TsCursors.applyNotNull(TsCursors.ID_NPE, function, this.id);
            return result;
        }
    }

    static final class EmptyCursor<ID>
    extends InMemoryCursor<ID> {
        EmptyCursor() {
        }

        @Override
        public boolean nextSeries() {
            this.checkClosedState();
            return false;
        }

        @Override
        public ID getSeriesId() {
            this.checkClosedState();
            throw new IllegalStateException(TsCursors.NEXT_ISE);
        }

        @Override
        public String getSeriesLabel() {
            this.checkClosedState();
            throw new IllegalStateException(TsCursors.NEXT_ISE);
        }

        @Override
        public Map<String, String> getSeriesMetaData() {
            this.checkClosedState();
            throw new IllegalStateException(TsCursors.NEXT_ISE);
        }

        @Override
        public OptionalTsData getSeriesData() {
            this.checkClosedState();
            throw new IllegalStateException(TsCursors.NEXT_ISE);
        }

        @Override
        public EmptyCursor<ID> filter(Predicate<? super ID> predicate) {
            Objects.requireNonNull(predicate, TsCursors.ID_FILTER_NPE);
            return this;
        }

        @Override
        public <Z> EmptyCursor<Z> transform(Function<? super ID, ? extends Z> function) {
            Objects.requireNonNull(function, TsCursors.ID_TRANSFORMER_NPE);
            return this;
        }
    }

    static abstract class InMemoryCursor<ID>
    implements TsCursor<ID> {
        private boolean closed = false;
        private Map<String, String> meta = Collections.emptyMap();
        private Closeable closeable = null;

        InMemoryCursor() {
        }

        protected void checkClosedState() throws IllegalStateException {
            if (this.closed) {
                throw new IllegalStateException(TsCursors.CLOSE_ISE);
            }
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public final Map<String, String> getMetaData() {
            this.checkClosedState();
            return this.meta;
        }

        @Override
        public abstract boolean nextSeries();

        @Override
        public abstract ID getSeriesId();

        @Override
        public abstract String getSeriesLabel();

        @Override
        public abstract Map<String, String> getSeriesMetaData();

        @Override
        public abstract OptionalTsData getSeriesData();

        @Override
        public final void close() throws IOException {
            this.closed = true;
            if (this.closeable != null) {
                this.closeable.close();
            }
        }

        @Override
        public final InMemoryCursor<ID> withMetaData(Map<String, String> meta) {
            Objects.requireNonNull(meta, TsCursors.META_DATA_NPE);
            this.meta = meta;
            return this;
        }

        @Override
        public final InMemoryCursor<ID> onClose(Closeable closeHandler) {
            Objects.requireNonNull(closeHandler, TsCursors.CLOSE_HANDLER_NPE);
            this.closeable = this.closeable == null ? closeHandler : this.compose(closeHandler);
            return this;
        }

        private Closeable compose(Closeable closeHandler) {
            Closeable first = this.closeable;
            return () -> Resource.closeBoth((Closeable)first, (Closeable)closeHandler);
        }
    }

    static final class OnCloseCursor<ID>
    extends ForwardingCursor<ID> {
        private final Closeable closeHandler;

        OnCloseCursor(@NonNull TsCursor<ID> delegate, @NonNull Closeable closeHandler) {
            super(delegate);
            this.closeHandler = Objects.requireNonNull(closeHandler, TsCursors.CLOSE_HANDLER_NPE);
        }

        @Override
        public void close() throws IOException {
            Resource.closeBoth((Closeable)this.delegate, (Closeable)this.closeHandler);
        }
    }

    static final class WithMetaDataCursor<ID>
    extends ForwardingCursor<ID> {
        private final Map<String, String> meta;

        WithMetaDataCursor(@NonNull TsCursor<ID> delegate, @NonNull Map<String, String> meta) {
            super(delegate);
            this.meta = Objects.requireNonNull(meta, TsCursors.META_DATA_NPE);
        }

        @Override
        public Map<String, String> getMetaData() throws IOException {
            return this.meta;
        }
    }

    static final class FilteringCursor<ID>
    extends ForwardingCursor<ID> {
        private final Predicate<? super ID> filter;

        FilteringCursor(@NonNull TsCursor<ID> delegate, @NonNull Predicate<? super ID> filter) {
            super(delegate);
            this.filter = Objects.requireNonNull(filter, TsCursors.ID_FILTER_NPE);
        }

        @Override
        public boolean nextSeries() throws IOException {
            while (this.delegate.nextSeries()) {
                if (!this.filter.test(this.delegate.getSeriesId())) continue;
                return true;
            }
            return false;
        }
    }

    static final class TransformingCursor<ID, Z>
    extends ForwardingCursor<Z> {
        private final Function<? super ID, ? extends Z> function;

        TransformingCursor(@NonNull TsCursor<ID> delegate, @NonNull Function<? super ID, ? extends Z> function) {
            super(delegate);
            this.function = Objects.requireNonNull(function, TsCursors.ID_TRANSFORMER_NPE);
        }

        @Override
        public Z getSeriesId() throws IOException {
            Object id = this.delegate.getSeriesId();
            return (Z)TsCursors.applyNotNull(TsCursors.ID_NPE, this.function, id);
        }
    }

    private static class ForwardingCursor<ID>
    implements TsCursor<ID> {
        protected final TsCursor<ID> delegate;

        private ForwardingCursor(TsCursor<ID> delegate) {
            this.delegate = Objects.requireNonNull(delegate, TsCursors.DELEGATE_NPE);
        }

        @Override
        public boolean isClosed() throws IOException {
            return this.delegate.isClosed();
        }

        @Override
        public Map<String, String> getMetaData() throws IOException {
            return this.delegate.getMetaData();
        }

        @Override
        public boolean nextSeries() throws IOException {
            return this.delegate.nextSeries();
        }

        @Override
        public ID getSeriesId() throws IOException {
            return this.delegate.getSeriesId();
        }

        @Override
        public String getSeriesLabel() throws IOException, IllegalStateException {
            return this.delegate.getSeriesLabel();
        }

        @Override
        public Map<String, String> getSeriesMetaData() throws IOException {
            return this.delegate.getSeriesMetaData();
        }

        @Override
        public OptionalTsData getSeriesData() throws IOException {
            return this.delegate.getSeriesData();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }

    @Immutable
    static final class XSeries<ID> {
        private final ID id;
        private final String label;
        private final Map<String, String> metadata;
        private final OptionalTsData data;

        private XSeries(ID id, String label, Map<String, String> metadata, OptionalTsData data) {
            this.id = id;
            this.label = label;
            this.metadata = metadata;
            this.data = data;
        }

        public ID getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public OptionalTsData getData() {
            return this.data;
        }

        public Map<String, String> getMetadata() {
            return this.metadata;
        }
    }
}

